/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.test.ArtifactTestCase;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCompilerTest
extends ArtifactTestCase {
    private boolean compilerDebug = false;
    private boolean compilerDeprecationWarnings = false;
    private boolean forceJavacCompilerUse = false;

    protected abstract String getRoleHint();

    protected void setCompilerDebug(boolean flag) {
        this.compilerDebug = flag;
    }

    protected void setCompilerDeprecationWarnings(boolean flag) {
        this.compilerDeprecationWarnings = flag;
    }

    public void setForceJavacCompilerUse(boolean forceJavacCompilerUse) {
        this.forceJavacCompilerUse = forceJavacCompilerUse;
    }

    protected List<String> getClasspath() throws Exception {
        ArrayList<String> cp = new ArrayList<String>();
        File file = this.getLocalArtifactPath("commons-lang", "commons-lang", "2.0", "jar");
        AbstractCompilerTest.assertTrue((String)("test prerequisite: commons-lang library must be available in local repository, expected " + file.getAbsolutePath()), (boolean)file.canRead());
        cp.add(file.getAbsolutePath());
        return cp;
    }

    protected void configureCompilerConfig(CompilerConfiguration compilerConfig) {
    }

    public void testCompilingSources() throws Exception {
        int expectedWarnings;
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        TreeSet<String> files = new TreeSet<String>();
        for (CompilerConfiguration compilerConfig : this.getCompilerConfigurations()) {
            File outputDir = new File(compilerConfig.getOutputLocation());
            Compiler compiler = (Compiler)this.lookup(Compiler.ROLE, this.getRoleHint());
            messages.addAll(compiler.performCompile(compilerConfig).getCompilerMessages());
            if (!outputDir.isDirectory()) continue;
            files.addAll(this.normalizePaths(FileUtils.getFileNames((File)outputDir, null, null, (boolean)false)));
        }
        int numCompilerErrors = this.compilerErrorCount(messages);
        int numCompilerWarnings = messages.size() - numCompilerErrors;
        int expectedErrors = this.expectedErrors();
        if (expectedErrors != numCompilerErrors) {
            System.out.println(numCompilerErrors + " error(s) found:");
            ArrayList<String> errors = new ArrayList<String>();
            for (CompilerMessage error : messages) {
                if (!error.isError()) continue;
                System.out.println("----");
                System.out.println(error.getFile());
                System.out.println(error.getMessage());
                System.out.println("----");
                errors.add(error.getMessage());
            }
            AbstractCompilerTest.assertEquals((String)("Wrong number of compilation errors (" + numCompilerErrors + "/" + expectedErrors + ") : " + errors), (int)expectedErrors, (int)numCompilerErrors);
        }
        if ((expectedWarnings = this.expectedWarnings()) != numCompilerWarnings) {
            ArrayList<String> warnings = new ArrayList<String>();
            System.out.println(numCompilerWarnings + " warning(s) found:");
            for (CompilerMessage error : messages) {
                if (error.isError()) continue;
                System.out.println("----");
                System.out.println(error.getFile());
                System.out.println(error.getMessage());
                System.out.println("----");
                warnings.add(error.getMessage());
            }
            AbstractCompilerTest.assertEquals((String)("Wrong number (" + numCompilerWarnings + "/" + expectedWarnings + ") of compilation warnings: " + warnings), (int)expectedWarnings, (int)numCompilerWarnings);
        }
        AbstractCompilerTest.assertEquals(new TreeSet<String>(this.normalizePaths(this.expectedOutputFiles())), files);
    }

    private List<CompilerConfiguration> getCompilerConfigurations() throws Exception {
        String sourceDir = AbstractCompilerTest.getBasedir() + "/src/test-input/src/main";
        List filenames = FileUtils.getFileNames((File)new File(sourceDir), (String)"**/*.java", null, (boolean)false, (boolean)true);
        Collections.sort(filenames);
        ArrayList<CompilerConfiguration> compilerConfigurations = new ArrayList<CompilerConfiguration>();
        int index = 0;
        for (String filename : filenames) {
            String source;
            CompilerConfiguration compilerConfig = new CompilerConfiguration();
            compilerConfig.setDebug(this.compilerDebug);
            compilerConfig.setShowDeprecation(this.compilerDeprecationWarnings);
            compilerConfig.setClasspathEntries(this.getClasspath());
            compilerConfig.addSourceLocation(sourceDir);
            compilerConfig.setOutputLocation(AbstractCompilerTest.getBasedir() + "/target/" + this.getRoleHint() + "/classes-" + index);
            FileUtils.deleteDirectory((String)compilerConfig.getOutputLocation());
            compilerConfig.addInclude(filename);
            compilerConfig.setForceJavacCompilerUse(this.forceJavacCompilerUse);
            this.configureCompilerConfig(compilerConfig);
            String target = this.getTargetVersion();
            if (StringUtils.isNotEmpty((String)target)) {
                compilerConfig.setTargetVersion(target);
            }
            if (StringUtils.isNotEmpty((String)(source = this.getSourceVersion()))) {
                compilerConfig.setSourceVersion(source);
            }
            compilerConfigurations.add(compilerConfig);
            ++index;
        }
        return compilerConfigurations;
    }

    public String getTargetVersion() {
        return null;
    }

    public String getSourceVersion() {
        return null;
    }

    private List<String> normalizePaths(Collection<String> relativePaths) {
        ArrayList<String> normalizedPaths = new ArrayList<String>();
        for (String relativePath : relativePaths) {
            normalizedPaths.add(relativePath.replace(File.separatorChar, '/'));
        }
        return normalizedPaths;
    }

    protected int compilerErrorCount(List<CompilerMessage> messages) {
        int count = 0;
        for (CompilerMessage message : messages) {
            count += message.isError() ? 1 : 0;
        }
        return count;
    }

    protected int expectedErrors() {
        return 1;
    }

    protected int expectedWarnings() {
        return 0;
    }

    protected Collection<String> expectedOutputFiles() {
        return Collections.emptyList();
    }

    protected File getLocalArtifactPath(String groupId, String artifactId, String version, String type) {
        VersionRange versionRange = VersionRange.createFromVersion((String)version);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, versionRange, "compile", type, null, (ArtifactHandler)new DefaultArtifactHandler(type));
        return this.getLocalArtifactPath((Artifact)artifact);
    }

    protected String getJavaVersion() {
        int lastDot;
        String javaVersion;
        String realJavaVersion = javaVersion = System.getProperty("java.version");
        int dotIdx = javaVersion.indexOf(".");
        if (dotIdx > -1 && (dotIdx = javaVersion.indexOf(".", (lastDot = dotIdx) + 1)) > lastDot) {
            javaVersion = javaVersion.substring(0, dotIdx);
        }
        System.out.println("java.version is: " + realJavaVersion + "\ntrimmed java version is: " + javaVersion + "\ncomparison: \"1.5\".compareTo( \"" + javaVersion + "\" ) == " + "1.5".compareTo(javaVersion) + "\n");
        return javaVersion;
    }
}

