/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.testing.PlexusTest;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.io.FileMatchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@PlexusTest
public abstract class AbstractCompilerTest {
    private boolean compilerDebug = false;
    private boolean compilerDeprecationWarnings = false;
    private boolean forceJavacCompilerUse = false;
    @Inject
    private Map<String, Compiler> compilers;
    @Inject
    private LocalRepositoryProvider localRepositoryProvider;
    private LocalRepositoryManager localRepositoryManager;

    protected abstract String getRoleHint();

    @BeforeEach
    final void setUpLocalRepo() throws Exception {
        String localRepo = System.getProperty("maven.repo.local");
        MatcherAssert.assertThat((String)"system property maven.repo.local", (Object)localRepo, (Matcher)Matchers.notNullValue());
        LocalRepository localRepository = new LocalRepository(localRepo);
        MatcherAssert.assertThat((String)("test prerequisite: local repository path: " + localRepository.getBasedir()), (Object)localRepository.getBasedir(), (Matcher)FileMatchers.aReadableFile());
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        this.localRepositoryManager = this.localRepositoryProvider.newLocalRepositoryManager((RepositorySystemSession)session, localRepository);
    }

    protected void setCompilerDebug(boolean flag) {
        this.compilerDebug = flag;
    }

    protected void setCompilerDeprecationWarnings(boolean flag) {
        this.compilerDeprecationWarnings = flag;
    }

    public void setForceJavacCompilerUse(boolean forceJavacCompilerUse) {
        this.forceJavacCompilerUse = forceJavacCompilerUse;
    }

    protected final Compiler getCompiler() {
        return this.compilers.get(this.getRoleHint());
    }

    protected List<String> getClasspath() throws Exception {
        ArrayList<String> cp = new ArrayList<String>();
        File file = this.getLocalArtifactPath("commons-lang", "commons-lang", "2.0", "jar");
        MatcherAssert.assertThat((String)("test prerequisite: commons-lang library must be available in local repository at " + file), (Object)file, (Matcher)FileMatchers.aReadableFile());
        cp.add(file.getAbsolutePath());
        return cp;
    }

    protected void configureCompilerConfig(CompilerConfiguration compilerConfig) {
    }

    @Test
    public void testCompilingSources() throws Exception {
        int expectedWarnings;
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        ArrayList<String> files = new ArrayList<String>();
        for (CompilerConfiguration compilerConfig : this.getCompilerConfigurations()) {
            File outputDir = new File(compilerConfig.getOutputLocation());
            messages.addAll(this.getCompiler().performCompile(compilerConfig).getCompilerMessages());
            if (!outputDir.isDirectory()) continue;
            files.addAll(this.normalizePaths(FileUtils.getFileNames((File)outputDir, null, null, (boolean)false)));
        }
        int numCompilerErrors = this.compilerErrorCount(messages);
        int numCompilerWarnings = messages.size() - numCompilerErrors;
        int expectedErrors = this.expectedErrors();
        if (expectedErrors != numCompilerErrors) {
            System.out.println(numCompilerErrors + " error(s) found:");
            ArrayList<String> errors = new ArrayList<String>();
            for (CompilerMessage error : messages) {
                if (!error.isError()) continue;
                System.out.println("----");
                System.out.println(error.getFile());
                System.out.println(error.getMessage());
                System.out.println("----");
                errors.add(error.getMessage());
            }
            MatcherAssert.assertThat((String)("Wrong number of compilation errors (" + numCompilerErrors + "/" + expectedErrors + ") : " + this.displayLines(errors)), (Object)numCompilerErrors, (Matcher)Matchers.is((Object)expectedErrors));
        }
        if ((expectedWarnings = this.expectedWarnings()) != numCompilerWarnings) {
            ArrayList<String> warnings = new ArrayList<String>();
            System.out.println(numCompilerWarnings + " warning(s) found:");
            for (CompilerMessage error : messages) {
                if (error.isError()) continue;
                System.out.println("----");
                System.out.println(error.getFile());
                System.out.println(error.getMessage());
                System.out.println("----");
                warnings.add(error.getMessage());
            }
            MatcherAssert.assertThat((String)("Wrong number (" + numCompilerWarnings + "/" + expectedWarnings + ") of compilation warnings: " + this.displayLines(warnings)), (Object)numCompilerWarnings, (Matcher)Matchers.is((Object)expectedWarnings));
        }
        MatcherAssert.assertThat(files, (Matcher)Matchers.containsInAnyOrder((Object[])this.normalizePaths(this.expectedOutputFiles()).toArray(new String[0])));
    }

    protected String displayLines(List<String> warnings) {
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        for (String warning : warnings) {
            sb.append('-').append(warning).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private List<CompilerConfiguration> getCompilerConfigurations() throws Exception {
        String sourceDir = "src/test-input/src/main";
        List filenames = FileUtils.getFileNames((File)new File(sourceDir), (String)"**/*.java", null, (boolean)false, (boolean)true);
        Collections.sort(filenames);
        ArrayList<CompilerConfiguration> compilerConfigurations = new ArrayList<CompilerConfiguration>();
        int index = 0;
        for (String filename : filenames) {
            String source;
            CompilerConfiguration compilerConfig = new CompilerConfiguration();
            compilerConfig.setDebug(this.compilerDebug);
            compilerConfig.setShowDeprecation(this.compilerDeprecationWarnings);
            compilerConfig.setClasspathEntries(this.getClasspath());
            compilerConfig.addSourceLocation(sourceDir);
            compilerConfig.setOutputLocation("target/" + this.getRoleHint() + "/classes-" + index);
            FileUtils.deleteDirectory((String)compilerConfig.getOutputLocation());
            compilerConfig.addInclude(filename);
            compilerConfig.setForceJavacCompilerUse(this.forceJavacCompilerUse);
            this.configureCompilerConfig(compilerConfig);
            String target = this.getTargetVersion();
            if (StringUtils.isNotEmpty((String)target)) {
                compilerConfig.setTargetVersion(target);
            }
            if (StringUtils.isNotEmpty((String)(source = this.getSourceVersion()))) {
                compilerConfig.setSourceVersion(source);
            }
            compilerConfigurations.add(compilerConfig);
            ++index;
        }
        return compilerConfigurations;
    }

    public String getTargetVersion() {
        return null;
    }

    public String getSourceVersion() {
        return null;
    }

    private List<String> normalizePaths(Collection<String> relativePaths) {
        return relativePaths.stream().map(s -> s.replace(File.separatorChar, '/')).collect(Collectors.toList());
    }

    protected int compilerErrorCount(List<CompilerMessage> messages) {
        int count = 0;
        for (CompilerMessage message : messages) {
            count += message.isError() ? 1 : 0;
        }
        return count;
    }

    protected int expectedErrors() {
        return 1;
    }

    protected int expectedWarnings() {
        return 0;
    }

    protected Collection<String> expectedOutputFiles() {
        return Collections.emptyList();
    }

    protected File getLocalArtifactPath(String groupId, String artifactId, String version, String type) {
        VersionRange versionRange = VersionRange.createFromVersion((String)version);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, versionRange, "compile", type, null, (ArtifactHandler)new DefaultArtifactHandler(type));
        return this.getLocalArtifactPath((Artifact)artifact);
    }

    protected String getJavaVersion() {
        int lastDot;
        String javaVersion;
        String realJavaVersion = javaVersion = System.getProperty("java.version");
        int dotIdx = javaVersion.indexOf(".");
        if (dotIdx > -1 && (dotIdx = javaVersion.indexOf(".", (lastDot = dotIdx) + 1)) > lastDot) {
            javaVersion = javaVersion.substring(0, dotIdx);
        }
        System.out.println("java.version is: " + realJavaVersion + "\ntrimmed java version is: " + javaVersion + "\ncomparison: \"1.5\".compareTo( \"" + javaVersion + "\" ) == " + "1.5".compareTo(javaVersion) + "\n");
        return javaVersion;
    }

    protected File getLocalArtifactPath(Artifact artifact) {
        return new File(this.localRepositoryManager.getRepository().getBasedir(), this.localRepositoryManager.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact)));
    }
}

