/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.test.ArtifactTestCase;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractCompilerTest
extends ArtifactTestCase {
    private boolean compilerDebug = false;
    private boolean compilerDeprecationWarnings = false;

    protected abstract String getRoleHint();

    protected void setCompilerDebug(boolean flag) {
        this.compilerDebug = flag;
    }

    protected void setCompilerDeprecationWarnings(boolean flag) {
        this.compilerDeprecationWarnings = flag;
    }

    protected List getClasspath() throws Exception {
        VersionRange versionRange = VersionRange.createFromVersion((String)"2.0");
        DefaultArtifact artifact = new DefaultArtifact("commons-lang", "commons-lang", versionRange, "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar"));
        ArrayList<String> cp = new ArrayList<String>();
        cp.add(this.getLocalArtifactPath((Artifact)artifact).getAbsolutePath());
        return cp;
    }

    public void testCompilingSources() throws Exception {
        CompilerError error;
        Iterator it;
        ArrayList messages = new ArrayList();
        Iterator it2 = this.getCompilerConfigurations().iterator();
        while (it2.hasNext()) {
            CompilerConfiguration compilerConfig = (CompilerConfiguration)it2.next();
            Compiler compiler = (Compiler)this.lookup(Compiler.ROLE, this.getRoleHint());
            messages.addAll(compiler.compile(compilerConfig));
        }
        int numCompilerErrors = this.compilerErrorCount(messages);
        int numCompilerWarnings = messages.size() - numCompilerErrors;
        if (this.expectedErrors() != numCompilerErrors) {
            it = messages.iterator();
            while (it.hasNext()) {
                error = (CompilerError)it.next();
                if (!error.isError()) continue;
                System.err.println("----");
                System.err.println(error.getFile() + ":" + error.getMessage());
                System.err.println("----");
            }
            Assert.assertEquals((String)"Wrong number of compilation errors.", (int)this.expectedErrors(), (int)numCompilerErrors);
        }
        if (this.expectedWarnings() != numCompilerWarnings) {
            it = messages.iterator();
            while (it.hasNext()) {
                error = (CompilerError)it.next();
                if (error.isError()) continue;
                System.err.println("----");
                System.err.println(error.getFile() + ":" + error.getMessage());
                System.err.println("----");
            }
            Assert.assertEquals((String)"Wrong number of compilation warnings.", (int)this.expectedWarnings(), (int)numCompilerWarnings);
        }
    }

    private List getCompilerConfigurations() throws Exception {
        String sourceDir = PlexusTestCase.getBasedir() + "/src/test-input/src/main";
        List filenames = FileUtils.getFileNames((File)new File(sourceDir), (String)"**/*.java", null, (boolean)false, (boolean)true);
        ArrayList<CompilerConfiguration> compilerConfigurations = new ArrayList<CompilerConfiguration>();
        Iterator it = filenames.iterator();
        while (it.hasNext()) {
            String filename = (String)it.next();
            CompilerConfiguration compilerConfig = new CompilerConfiguration();
            compilerConfig.setDebug(this.compilerDebug);
            compilerConfig.setShowDeprecation(this.compilerDeprecationWarnings);
            compilerConfig.setClasspathEntries(this.getClasspath());
            compilerConfig.addSourceLocation(sourceDir);
            compilerConfig.setOutputLocation(PlexusTestCase.getBasedir() + "/target/" + this.getRoleHint() + "/classes");
            compilerConfig.addInclude(filename);
            compilerConfigurations.add(compilerConfig);
        }
        return compilerConfigurations;
    }

    protected int compilerErrorCount(List messages) {
        int count = 0;
        for (int i = 0; i < messages.size(); ++i) {
            count += ((CompilerError)messages.get(i)).isError() ? 1 : 0;
        }
        return count;
    }

    protected int expectedErrors() {
        return 1;
    }

    protected int expectedWarnings() {
        return 0;
    }
}

