/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac.errorprone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.JavacCompiler;
import org.codehaus.plexus.compiler.javac.JavaxToolsCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacCompilerWithErrorProne
extends JavacCompiler {
    private ClassWorld classWorld = new ClassWorld();
    private static final String REALM_ID = "error-prone";

    protected CompilerResult compileOutOfProcess(CompilerConfiguration config, String executable, String[] args) throws CompilerException {
        throw new UnsupportedOperationException("Cannot compile out-of-process with error-prone");
    }

    protected ClassLoader getErrorProneCompilerClassLoader() throws MalformedURLException, NoSuchRealmException {
        try {
            String javaHome = System.getProperty("java.home");
            File toolsJar = new File(javaHome, "../lib/tools.jar");
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            this.getLogger().debug("javaHome:" + javaHome);
            this.getLogger().debug("toolsJar:" + toolsJar.getPath());
            URL[] originalUrls = ((URLClassLoader)tccl).getURLs();
            URL[] urls = new URL[originalUrls.length + 1];
            urls[0] = toolsJar.toURI().toURL();
            System.arraycopy(originalUrls, 0, urls, 1, originalUrls.length);
            ClassRealm urlClassLoader = this.classWorld.newRealm(REALM_ID);
            for (URL url : urls) {
                urlClassLoader.addConstituent(url);
            }
            this.getLogger().debug("urls:" + Arrays.asList(urls));
            return urlClassLoader.getClassLoader();
        }
        catch (DuplicateRealmException e) {
            if (REALM_ID.equals(e.getId())) {
                return this.classWorld.getRealm(REALM_ID).getClassLoader();
            }
            throw new NoSuchRealmException(this.classWorld, REALM_ID);
        }
    }

    protected Class<?> createJavacClass() throws CompilerException {
        try {
            return this.getErrorProneCompilerClassLoader().loadClass("com.google.errorprone.ErrorProneCompiler$Builder");
        }
        catch (ClassNotFoundException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchRealmException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
    }

    protected CompilerResult compileInProcessWithProperClassloader(Class<?> javacClass, String[] args) throws CompilerException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            final ArrayList messages = new ArrayList();
            DiagnosticListener<JavaFileObject> listener = new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    CompilerMessage compilerMessage = new CompilerMessage(diagnostic.getSource() == null ? null : diagnostic.getSource().getName(), JavaxToolsCompiler.convertKind(diagnostic), (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber(), -1, -1, diagnostic.getMessage(Locale.getDefault()));
                    messages.add(compilerMessage);
                }
            };
            Thread.currentThread().setContextClassLoader(this.getErrorProneCompilerClassLoader());
            Object builderInstance = javacClass.newInstance();
            Method listenToDiagnostics = javacClass.getMethod("listenToDiagnostics", DiagnosticListener.class);
            builderInstance = listenToDiagnostics.invoke(builderInstance, listener);
            Method build = javacClass.getMethod("build", new Class[0]);
            Object compiler = build.invoke(builderInstance, new Object[0]);
            Method compile = compiler.getClass().getMethod("compile", String[].class);
            Object resultObj = compile.invoke(compiler, new Object[]{args});
            boolean success = resultObj instanceof Integer ? (Integer)resultObj == 0 : this.isJdk8OK(resultObj);
            CompilerResult compilerResult = new CompilerResult(success, messages);
            return compilerResult;
        }
        catch (InvocationTargetException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchRealmException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private boolean isJdk8OK(Object resultObj) throws CompilerException {
        try {
            return (Boolean)resultObj.getClass().getMethod("isOK", new Class[0]).invoke(resultObj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
    }
}

