/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac.errorprone;

import com.google.errorprone.ErrorProneJavaCompiler;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.tools.JavaCompiler;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.InProcessCompiler;
import org.codehaus.plexus.compiler.javac.JavacCompiler;
import org.codehaus.plexus.compiler.javac.JavaxToolsCompiler;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Compiler.class, hint="javac-with-errorprone")
public class JavacCompilerWithErrorProne
extends JavacCompiler {
    public String getCompilerId() {
        return "javac-with-errorprone";
    }

    protected InProcessCompiler inProcessCompiler() {
        if (Thread.currentThread().getContextClassLoader().getResource("java/lang/module/ModuleReference.class") == null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            URL[] urls = ((URLClassLoader)contextClassLoader).getURLs();
            try {
                NonDelegatingClassLoader loader = new NonDelegatingClassLoader(urls, contextClassLoader);
                Class<?> clazz = Class.forName(CompilerInvoker.class.getName(), true, loader);
                return (InProcessCompiler)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return new CompilerInvoker();
    }

    public static class CompilerInvoker
    extends JavaxToolsCompiler {
        protected JavaCompiler newJavaCompiler() {
            return new ErrorProneJavaCompiler();
        }
    }

    private static class NonDelegatingClassLoader
    extends URLClassLoader {
        ClassLoader original;

        public NonDelegatingClassLoader(URL[] urls, ClassLoader original) throws MalformedURLException {
            super(urls, (ClassLoader)null);
            this.original = original;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> loadClass(String name, boolean complete) throws ClassNotFoundException {
            if (name.contentEquals(CompilerResult.class.getName()) || name.contentEquals(InProcessCompiler.class.getName()) || name.contentEquals(CompilerConfiguration.class.getName()) || name.contentEquals(CompilerConfiguration.CompilerReuseStrategy.class.getName()) || name.contentEquals(CompilerException.class.getName()) || name.contentEquals(CompilerMessage.class.getName()) || name.contentEquals(CompilerMessage.Kind.class.getName())) {
                return this.original.loadClass(name);
            }
            try {
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> c = this.findLoadedClass(name);
                    if (c != null) {
                        return c;
                    }
                    return this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, complete);
            }
        }
    }
}

