/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.eclipse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.plexus.compiler.CompilerMessage;

public class EcjResponseParser {
    private static final XMLInputFactory FACTORY = EcjResponseParser.getStreamFactory();

    private static XMLInputFactory getStreamFactory() {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xmlif;
    }

    public List<CompilerMessage> parse(File xmltf, boolean errorsAsWarnings) throws Exception {
        ArrayList<CompilerMessage> list = new ArrayList<CompilerMessage>();
        try (BufferedReader src = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmltf), "utf-8"));){
            XMLStreamReader xsr = FACTORY.createXMLStreamReader(src);
            while (xsr.hasNext()) {
                int type = xsr.next();
                if (type != 1 || !"source".equals(xsr.getLocalName())) continue;
                this.decodeSourceElement(list, xsr, errorsAsWarnings);
            }
        }
        return list;
    }

    private void decodeSourceElement(List<CompilerMessage> list, XMLStreamReader xsr, boolean errorsAsWarnings) throws Exception {
        String filename = xsr.getAttributeValue(null, "path");
        File path = new File(filename).getCanonicalFile();
        while (xsr.hasNext()) {
            int type = xsr.nextTag();
            if (type == 1) {
                if ("problems".equals(xsr.getLocalName())) {
                    this.decodeProblems(list, path.toString(), xsr, errorsAsWarnings);
                    continue;
                }
                EcjResponseParser.ignoreTillEnd(xsr);
                continue;
            }
            if (type != 2) continue;
            return;
        }
    }

    private void decodeProblems(List<CompilerMessage> list, String sourcePath, XMLStreamReader xsr, boolean errorsAsWarnings) throws Exception {
        while (xsr.hasNext()) {
            int type = xsr.nextTag();
            if (type == 1) {
                if ("problem".equals(xsr.getLocalName())) {
                    this.decodeProblem(list, sourcePath, xsr, errorsAsWarnings);
                    continue;
                }
                EcjResponseParser.ignoreTillEnd(xsr);
                continue;
            }
            if (type != 2) continue;
            return;
        }
    }

    private void decodeProblem(List<CompilerMessage> list, String sourcePath, XMLStreamReader xsr, boolean errorsAsWarnings) throws Exception {
        String id = xsr.getAttributeValue(null, "optionKey");
        int startline = EcjResponseParser.getInt(xsr, "line");
        int column = EcjResponseParser.getInt(xsr, "charStart");
        int endCol = EcjResponseParser.getInt(xsr, "charEnd");
        String sev = xsr.getAttributeValue(null, "severity");
        String message = "Unknown message?";
        while (xsr.hasNext()) {
            int type = xsr.nextTag();
            if (type == 1) {
                if ("message".equals(xsr.getLocalName())) {
                    message = xsr.getAttributeValue(null, "value");
                }
                EcjResponseParser.ignoreTillEnd(xsr);
                continue;
            }
            if (type != 2) continue;
            break;
        }
        CompilerMessage.Kind msgtype = "warning".equalsIgnoreCase(sev) ? CompilerMessage.Kind.WARNING : ("error".equalsIgnoreCase(sev) ? (errorsAsWarnings ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.ERROR) : ("info".equalsIgnoreCase(sev) ? CompilerMessage.Kind.NOTE : CompilerMessage.Kind.OTHER));
        CompilerMessage cm = new CompilerMessage(sourcePath, msgtype, startline, column, startline, endCol, message);
        list.add(cm);
    }

    private static void ignoreTillEnd(XMLStreamReader xsr) throws Exception {
        int depth = 1;
        while (xsr.hasNext()) {
            int type = xsr.next();
            if (type == 1) {
                ++depth;
                continue;
            }
            if (type != 2 || --depth != 0) continue;
            return;
        }
    }

    private static int getInt(XMLStreamReader xsr, String name) throws IOException {
        String v = xsr.getAttributeValue(null, name);
        if (null == v) {
            return -1;
        }
        try {
            return Integer.parseInt(v.trim());
        }
        catch (Exception x) {
            throw new IOException("Illegal integer value '" + v + "' in attribute " + name);
        }
    }
}

