/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.eclipse;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.eclipse.EcjResponseParser;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;

public class EclipseJavaCompiler
extends AbstractCompiler {
    boolean errorsAsWarnings = false;

    public EclipseJavaCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        CompilerResult compilerResult;
        Object propFile;
        Map extras;
        String targetVersion;
        ArrayList<String> args = new ArrayList<String>();
        if (config.isDebug()) {
            args.add("-preserveAllLocals");
            args.add("-g:lines,vars,source");
        } else {
            args.add("-g:lines,source");
        }
        String sourceVersion = this.decodeVersion(config.getSourceVersion());
        if (sourceVersion != null) {
            args.add("-source");
            args.add(sourceVersion);
        }
        if ((targetVersion = this.decodeVersion(config.getTargetVersion())) != null) {
            args.add("-target");
            args.add(targetVersion);
        }
        if (StringUtils.isNotEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        if (!config.isShowWarnings()) {
            args.add("-warn:none");
        } else {
            StringBuilder warns = new StringBuilder();
            if (config.isShowDeprecation()) {
                EclipseJavaCompiler.append(warns, "+deprecation");
            } else {
                EclipseJavaCompiler.append(warns, "-deprecation");
            }
            args.add("-warn:" + warns);
        }
        if (config.isParameters()) {
            args.add("-parameters");
        }
        if ((extras = config.getCustomCompilerArgumentsAsMap()).containsKey("errorsAsWarnings")) {
            extras.remove("errorsAsWarnings");
            this.errorsAsWarnings = true;
        } else if (extras.containsKey("-errorsAsWarnings")) {
            extras.remove("-errorsAsWarnings");
            this.errorsAsWarnings = true;
        }
        String props = (String)extras.get("-properties");
        if (!(null == props || ((File)(propFile = new File(props))).exists() && ((File)propFile).isFile())) {
            throw new IllegalArgumentException("Properties file specified by -properties " + propFile + " does not exist");
        }
        for (Map.Entry entry : extras.entrySet()) {
            String opt = (String)entry.getKey();
            if (!opt.startsWith("-")) {
                opt = "-" + opt;
            }
            args.add(opt);
            String value = (String)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            args.add(value);
        }
        args.add("-d");
        args.add(config.getOutputLocation());
        ArrayList<String> extraSourceDirs = new ArrayList<String>();
        if (!this.isPreJava16(config)) {
            String[] stringArray = config.getAnnotationProcessors();
            List processorPathEntries = config.getProcessorPathEntries();
            if (stringArray != null && stringArray.length > 0 || processorPathEntries != null && processorPathEntries.size() > 0) {
                File generatedSourcesDir;
                if (stringArray != null && stringArray.length > 0) {
                    args.add("-processor");
                    StringBuilder sb = new StringBuilder();
                    for (String ap : stringArray) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(ap);
                    }
                    args.add(sb.toString());
                }
                if (processorPathEntries != null && processorPathEntries.size() > 0) {
                    args.add("-processorpath");
                    args.add(EclipseJavaCompiler.getPathString((List)processorPathEntries));
                }
                if ((generatedSourcesDir = config.getGeneratedSourcesDirectory()) != null) {
                    generatedSourcesDir.mkdirs();
                    extraSourceDirs.add(generatedSourcesDir.getAbsolutePath());
                    args.add("-s");
                    args.add(generatedSourcesDir.getAbsolutePath());
                }
                if (config.getProc() != null) {
                    args.add("-proc:" + config.getProc());
                }
            }
        }
        if (extras.containsKey("-proceedOnError")) {
            args.add("-proceedOnError:Fatal");
        }
        ArrayList<String> arrayList = new ArrayList<String>(config.getClasspathEntries());
        arrayList.add(config.getOutputLocation());
        args.add("-classpath");
        args.add(EclipseJavaCompiler.getPathString(arrayList));
        File errorF = null;
        try {
            errorF = File.createTempFile("ecjerr-", ".xml");
            args.add("-log");
            args.add(errorF.toString());
            int argCount = args.size();
            for (String source : config.getSourceLocations()) {
                File srcFile = new File(source);
                if (!srcFile.exists()) continue;
                Set ss = EclipseJavaCompiler.getSourceFilesForSourceRoot((CompilerConfiguration)config, (String)source);
                args.addAll(ss);
            }
            args.addAll(extraSourceDirs);
            if (args.size() == argCount) {
                CompilerResult compilerResult2 = new CompilerResult(true, Collections.EMPTY_LIST);
                return compilerResult2;
            }
            StringWriter sw = new StringWriter();
            PrintWriter devNull = new PrintWriter(sw);
            BatchCompiler.compile((String[])args.toArray(new String[args.size()]), (PrintWriter)devNull, (PrintWriter)devNull, (CompilationProgress)new CompilationProgress(){

                public void begin(int i) {
                }

                public void done() {
                }

                public boolean isCanceled() {
                    return false;
                }

                public void setTaskName(String s) {
                }

                public void worked(int i, int i1) {
                }
            });
            this.getLogger().debug(sw.toString());
            boolean hasError = false;
            if (errorF.length() < 80L) {
                throw new IOException("Failed to run the ECJ compiler:\n" + sw.toString());
            }
            List<CompilerMessage> messageList = new EcjResponseParser().parse(errorF, this.errorsAsWarnings);
            for (CompilerMessage compilerMessage : messageList) {
                if (!compilerMessage.isError()) continue;
                hasError = true;
                break;
            }
            compilerResult = new CompilerResult(!hasError, messageList);
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            if (null != errorF) {
                try {
                    errorF.delete();
                }
                catch (Exception exception) {}
            }
        }
        return compilerResult;
    }

    private static void append(StringBuilder warns, String s) {
        if (warns.length() > 0) {
            warns.append(',');
        }
        warns.append(s);
    }

    private boolean isPreJava16(CompilerConfiguration config) {
        String s = config.getSourceVersion();
        if (s == null) {
            return true;
        }
        return s.startsWith("1.5") || s.startsWith("1.4") || s.startsWith("1.3") || s.startsWith("1.2") || s.startsWith("1.1") || s.startsWith("1.0");
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return null;
    }

    private String decodeVersion(String versionSpec) {
        if (StringUtils.isEmpty((String)versionSpec)) {
            return null;
        }
        if (versionSpec.equals("1.9")) {
            this.getLogger().warn("Version 9 should be specified as 9, not 1.9");
            return "9";
        }
        return versionSpec;
    }
}

