/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.csharp;

import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.util.StringUtils;

public class DefaultCSharpCompilerParser {
    private static String ERROR_PREFIX = "error ";
    private static String COMPILATION_PREFIX = "Compilation ";
    private static String MAGIC_LINE_MARKER = ".cs(";
    private static String MAGIC_LINE_MARKER_2 = ")";

    public static CompilerMessage parseLine(String line) {
        CompilerMessage ce = null;
        ce = DefaultCSharpCompilerParser.isOutputWithNoColumnNumber(line) ? DefaultCSharpCompilerParser.parseLineWithNoColumnNumber(line) : DefaultCSharpCompilerParser.parseLineWithColumnNumberAndLineNumber(line);
        return ce;
    }

    private static boolean isOutputWithNoColumnNumber(String line) {
        int j;
        int i = line.indexOf(MAGIC_LINE_MARKER);
        if (i == -1) {
            return true;
        }
        String chunk1 = line.substring(i + MAGIC_LINE_MARKER.length());
        String chunk2 = chunk1.substring(0, j = chunk1.indexOf(MAGIC_LINE_MARKER_2));
        return !chunk2.contains(",");
    }

    private static CompilerMessage parseLineWithNoColumnNumber(String line) {
        String message;
        String file = null;
        boolean error = true;
        int startline = -1;
        int startcolumn = -1;
        int endline = -1;
        int endcolumn = -1;
        if (line.startsWith(ERROR_PREFIX)) {
            message = line.substring(ERROR_PREFIX.length());
        } else {
            if (line.startsWith(COMPILATION_PREFIX)) {
                return null;
            }
            if (line.contains(MAGIC_LINE_MARKER)) {
                int i = line.indexOf(MAGIC_LINE_MARKER);
                int j = line.indexOf(32, i);
                file = line.substring(0, i + 3);
                String num = line.substring(i + MAGIC_LINE_MARKER.length(), j - 1);
                endline = startline = Integer.parseInt(num);
                message = line.substring(j + 1 + ERROR_PREFIX.length());
                error = line.contains(") error");
            } else {
                System.err.println("Unknown output: " + line);
                return null;
            }
        }
        return new CompilerMessage(file, error, startline, startcolumn, endline, endcolumn, message);
    }

    private static CompilerMessage parseLineWithColumnNumberAndLineNumber(String line) {
        String message;
        String file = null;
        boolean error = true;
        int startline = -1;
        int startcolumn = -1;
        int endline = -1;
        int endcolumn = -1;
        if (line.startsWith(ERROR_PREFIX)) {
            message = line.substring(ERROR_PREFIX.length());
        } else {
            if (line.startsWith(COMPILATION_PREFIX)) {
                return null;
            }
            if (line.contains(MAGIC_LINE_MARKER)) {
                int i = line.indexOf(MAGIC_LINE_MARKER);
                int j = line.indexOf(32, i);
                file = line.substring(0, i + 3);
                String linecol = line.substring(i + MAGIC_LINE_MARKER.length(), j - 2);
                String linenum = null;
                String colnum = null;
                if (linecol.contains(",") && linecol.split(",").length == 2) {
                    linenum = linecol.split(",")[0];
                    colnum = linecol.split(",")[1];
                } else if (linecol.split(",").length == 1) {
                    linenum = linecol.split(",")[0];
                    colnum = "-1";
                } else {
                    linenum = linecol.trim();
                    colnum = "-1";
                }
                startline = StringUtils.isEmpty((String)linenum) ? -1 : Integer.parseInt(linenum);
                startcolumn = StringUtils.isEmpty((String)colnum) ? -1 : Integer.parseInt(colnum);
                endline = startline;
                endcolumn = startcolumn;
                message = line.substring(j + 1 + ERROR_PREFIX.length());
                error = line.contains("): error");
            } else {
                System.err.println("Unknown output: " + line);
                return null;
            }
        }
        return new CompilerMessage(file, error, startline, startcolumn, endline, endcolumn, message);
    }
}

