/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.ajc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.tools.ajc.Main;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.ajc.AspectJCompilerConfiguration;
import org.codehaus.plexus.util.DirectoryScanner;

@Named(value="aspectj")
public class AspectJCompiler
extends AbstractCompiler {
    public AspectJCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, "", ".class", null);
    }

    public String getCompilerId() {
        return "aspectj";
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = AspectJCompiler.getSourceFiles(config)).length == 0) {
            return new CompilerResult();
        }
        this.logCompiling(sourceFiles, config);
        AjBuildConfig buildConfig = this.buildCompilerConfig(config);
        return new CompilerResult().compilerMessages(this.compileInProcess(buildConfig));
    }

    private AjBuildConfig buildCompilerConfig(CompilerConfiguration config) throws CompilerException {
        String outputLocation;
        Map javaOpts;
        String releaseVersion;
        BuildArgParser buildArgParser = new BuildArgParser((IMessageHandler)new AspectJMessagePrinter(config.isVerbose()));
        AjBuildConfig buildConfig = new AjBuildConfig(buildArgParser);
        buildArgParser.populateBuildConfig(buildConfig, new String[0], true, null);
        buildConfig.setIncrementalMode(false);
        String[] files = AspectJCompiler.getSourceFiles(config);
        if (files != null) {
            buildConfig.setFiles(this.buildFileList(Arrays.asList(files)));
        }
        this.setSourceVersion(buildConfig, (releaseVersion = config.getReleaseVersion()) == null ? config.getSourceVersion() : releaseVersion);
        this.setTargetVersion(buildConfig, releaseVersion == null ? config.getTargetVersion() : releaseVersion);
        if (config.isDebug()) {
            buildConfig.getOptions().produceDebugAttributes = 7;
        }
        if ((javaOpts = config.getCustomCompilerArgumentsAsMap()) == null || !javaOpts.isEmpty()) {
            // empty if block
        }
        LinkedList<String> cp = new LinkedList<String>(config.getClasspathEntries());
        File javaHomeDir = new File(System.getProperty("java.home"));
        File[] jars = new File(javaHomeDir, "lib").listFiles();
        if (jars != null) {
            for (File jar : jars) {
                if (!jar.getName().endsWith(".jar") && !jar.getName().endsWith(".zip")) continue;
                cp.add(0, jar.getAbsolutePath());
            }
        }
        if ((jars = new File(javaHomeDir, "../Classes").listFiles()) != null) {
            for (File jar : jars) {
                if (!jar.getName().endsWith(".jar") && !jar.getName().endsWith(".zip")) continue;
                cp.add(0, jar.getAbsolutePath());
            }
        }
        this.checkForAspectJRT(cp);
        if (cp != null && !cp.isEmpty()) {
            ArrayList<String> elements = new ArrayList<String>(cp.size());
            for (String path : cp) {
                elements.add(new File(path).getAbsolutePath());
            }
            buildConfig.setClasspath(elements);
        }
        if ((outputLocation = config.getOutputLocation()) != null) {
            File outDir = new File(outputLocation);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            buildConfig.setOutputDir(outDir);
        }
        if (config instanceof AspectJCompilerConfiguration) {
            String outJar;
            List<File> inPaths;
            List<File> inJars;
            List<File> aspectPath;
            Map<String, String> ajOptions;
            AspectJCompilerConfiguration ajCfg = (AspectJCompilerConfiguration)config;
            Map<String, File> sourcePathResources = ajCfg.getSourcePathResources();
            if (sourcePathResources != null && !sourcePathResources.isEmpty()) {
                buildConfig.setSourcePathResources(sourcePathResources);
            }
            if ((ajOptions = ajCfg.getAJOptions()) == null || !ajOptions.isEmpty()) {
                // empty if block
            }
            if ((aspectPath = this.buildFileList(ajCfg.getAspectPath())) != null && !aspectPath.isEmpty()) {
                buildConfig.setAspectpath(this.buildFileList(ajCfg.getAspectPath()));
            }
            if ((inJars = this.buildFileList(ajCfg.getInJars())) != null && !inJars.isEmpty()) {
                buildConfig.setInJars(this.buildFileList(ajCfg.getInJars()));
            }
            if ((inPaths = this.buildFileList(ajCfg.getInPath())) != null && !inPaths.isEmpty()) {
                buildConfig.setInPath(this.buildFileList(ajCfg.getInPath()));
            }
            if ((outJar = ajCfg.getOutputJar()) != null) {
                buildConfig.setOutputJar(new File(ajCfg.getOutputJar()));
            }
        }
        return buildConfig;
    }

    private List<CompilerMessage> compileInProcess(AjBuildConfig buildConfig) throws CompilerException {
        MessageHandler messageHandler = new MessageHandler();
        AjBuildManager manager = new AjBuildManager((IMessageHandler)messageHandler);
        try {
            manager.batchBuild(buildConfig, (IMessageHandler)messageHandler);
        }
        catch (IOException | AbortException e) {
            throw new CompilerException("Unknown error while compiling", e);
        }
        boolean errors = messageHandler.hasAnyMessage(IMessage.ERROR, true);
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        if (errors) {
            IMessage[] errorMessages;
            for (IMessage m : errorMessages = messageHandler.getMessages(IMessage.ERROR, true)) {
                ISourceLocation sourceLocation = m.getSourceLocation();
                CompilerMessage error = sourceLocation == null ? new CompilerMessage(m.getMessage(), true) : new CompilerMessage(sourceLocation.getSourceFile().getPath(), true, sourceLocation.getLine(), sourceLocation.getColumn(), sourceLocation.getEndLine(), sourceLocation.getColumn(), m.getMessage());
                messages.add(error);
            }
        }
        return messages;
    }

    private void checkForAspectJRT(List<String> cp) {
        if (cp == null || cp.isEmpty()) {
            throw new IllegalStateException("AspectJ Runtime not found in supplied classpath");
        }
        try {
            URL[] urls = new URL[cp.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File(cp.get(i)).toURL();
            }
            URLClassLoader cloader = new URLClassLoader(urls);
            cloader.loadClass("org.aspectj.lang.JoinPoint");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid classpath entry");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AspectJ Runtime not found in supplied classpath");
        }
    }

    private List<File> buildFileList(List<String> locations) {
        LinkedList<File> fileList = new LinkedList<File>();
        for (String location : locations) {
            fileList.add(new File(location));
        }
        return fileList;
    }

    private void setSourceVersion(AjBuildConfig buildConfig, String sourceVersion) throws CompilerException {
        buildConfig.getOptions().sourceLevel = AspectJCompiler.versionStringToMajorMinor(sourceVersion);
    }

    private void setTargetVersion(AjBuildConfig buildConfig, String targetVersion) throws CompilerException {
        buildConfig.getOptions().targetJDK = AspectJCompiler.versionStringToMajorMinor(targetVersion);
    }

    private static long versionStringToMajorMinor(String version) throws CompilerException {
        if (version == null) {
            version = "";
        }
        switch (version = version.trim().replaceFirst("^1[.]", "").replaceFirst("[.]0$", "")) {
            case "": {
                return 0x320000L;
            }
            case "1": {
                return 2949123L;
            }
            case "2": {
                return 0x2E0000L;
            }
            case "3": {
                return 0x2F0000L;
            }
            case "4": {
                return 0x300000L;
            }
            case "5": {
                return 0x310000L;
            }
            case "6": {
                return 0x320000L;
            }
            case "7": {
                return 0x330000L;
            }
            case "8": {
                return 0x340000L;
            }
            case "9": {
                return 0x350000L;
            }
            case "10": {
                return 0x360000L;
            }
            case "11": {
                return 0x370000L;
            }
            case "12": {
                return 0x380000L;
            }
            case "13": {
                return 0x390000L;
            }
            case "14": {
                return 0x3A0000L;
            }
            case "15": {
                return 0x3B0000L;
            }
            case "16": {
                return 0x3C0000L;
            }
        }
        throw new CompilerException("Unknown Java source/target version number: " + version);
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return null;
    }

    protected static String[] getSourceFiles(CompilerConfiguration config) {
        HashSet<String> sources = new HashSet<String>();
        Set sourceFiles = config.getSourceFiles();
        if (sourceFiles != null && !sourceFiles.isEmpty()) {
            for (File sourceFile : sourceFiles) {
                if (!sourceFile.getName().endsWith(".java") && !sourceFile.getName().endsWith(".aj")) continue;
                sources.add(sourceFile.getAbsolutePath());
            }
        } else {
            for (String sourceLocation : config.getSourceLocations()) {
                sources.addAll(AspectJCompiler.getSourceFilesForSourceRoot(config, sourceLocation));
            }
        }
        String[] result = sources.isEmpty() ? new String[]{} : sources.toArray(new String[sources.size()]);
        return result;
    }

    protected static Set<String> getSourceFilesForSourceRoot(CompilerConfiguration config, String sourceLocation) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceLocation);
        Set includes = config.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            String[] inclStrs = includes.toArray(new String[includes.size()]);
            scanner.setIncludes(inclStrs);
        } else {
            scanner.setIncludes(new String[]{"**/*.java", "**/*.aj"});
        }
        Set excludes = config.getExcludes();
        if (excludes != null && !excludes.isEmpty()) {
            String[] exclStrs = excludes.toArray(new String[excludes.size()]);
            scanner.setExcludes(exclStrs);
        }
        scanner.scan();
        String[] sourceDirectorySources = scanner.getIncludedFiles();
        HashSet<String> sources = new HashSet<String>();
        for (String sourceDirectorySource : sourceDirectorySources) {
            File f = new File(sourceLocation, sourceDirectorySource);
            sources.add(f.getPath());
        }
        return sources;
    }

    private static class AspectJMessagePrinter
    extends Main.MessagePrinter {
        public AspectJMessagePrinter(boolean verbose) {
            super(verbose);
        }
    }
}

