/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.build;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.build.BuildContext;
import org.codehaus.plexus.build.EmptyScanner;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default")
@Singleton
public class DefaultBuildContext
implements BuildContext {
    private final Logger logger = LoggerFactory.getLogger(DefaultBuildContext.class);

    @Override
    public boolean hasDelta(String relpath) {
        return true;
    }

    @Override
    public boolean hasDelta(File file) {
        return true;
    }

    @Override
    public boolean hasDelta(List<String> relpaths) {
        return true;
    }

    @Override
    public OutputStream newFileOutputStream(File file) throws IOException {
        return Files.newOutputStream(file.toPath(), new OpenOption[0]);
    }

    @Override
    public Scanner newScanner(File basedir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        return ds;
    }

    @Override
    public void refresh(File file) {
    }

    @Override
    public Scanner newDeleteScanner(File basedir) {
        return new EmptyScanner(basedir);
    }

    @Override
    public Scanner newScanner(File basedir, boolean ignoreDelta) {
        return this.newScanner(basedir);
    }

    @Override
    public boolean isIncremental() {
        return false;
    }

    @Override
    public Object getValue(String key) {
        return null;
    }

    @Override
    public void setValue(String key, Object value) {
    }

    private String getMessage(File file, int line, int column, String message) {
        return file.getAbsolutePath() + " [" + line + ':' + column + "]: " + message;
    }

    @Override
    public void addError(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 2, cause);
    }

    @Override
    public void addWarning(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 1, cause);
    }

    @Override
    public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        switch (severity) {
            case 2: {
                this.logger.error(this.getMessage(file, line, column, message), cause);
                return;
            }
            case 1: {
                this.logger.warn(this.getMessage(file, line, column, message), cause);
                return;
            }
        }
        throw new IllegalArgumentException("severity=" + severity);
    }

    @Override
    public void removeMessages(File file) {
    }

    @Override
    public boolean isUptodate(File target, File source) {
        return target != null && target.exists() && source != null && source.exists() && target.lastModified() > source.lastModified();
    }
}

