/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.shared.WagonCopy;
import org.codehaus.mojo.wagon.shared.WagonDownload;
import org.codehaus.mojo.wagon.shared.WagonFileSet;
import org.codehaus.mojo.wagon.shared.WagonUpload;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;

@Component(role=WagonCopy.class, hint="default")
public class DefaultWagonCopy
implements WagonCopy {
    @Requirement
    private WagonDownload downloader;
    @Requirement
    private WagonUpload uploader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(Wagon src, WagonFileSet wagonFileSet, Wagon target, boolean optimize, Log logger) throws WagonException, IOException {
        if (wagonFileSet == null) {
            wagonFileSet = new WagonFileSet();
        }
        boolean removeDownloadDir = false;
        if (wagonFileSet.getDownloadDirectory() == null) {
            File downloadSrcDir = File.createTempFile("wagon", "wagon");
            downloadSrcDir.delete();
            wagonFileSet.setDownloadDirectory(downloadSrcDir);
            removeDownloadDir = true;
        }
        try {
            this.downloader.download(src, wagonFileSet, logger);
            FileSet localFileSet = new FileSet();
            localFileSet.setDirectory(wagonFileSet.getDownloadDirectory().getAbsolutePath());
            localFileSet.setOutputDirectory(wagonFileSet.getOutputDirectory());
            this.uploader.upload(target, localFileSet, optimize);
        }
        finally {
            if (removeDownloadDir) {
                FileUtils.deleteDirectory((File)wagonFileSet.getDownloadDirectory());
            }
        }
    }
}

