/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.CaseUtils;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.util.ReflectionUtils;
import org.eclipse.aether.RepositorySystemSession;

public class TestUtils {
    private TestUtils() {
    }

    public static Path createTempDir(String name) throws IOException {
        return Files.createTempDirectory(CaseUtils.toCamelCase((String)name, (boolean)false, (char[])new char[0]), new FileAttribute[0]);
    }

    public static void tearDownTempDir(Path dir) throws IOException {
        if (dir != null && Files.exists(dir, new LinkOption[0])) {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void copyDir(final Path src, final Path dst) throws IOException {
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(dst.resolve(src.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, dst.resolve(src.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static <T extends AbstractMojo> T fixAllProjects(T mojo) throws IllegalAccessException {
        Field sessionField = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)"session", mojo.getClass());
        sessionField.setAccessible(true);
        MavenSession session = (MavenSession)sessionField.get(mojo);
        session.setAllProjects(session.getProjects());
        return mojo;
    }

    public static MavenSession createMavenSession(PlexusContainer container, CheckedFunction<File, MavenProject> projectReader, Path baseDir, String ... modules) {
        List projectList = Arrays.stream(modules).map(m -> baseDir.resolve((String)m).toFile()).map(f -> {
            try {
                return (MavenProject)projectReader.apply((File)f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        MavenSession session = new MavenSession(container, (RepositorySystemSession)MavenRepositorySystemUtils.newSession(), (MavenExecutionRequest)new DefaultMavenExecutionRequest(), (MavenExecutionResult)new DefaultMavenExecutionResult());
        session.setProjects(projectList);
        session.setCurrentProject((MavenProject)projectList.get(0));
        if (Files.exists(baseDir.resolve("pom.xml"), new LinkOption[0])) {
            MavenProject rootProject;
            try {
                rootProject = projectReader.apply(baseDir.toFile());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            session.setAllProjects(Stream.concat(Stream.of(rootProject), projectList.stream()).collect(Collectors.toList()));
        } else {
            session.setAllProjects(Collections.emptyList());
        }
        return session;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

