/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.doxia.site.Skin;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockUtils {
    private static final Map<String, String[]> DEFAULT_VERSION_MAP = new HashMap<String, String[]>(){
        {
            this.put("artifactA", new String[]{"1.0.0", "2.0.0"});
            this.put("artifactB", new String[]{"1.0.0", "1.1.0"});
            this.put("artifactC", new String[]{"1.0.0"});
        }
    };

    private MockUtils() {
    }

    public static RepositorySystem mockAetherRepositorySystem() {
        return MockUtils.mockAetherRepositorySystem(DEFAULT_VERSION_MAP);
    }

    public static RepositorySystem mockAetherRepositorySystem(Map<String, String[]> versionMap) {
        RepositorySystem repositorySystem = (RepositorySystem)Mockito.mock(RepositorySystem.class);
        MockUtils.prepareAetherRepositorySystemMockForVersionRange(repositorySystem, versionMap);
        try {
            Mockito.when((Object)repositorySystem.resolveArtifact((RepositorySystemSession)ArgumentMatchers.any(RepositorySystemSession.class), (ArtifactRequest)ArgumentMatchers.any(ArtifactRequest.class))).then(invocation -> {
                ArtifactRequest request = (ArtifactRequest)invocation.getArgument(1);
                DefaultArtifact copiedArtifact = new DefaultArtifact(request.getArtifact().getGroupId(), request.getArtifact().getArtifactId(), request.getArtifact().getClassifier(), request.getArtifact().getExtension(), request.getArtifact().getVersion());
                copiedArtifact.setFile((File)Mockito.mock(File.class));
                return new ArtifactResult(request).setArtifact((Artifact)copiedArtifact);
            });
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
        return repositorySystem;
    }

    public static void prepareAetherRepositorySystemMockForVersionRange(RepositorySystem repositorySystem, Map<String, String[]> versionMap) {
        try {
            Mockito.when((Object)repositorySystem.resolveVersionRange((RepositorySystemSession)ArgumentMatchers.any(), (VersionRangeRequest)ArgumentMatchers.any(VersionRangeRequest.class))).then(invocation -> {
                VersionRangeRequest request = (VersionRangeRequest)invocation.getArgument(1);
                return versionMap.entrySet().stream().filter(e -> ((String)e.getKey()).equals(request.getArtifact().getArtifactId())).findAny().map(e -> Arrays.stream((String[])e.getValue()).map(MockUtils::parseVersion).collect(() -> new ArrayList(), ArrayList::add, ArrayList::addAll)).map(versions -> new VersionRangeResult(request).setVersions((List)versions)).orElse(null);
            });
        }
        catch (VersionRangeResolutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static Version parseVersion(String version) {
        try {
            return new GenericVersionScheme().parseVersion(version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    public static I18N mockI18N() {
        I18N i18n = (I18N)Mockito.mock(I18N.class);
        Mockito.when((Object)i18n.getString(ArgumentMatchers.anyString(), (Locale)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenAnswer(invocation -> invocation.getArgument(2));
        return i18n;
    }

    public static SiteTool mockSiteTool() {
        org.apache.maven.artifact.Artifact skinArtifact = (org.apache.maven.artifact.Artifact)Mockito.mock(org.apache.maven.artifact.Artifact.class);
        Mockito.when((Object)skinArtifact.getId()).thenReturn((Object)"");
        SiteTool siteTool = (SiteTool)Mockito.mock(SiteTool.class);
        try {
            Mockito.when((Object)siteTool.getSkinArtifactFromRepository((RepositorySystemSession)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (Skin)ArgumentMatchers.any())).thenReturn((Object)skinArtifact);
        }
        catch (SiteToolException e) {
            throw new RuntimeException(e);
        }
        return siteTool;
    }

    public static ArtifactHandlerManager mockArtifactHandlerManager() {
        ArtifactHandlerManager artifactHandlerManager = (ArtifactHandlerManager)Mockito.mock(ArtifactHandlerManager.class);
        Mockito.when((Object)artifactHandlerManager.getArtifactHandler(ArgumentMatchers.anyString())).thenAnswer(i -> {
            String type = (String)i.getArgument(0);
            DefaultArtifactHandler artifactHandler = new DefaultArtifactHandler(type);
            if (type.equals("maven-plugin")) {
                artifactHandler.setExtension("jar");
            }
            return artifactHandler;
        });
        return artifactHandlerManager;
    }

    public static MavenSession mockMavenSession() {
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)project.getRemotePluginRepositories()).thenReturn(Collections.emptyList());
        Mockito.when((Object)project.getRemoteProjectRepositories()).thenReturn(Collections.emptyList());
        return MockUtils.mockMavenSession(project);
    }

    public static MavenSession mockMavenSession(MavenProject project) {
        MavenSession session = (MavenSession)Mockito.mock(MavenSession.class);
        RepositorySystemSession repositorySystemSession = (RepositorySystemSession)Mockito.mock(RepositorySystemSession.class);
        Mockito.when((Object)session.getRepositorySession()).thenReturn((Object)repositorySystemSession);
        Mockito.when((Object)session.getCurrentProject()).thenReturn((Object)project);
        Properties emptyProperties = new Properties();
        Mockito.when((Object)session.getUserProperties()).thenReturn((Object)emptyProperties);
        Mockito.when((Object)session.getSystemProperties()).thenReturn((Object)emptyProperties);
        ProxySelector proxySelector = (ProxySelector)Mockito.mock(ProxySelector.class);
        Mockito.when((Object)repositorySystemSession.getProxySelector()).thenReturn((Object)proxySelector);
        AuthenticationSelector authenticationSelector = (AuthenticationSelector)Mockito.mock(AuthenticationSelector.class);
        Mockito.when((Object)repositorySystemSession.getAuthenticationSelector()).thenReturn((Object)authenticationSelector);
        MirrorSelector mirrorSelector = (MirrorSelector)Mockito.mock(MirrorSelector.class);
        Mockito.when((Object)repositorySystemSession.getMirrorSelector()).thenReturn((Object)mirrorSelector);
        return session;
    }
}

