/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.recording;

import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.change.DependencyVersionChange;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.change.DefaultDependencyVersionChange;

public class DefaultDependencyChangeRecord
implements DependencyChangeRecord {
    private final DependencyChangeRecord.ChangeKind kind;
    private final DependencyVersionChange versionChange;

    private DefaultDependencyChangeRecord(DependencyChangeRecord.ChangeKind kind, DependencyVersionChange versionChange) {
        this.kind = Objects.requireNonNull(kind, "kind must not be null");
        this.versionChange = Objects.requireNonNull(versionChange, "versionChange must not be null");
    }

    public DependencyChangeRecord.ChangeKind getKind() {
        return this.kind;
    }

    public DependencyVersionChange getVersionChange() {
        return this.versionChange;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DependencyChangeRecord.ChangeKind kind;
        private String groupId;
        private String artifactId;
        private String oldVersion;
        private String newVersion;

        private Builder() {
        }

        public Builder withKind(DependencyChangeRecord.ChangeKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder withOldVersion(String oldVersion) {
            this.oldVersion = oldVersion;
            return this;
        }

        public Builder withNewVersion(String newVersion) {
            this.newVersion = newVersion;
            return this;
        }

        public Builder withDependency(Dependency dependency) {
            this.groupId = dependency.getGroupId();
            this.artifactId = dependency.getArtifactId();
            this.oldVersion = dependency.getVersion();
            return this;
        }

        public Builder withArtifact(Artifact artifact) {
            this.groupId = artifact.getGroupId();
            this.artifactId = artifact.getArtifactId();
            this.oldVersion = artifact.getVersion();
            return this;
        }

        public DependencyChangeRecord build() {
            return new DefaultDependencyChangeRecord(this.kind, new DefaultDependencyVersionChange(this.groupId, this.artifactId, this.oldVersion, this.newVersion));
        }
    }
}

