/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.ResolverAdapter;
import org.codehaus.mojo.versions.api.VersionRetrievalException;

public interface VersionsHelper
extends ResolverAdapter {
    public ArtifactVersions lookupArtifactVersions(Artifact var1, boolean var2) throws VersionRetrievalException;

    public ArtifactVersions lookupArtifactVersions(Artifact var1, VersionRange var2, boolean var3, boolean var4) throws VersionRetrievalException;

    public ArtifactVersions lookupArtifactVersions(Artifact var1, VersionRange var2, boolean var3) throws VersionRetrievalException;

    public Map<Dependency, ArtifactVersions> lookupDependenciesUpdates(Stream<Dependency> var1, boolean var2, boolean var3) throws VersionRetrievalException;

    public Map<Dependency, ArtifactVersions> lookupDependenciesUpdates(Stream<Dependency> var1, boolean var2, boolean var3, boolean var4) throws VersionRetrievalException;

    public ArtifactVersions lookupDependencyUpdates(Dependency var1, boolean var2, boolean var3, boolean var4) throws VersionRetrievalException;

    public Map<Plugin, PluginUpdatesDetails> lookupPluginsUpdates(Stream<Plugin> var1, boolean var2) throws VersionRetrievalException;

    public PluginUpdatesDetails lookupPluginUpdates(Plugin var1, boolean var2) throws VersionRetrievalException;

    public Map<Property, PropertyVersions> getVersionPropertiesMap(VersionPropertiesMapRequest var1) throws MojoExecutionException;

    @Override
    public void resolveArtifact(Artifact var1, boolean var2) throws ArtifactResolutionException;

    public static class VersionPropertiesMapRequest {
        private MavenProject mavenProject;
        private List<Property> propertyDefinitions;
        private String includeProperties;
        private String excludeProperties;
        private boolean includeParent;
        private boolean autoLinkItems;
        private Predicate<Artifact> includeFilter;

        @Deprecated
        public VersionPropertiesMapRequest() {
        }

        protected MavenProject getMavenProject() {
            return this.mavenProject;
        }

        protected List<Property> getPropertyDefinitions() {
            return this.propertyDefinitions;
        }

        protected String getIncludeProperties() {
            return this.includeProperties;
        }

        protected String getExcludeProperties() {
            return this.excludeProperties;
        }

        protected Predicate<Artifact> getIncludeFilter() {
            return this.includeFilter;
        }

        protected boolean isIncludeParent() {
            return this.includeParent;
        }

        protected boolean isAutoLinkItems() {
            return this.autoLinkItems;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private MavenProject mavenProject;
            private List<Property> propertyDefinitions;
            private String includeProperties;
            private String excludeProperties;
            private Boolean includeParent;
            private Boolean autoLinkItems;
            private Predicate<Artifact> includeFilter;

            private Builder() {
            }

            public Builder withMavenProject(MavenProject mavenProject) {
                this.mavenProject = mavenProject;
                return this;
            }

            public Builder withPropertyDefinitions(List<Property> propertyDefinitions) {
                this.propertyDefinitions = propertyDefinitions;
                return this;
            }

            public Builder withIncludeProperties(String includeProperties) {
                this.includeProperties = includeProperties;
                return this;
            }

            public Builder withExcludeProperties(String excludeProperties) {
                this.excludeProperties = excludeProperties;
                return this;
            }

            public Builder withIncludeParent(boolean includeParent) {
                this.includeParent = includeParent;
                return this;
            }

            public Builder withAutoLinkItems(boolean autoLinkItems) {
                this.autoLinkItems = autoLinkItems;
                return this;
            }

            public Builder withIncludeFilter(Predicate<Artifact> includeFilter) {
                this.includeFilter = includeFilter;
                return this;
            }

            public VersionPropertiesMapRequest build() {
                VersionPropertiesMapRequest instance = new VersionPropertiesMapRequest();
                instance.mavenProject = this.mavenProject;
                instance.propertyDefinitions = this.propertyDefinitions;
                instance.includeProperties = this.includeProperties;
                instance.excludeProperties = this.excludeProperties;
                instance.includeParent = this.includeParent == null || this.includeParent != false;
                instance.autoLinkItems = this.autoLinkItems == null || this.autoLinkItems != false;
                instance.includeFilter = this.includeFilter;
                return instance;
            }
        }
    }
}

