/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.IgnoreVersionHelper;
import org.codehaus.mojo.versions.api.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.rule.RuleService;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;

public class DefaultVersionsHelper
implements VersionsHelper {
    private static final int LOOKUP_PARALLEL_THREADS = 5;
    private final RuleService ruleService;
    private final ArtifactFactory artifactFactory;
    private final RepositorySystem repositorySystem;
    private final Log log;
    private final MavenSession mavenSession;
    private final List<RemoteRepository> remotePluginRepositories;
    private final List<RemoteRepository> remoteProjectRepositories;
    private final PomHelper pomHelper;

    private DefaultVersionsHelper(PomHelper pomHelper, ArtifactFactory artifactFactory, RepositorySystem repositorySystem, MavenSession mavenSession, RuleService ruleService, Log log) {
        this.pomHelper = Objects.requireNonNull(pomHelper);
        this.artifactFactory = Objects.requireNonNull(artifactFactory);
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.mavenSession = Objects.requireNonNull(mavenSession);
        this.ruleService = Objects.requireNonNull(ruleService);
        this.log = Objects.requireNonNull(log);
        this.remoteProjectRepositories = Optional.of(mavenSession).map(MavenSession::getCurrentProject).map(MavenProject::getRemoteProjectRepositories).map(DefaultVersionsHelper::forceDailyRemoteRepositoriesRefreshPolicy).orElseGet(Collections::emptyList);
        this.remotePluginRepositories = Optional.of(mavenSession).map(MavenSession::getCurrentProject).map(MavenProject::getRemotePluginRepositories).map(DefaultVersionsHelper::forceDailyRemoteRepositoriesRefreshPolicy).orElseGet(Collections::emptyList);
    }

    static List<RemoteRepository> forceDailyRemoteRepositoriesRefreshPolicy(List<RemoteRepository> remoteRepositories) {
        return remoteRepositories.stream().map(remoteRepository -> {
            RepositoryPolicy snapshotPolicy = DefaultVersionsHelper.forceDailyUpdatePolicy(remoteRepository.getPolicy(true));
            RepositoryPolicy releasePolicy = DefaultVersionsHelper.forceDailyUpdatePolicy(remoteRepository.getPolicy(false));
            if (snapshotPolicy != null || releasePolicy != null) {
                RemoteRepository.Builder builder = new RemoteRepository.Builder(remoteRepository);
                Optional.ofNullable(snapshotPolicy).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setSnapshotPolicy(arg_0));
                Optional.ofNullable(releasePolicy).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setReleasePolicy(arg_0));
                return builder.build();
            }
            return remoteRepository;
        }).collect(Collectors.toList());
    }

    private static RepositoryPolicy forceDailyUpdatePolicy(RepositoryPolicy policy) {
        if (policy.isEnabled() && "never".equals(policy.getUpdatePolicy())) {
            return new RepositoryPolicy(true, "daily", policy.getChecksumPolicy());
        }
        return null;
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, VersionRange versionRange, boolean usePluginRepositories) throws VersionRetrievalException {
        return this.lookupArtifactVersions(artifact, versionRange, usePluginRepositories, !usePluginRepositories);
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, VersionRange versionRange, boolean usePluginRepositories, boolean useProjectRepositories) throws VersionRetrievalException {
        try {
            List<IgnoreVersion> ignoredVersions = this.ruleService.getIgnoredVersions(artifact);
            if (!ignoredVersions.isEmpty() && this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Found ignored versions: " + ignoredVersions + " for artifact" + artifact));
            }
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(RepositoryUtils.toArtifact((Artifact)artifact).setVersion(Optional.ofNullable(versionRange).map(VersionRange::getRestrictions).flatMap(list -> list.stream().findFirst().map(Restriction::toString)).orElse("(,)")), Stream.concat(usePluginRepositories ? this.remotePluginRepositories.stream() : Stream.empty(), useProjectRepositories ? this.remoteProjectRepositories.stream() : Stream.empty()).distinct().collect(Collectors.toList()), "lookupArtifactVersions");
            return new ArtifactVersions(artifact, this.repositorySystem.resolveVersionRange(this.mavenSession.getRepositorySession(), versionRangeRequest).getVersions().stream().filter(v -> ignoredVersions.stream().noneMatch(i -> {
                if (IgnoreVersionHelper.isVersionIgnored(v, i)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)("Version " + v + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + i));
                    }
                    return true;
                }
                return false;
            })).map(v -> ArtifactVersionService.getArtifactVersion(v.toString())).collect(Collectors.toList()));
        }
        catch (VersionRangeResolutionException e) {
            throw new VersionRetrievalException(e.getMessage(), artifact, e);
        }
        catch (RuntimeException e) {
            throw new VersionRetrievalException("Unable to retrieve versions for " + artifact + " for version range " + versionRange, artifact, e);
        }
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, boolean usePluginRepositories) throws VersionRetrievalException {
        return this.lookupArtifactVersions(artifact, null, usePluginRepositories);
    }

    @Override
    public void resolveArtifact(Artifact artifact, boolean usePluginRepositories) throws ArtifactResolutionException {
        try {
            ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.mavenSession.getRepositorySession(), new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), usePluginRepositories ? this.mavenSession.getCurrentProject().getRemotePluginRepositories() : this.mavenSession.getCurrentProject().getRemoteProjectRepositories(), this.getClass().getName()));
            artifact.setFile(artifactResult.getArtifact().getFile());
            artifact.setVersion(artifactResult.getArtifact().getVersion());
            artifact.setResolved(artifactResult.isResolved());
        }
        catch (org.eclipse.aether.resolution.ArtifactResolutionException e) {
            throw new ArtifactResolutionException(e.getMessage(), artifact);
        }
    }

    @Override
    public ArtifactVersions resolveArtifactVersions(Artifact artifact, boolean usePluginRepositories, boolean useProjectRepositories) throws VersionRetrievalException {
        return this.lookupArtifactVersions(artifact, null, usePluginRepositories, !usePluginRepositories);
    }

    @Override
    public SortedMap<Dependency, ArtifactVersions> resolveDependencyVersions(Collection<Dependency> dependencies, boolean usePluginRepositories, boolean useProjectRepositories) throws VersionRetrievalException {
        return this.lookupDependenciesUpdates((Stream)dependencies.stream(), usePluginRepositories, useProjectRepositories, true);
    }

    @Override
    public PluginUpdatesDetails resolvePluginVersions(Plugin plugin) throws VersionRetrievalException {
        return this.lookupPluginUpdates(plugin, true);
    }

    @Override
    public SortedMap<Plugin, PluginUpdatesDetails> resolvePluginVersions(Collection<Plugin> plugins) throws VersionRetrievalException {
        return this.lookupPluginsUpdates((Stream)plugins.stream(), true);
    }

    public SortedMap<Dependency, ArtifactVersions> lookupDependenciesUpdates(Stream<Dependency> dependencies, boolean usePluginRepositories, boolean useProjectRepositories, boolean allowSnapshots) throws VersionRetrievalException {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            TreeMap<Dependency, ArtifactVersions> dependencyUpdates = new TreeMap<Dependency, ArtifactVersions>(DependencyComparator.INSTANCE);
            List futures = dependencies.map(dependency -> executor.submit(() -> new ImmutablePair(dependency, (Object)this.lookupDependencyUpdates((Dependency)dependency, usePluginRepositories, useProjectRepositories, allowSnapshots)))).collect(Collectors.toList());
            for (Future details : futures) {
                Pair pair = (Pair)details.get();
                dependencyUpdates.put((Dependency)pair.getKey(), (ArtifactVersions)pair.getValue());
            }
            TreeMap<Dependency, ArtifactVersions> treeMap = dependencyUpdates;
            return treeMap;
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof VersionRetrievalException) {
                throw (VersionRetrievalException)e.getCause();
            }
            throw new VersionRetrievalException("Unable to acquire metadata for dependencies " + dependencies + ": " + e.getMessage(), null, e);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public Map<Dependency, ArtifactVersions> lookupDependenciesUpdates(Stream<Dependency> dependencies, boolean usePluginRepositories, boolean allowSnapshots) throws VersionRetrievalException {
        return this.lookupDependenciesUpdates((Stream)dependencies, usePluginRepositories, !usePluginRepositories, allowSnapshots);
    }

    @Override
    public ArtifactVersions lookupDependencyUpdates(Dependency dependency, boolean usePluginRepositories, boolean useProjectRepositories, boolean allowSnapshots) throws VersionRetrievalException {
        ArtifactVersions allVersions = this.lookupArtifactVersions(this.artifactFactory.createArtifact(dependency), null, usePluginRepositories, useProjectRepositories);
        return new ArtifactVersions(allVersions.getArtifact(), Arrays.stream(allVersions.getAllUpdates(allowSnapshots)).collect(Collectors.toList()));
    }

    public SortedMap<Plugin, PluginUpdatesDetails> lookupPluginsUpdates(Stream<Plugin> plugins, boolean allowSnapshots) throws VersionRetrievalException {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            TreeMap<Object, PluginUpdatesDetails> pluginUpdates = new TreeMap<Object, PluginUpdatesDetails>(PluginComparator.INSTANCE);
            List futures = plugins.map(p -> executor.submit(() -> new ImmutablePair(p, (Object)this.lookupPluginUpdates((Plugin)p, allowSnapshots)))).collect(Collectors.toList());
            for (Future details : futures) {
                Pair pair = (Pair)details.get();
                pluginUpdates.put((Plugin)pair.getKey(), (PluginUpdatesDetails)pair.getValue());
            }
            TreeMap<Object, PluginUpdatesDetails> treeMap = pluginUpdates;
            return treeMap;
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof VersionRetrievalException) {
                throw (VersionRetrievalException)e.getCause();
            }
            throw new VersionRetrievalException("Unable to acquire metadata for plugins " + plugins + ": " + e.getMessage(), null, e);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public PluginUpdatesDetails lookupPluginUpdates(Plugin plugin, boolean allowSnapshots) throws VersionRetrievalException {
        String version = plugin.getVersion() != null ? plugin.getVersion() : "LATEST";
        TreeSet<Dependency> pluginDependencies = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        if (plugin.getDependencies() != null) {
            pluginDependencies.addAll(plugin.getDependencies());
        }
        Map<Dependency, ArtifactVersions> pluginDependencyDetails = this.lookupDependenciesUpdates(pluginDependencies.stream(), false, allowSnapshots);
        ArtifactVersions allVersions = this.lookupArtifactVersions(this.artifactFactory.createMavenPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), version), true);
        ArtifactVersions updatedVersions = new ArtifactVersions(allVersions.getArtifact(), Arrays.stream(allVersions.getAllUpdates(allowSnapshots)).collect(Collectors.toList()));
        return new PluginUpdatesDetails(updatedVersions, pluginDependencyDetails, allowSnapshots);
    }

    @Override
    public Map<Property, PropertyVersions> getVersionPropertiesMap(VersionsHelper.VersionPropertiesMapRequest request) throws MojoExecutionException {
        String propertyName;
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (request.getPropertyDefinitions() != null) {
            request.getPropertyDefinitions().forEach(p -> properties.put(p.getName(), (Property)p));
        }
        HashMap<String, PropertyVersionsBuilder> builders = new HashMap<String, PropertyVersionsBuilder>();
        if (request.isAutoLinkItems()) {
            try {
                PropertyVersionsBuilder[] propertyVersionsBuilders;
                for (PropertyVersionsBuilder builder : propertyVersionsBuilders = this.pomHelper.getPropertyVersionsBuilders(this, this.log, request.getMavenProject(), request.isIncludeParent())) {
                    propertyName = builder.getName();
                    builders.put(propertyName, builder);
                    properties.computeIfAbsent(propertyName, name -> {
                        Property property = new Property((String)name);
                        this.log.debug((CharSequence)String.format("Property ${%s}: Adding inferred version range of %s", name, builder.getVersionRange()));
                        property.setVersion(builder.getVersionRange());
                        return property;
                    });
                }
            }
            catch (IOException | ExpressionEvaluationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        List includePropertiesList = Optional.ofNullable(request.getIncludeProperties()).map(s -> Arrays.asList(s.split("\\s*,\\s*"))).orElse(Collections.emptyList());
        List excludePropertiesList = Optional.ofNullable(request.getExcludeProperties()).map(s -> Arrays.asList(s.split("\\s*,\\s*"))).orElse(Collections.emptyList());
        properties.values().removeIf(property -> {
            String name = property.getName();
            if (!includePropertiesList.isEmpty() && !includePropertiesList.contains(name)) {
                this.log.debug((CharSequence)("Skipping property ${" + name + "}"));
                return true;
            }
            if (excludePropertiesList.contains(name)) {
                this.log.debug((CharSequence)("Ignoring property ${" + name + "}"));
                return true;
            }
            return false;
        });
        this.log.debug((CharSequence)"Processing properties to build PropertyVersions");
        LinkedHashMap<Property, PropertyVersions> propertyVersions = new LinkedHashMap<Property, PropertyVersions>(properties.size());
        for (Property property2 : properties.values()) {
            Dependency[] dependencies;
            propertyName = property2.getName();
            this.log.debug((CharSequence)("Property ${" + propertyName + "}"));
            PropertyVersionsBuilder builder = (PropertyVersionsBuilder)builders.get(propertyName);
            if (builder == null || !builder.isAssociated()) {
                this.log.debug((CharSequence)String.format("Property ${%s}: Not associated with any dependency.", propertyName));
                builder = new PropertyVersionsBuilder(this, null, propertyName, this.log);
            }
            if (!property2.isAutoLinkDependencies()) {
                this.log.debug((CharSequence)String.format("Property ${%s}: Clearing auto-link dependencies", propertyName));
                builder.clearAssociations();
            }
            if ((dependencies = property2.getDependencies()) != null) {
                for (Dependency dependency : dependencies) {
                    this.log.debug((CharSequence)String.format("Property ${%s}: Adding association to %s", propertyName, dependency));
                    builder.withAssociation(this.artifactFactory.createArtifact(dependency), false);
                }
            }
            if (request.getIncludeFilter() != null && builder.getAssociations().stream().map(ArtifactAssociation::getArtifact).anyMatch(artifact -> {
                if (!request.getIncludeFilter().test((Artifact)artifact)) {
                    this.log.info((CharSequence)("Skipping the property ${" + property2.getName() + "} because it is used by artifact " + artifact.toString() + " and that artifact is not included in the list of  allowed artifacts to be updated."));
                    return true;
                }
                return false;
            })) continue;
            try {
                String currentVersion = request.getMavenProject().getProperties().getProperty(propertyName);
                property2.setValue(currentVersion);
                if (property2.isAutoLinkDependencies() && StringUtils.isEmpty((CharSequence)property2.getVersion()) && !StringUtils.isEmpty((CharSequence)builder.getVersionRange())) {
                    this.log.debug((CharSequence)String.format("Property ${%s}: Adding inferred version range of %s", propertyName, builder.getVersionRange()));
                    property2.setVersion(builder.getVersionRange());
                }
                if (currentVersion != null) {
                    builder.withCurrentVersion(ArtifactVersionService.getArtifactVersion(currentVersion)).withCurrentVersionRange(VersionRange.createFromVersionSpec((String)currentVersion));
                }
                PropertyVersions versions = builder.build();
                propertyVersions.put(property2, versions);
            }
            catch (VersionRetrievalException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
        }
        return propertyVersions;
    }

    public static class Builder {
        private Log log;
        private MavenSession mavenSession;
        private RepositorySystem repositorySystem;
        private RuleService ruleService;
        private ArtifactFactory artifactFactory;
        private PomHelper pomHelper;

        public Builder withLog(Log log) {
            this.log = log;
            return this;
        }

        public Builder withMavenSession(MavenSession mavenSession) {
            this.mavenSession = mavenSession;
            return this;
        }

        public Builder withRepositorySystem(RepositorySystem repositorySystem) {
            this.repositorySystem = repositorySystem;
            return this;
        }

        public Builder withRuleService(RuleService ruleService) {
            this.ruleService = ruleService;
            return this;
        }

        public Builder withArtifactFactory(ArtifactFactory artifactFactory) {
            this.artifactFactory = artifactFactory;
            return this;
        }

        public Builder withPomHelper(PomHelper pomHelper) {
            this.pomHelper = pomHelper;
            return this;
        }

        public DefaultVersionsHelper build() throws MojoExecutionException {
            return new DefaultVersionsHelper(this.pomHelper, this.artifactFactory, this.repositorySystem, this.mavenSession, this.ruleService, this.log);
        }
    }
}

