/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.recording;

import java.util.Objects;
import org.codehaus.mojo.versions.api.change.PropertyVersionChange;
import org.codehaus.mojo.versions.api.recording.PropertyChangeRecord;
import org.codehaus.mojo.versions.change.DefaultPropertyVersionChange;

public class DefaultPropertyChangeRecord
implements PropertyChangeRecord {
    private final PropertyVersionChange versionChange;

    private DefaultPropertyChangeRecord(PropertyVersionChange versionChange) {
        this.versionChange = Objects.requireNonNull(versionChange, "versionChange must not be null");
    }

    public PropertyVersionChange getVersionChange() {
        return this.versionChange;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String property;
        private String oldValue;
        private String newValue;

        public Builder withProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder withOldValue(String oldValue) {
            this.oldValue = oldValue;
            return this;
        }

        public Builder withNewValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        public PropertyChangeRecord build() {
            return new DefaultPropertyChangeRecord(new DefaultPropertyVersionChange(this.property, this.oldValue, this.newValue));
        }
    }
}

