/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.MinimalMavenBuildVersionFinder;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.ExtensionUtils;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="display-plugin-updates", threadSafe=true)
public class DisplayPluginUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int WARN_PAD_SIZE = 65;
    private static final int INFO_PAD_SIZE = 68;
    private static final String FROM_SUPER_POM = "(from super-pom) ";
    public static final Pattern PATTERN_PROJECT_PLUGIN = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
    public static final String SUPERPOM_PATH = "org/apache/maven/model/pom-4.0.0.xml";
    private LifecycleExecutor lifecycleExecutor;
    private ModelInterpolator modelInterpolator;
    private final RuntimeInformation runtimeInformation;
    protected final ProjectBuilder projectBuilder;
    @Parameter(property="processUnboundPlugins", defaultValue="false")
    protected boolean processUnboundPlugins;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;

    @Inject
    public DisplayPluginUpdatesMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, ProjectBuilder projectBuilder, Map<String, Wagon> wagonMap, LifecycleExecutor lifecycleExecutor, ModelInterpolator modelInterpolator, RuntimeInformation runtimeInformation, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
        this.projectBuilder = projectBuilder;
        this.lifecycleExecutor = lifecycleExecutor;
        this.modelInterpolator = modelInterpolator;
        this.runtimeInformation = runtimeInformation;
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    private Map<String, String> getSuperPomPluginManagement() {
        Map result = this.lifecycleExecutor.getPluginsBoundByDefaultToAllLifecycles(this.getProject().getPackaging()).stream().collect(LinkedHashMap::new, (m, p) -> m.put(p.getKey(), p.getVersion()), Map::putAll);
        try (InputStream superPomIs = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(SUPERPOM_PATH);){
            Objects.requireNonNull(superPomIs);
            MutableXMLStreamReader pomReader = new MutableXMLStreamReader(superPomIs, Paths.get(SUPERPOM_PATH, new String[0]));
            Stack<StackState> pathStack = new Stack<StackState>();
            StackState curState = new StackState("");
            int event = pomReader.getEventType();
            while (event != 8 && pomReader.hasNext()) {
                if (pomReader.isStartElement()) {
                    if (curState != null) {
                        String elementName = pomReader.getLocalName();
                        if (PATTERN_PROJECT_PLUGIN.matcher(curState.path).matches()) {
                            switch (elementName) {
                                case "groupId": {
                                    curState.groupId = pomReader.getElementText().trim();
                                    break;
                                }
                                case "artifactId": {
                                    curState.artifactId = pomReader.getElementText().trim();
                                    break;
                                }
                                case "version": {
                                    curState.version = pomReader.getElementText().trim();
                                    break;
                                }
                            }
                        }
                        pathStack.push(curState);
                        curState = new StackState(curState.path + "/" + elementName);
                    }
                } else if (pomReader.isEndElement()) {
                    if (curState != null && curState.artifactId != null && PATTERN_PROJECT_PLUGIN.matcher(curState.path).matches()) {
                        result.putIfAbsent(Plugin.constructKey((String)(curState.groupId == null ? "org.apache.maven.plugins" : curState.groupId), (String)curState.artifactId), curState.version);
                    }
                    curState = (StackState)pathStack.pop();
                }
                event = pomReader.next();
            }
        }
        catch (IOException | XMLStreamException exception) {
            // empty catch block
        }
        return result;
    }

    private Map<String, String> getPluginManagement(Model model) {
        HashMap<String, String> pluginManagement = new HashMap<String, String>();
        try {
            for (Plugin plugin : model.getBuild().getPluginManagement().getPlugins()) {
                String coord = plugin.getKey();
                String version = plugin.getVersion();
                if (version == null) continue;
                pluginManagement.put(coord, version);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (Profile profile : model.getProfiles()) {
                try {
                    for (Plugin plugin : profile.getBuild().getPluginManagement().getPlugins()) {
                        String coord = plugin.getKey();
                        String version = plugin.getVersion();
                        if (version == null) continue;
                        pluginManagement.put(coord, version);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return pluginManagement;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Plugin> plugins;
        Set<String> pluginsWithVersionsSpecified;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.logInit();
        try (MutableXMLStreamReader pomReader = new MutableXMLStreamReader(this.getProject().getFile().toPath());){
            pluginsWithVersionsSpecified = this.findPluginsWithVersionsSpecified(pomReader);
        }
        catch (IOException | XMLStreamException | TransformerException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        Map<String, String> superPomPluginManagement = this.getSuperPomPluginManagement();
        this.getLog().debug((CharSequence)("superPom plugins = " + superPomPluginManagement));
        List<MavenProject> parents = this.getParentProjects(this.getProject());
        Map<String, String> parentPlugins = this.getParentsPlugins(parents);
        HashMap<String, String> parentBuildPlugins = new HashMap<String, String>();
        HashMap<String, String> parentReportPlugins = new HashMap<String, String>();
        try {
            plugins = this.getPluginManagementPlugins(superPomPluginManagement, parentPlugins, parentBuildPlugins, parentReportPlugins, pluginsWithVersionsSpecified);
        }
        catch (IOException | XMLStreamException | TransformerException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        ArrayList<String> pluginUpdates = new ArrayList<String>();
        ArrayList<String> pluginLockdowns = new ArrayList<String>();
        ArtifactVersion curMavenVersion = ArtifactVersionService.getArtifactVersion((String)this.runtimeInformation.getMavenVersion());
        ArtifactVersion specMavenVersion = MinimalMavenBuildVersionFinder.find(this.getProject(), this.getLog());
        ArtifactVersion minMavenVersion = null;
        boolean superPomDrivingMinVersion = false;
        TreeMap<ArtifactVersion, Map<String, String>> mavenUpgrades = new TreeMap<ArtifactVersion, Map<String, String>>();
        for (Plugin plugin : plugins) {
            String newVersion;
            ArtifactVersion artifactVersion;
            String effectiveVersion;
            boolean versionSpecifiedInCurrentPom;
            String version;
            String coords;
            block45: {
                coords = ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId());
                version = Optional.ofNullable(plugin.getVersion()).orElse(parentPlugins.get(coords));
                versionSpecifiedInCurrentPom = pluginsWithVersionsSpecified.contains(coords);
                if (!versionSpecifiedInCurrentPom && !this.processUnboundPlugins && parentPlugins.containsKey(coords)) {
                    this.getLog().debug((CharSequence)("Skip " + coords + ", version " + version + " is defined in parent POM."));
                    this.getLog().debug((CharSequence)"Use the \"processUnboundPlugins\" parameter to see these updates.");
                    continue;
                }
                this.getLog().debug((CharSequence)("Checking " + coords + " for updates newer than " + version));
                try {
                    Pair<ArtifactVersion, String> effectiveVersionPair = this.getEffectivePluginVersion(plugin, version, specMavenVersion, curMavenVersion, mavenUpgrades);
                    effectiveVersion = (String)effectiveVersionPair.getRight();
                    artifactVersion = (ArtifactVersion)effectiveVersionPair.getLeft();
                    if (effectiveVersion == null) break block45;
                    try {
                        ArtifactVersion requires = this.getPrerequisitesMavenVersion(this.getPluginProject(plugin.getGroupId(), plugin.getArtifactId(), effectiveVersion));
                        if (minMavenVersion == null || DisplayPluginUpdatesMojo.compare(minMavenVersion, requires) < 0) {
                            minMavenVersion = requires;
                        }
                    }
                    catch (ArtifactResolutionException | ProjectBuildingException throwable) {}
                }
                catch (VersionRetrievalException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
            if (version == null && versionSpecifiedInCurrentPom) {
                String string = version = artifactVersion != null ? artifactVersion.toString() : null;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("[" + coords + "].version=" + version));
                this.getLog().debug((CharSequence)("[" + coords + "].artifactVersion=" + artifactVersion));
                this.getLog().debug((CharSequence)("[" + coords + "].effectiveVersion=" + effectiveVersion));
                this.getLog().debug((CharSequence)("[" + coords + "].specified=" + versionSpecifiedInCurrentPom));
            }
            if (version == null || !this.processUnboundPlugins && !versionSpecifiedInCurrentPom) {
                version = superPomPluginManagement.get(coords);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("[" + coords + "].superPom.version=" + version));
                }
                String string = artifactVersion != null ? artifactVersion.toString() : (version != null ? version : (newVersion = effectiveVersion != null ? effectiveVersion : "(unknown)"));
                if (version != null) {
                    superPomDrivingMinVersion = true;
                }
                pluginLockdowns.add(DisplayPluginUpdatesMojo.pad(this.compactKey(plugin.getGroupId(), plugin.getArtifactId()), 65 + this.getOutputLineWidthOffset(), superPomDrivingMinVersion ? FROM_SUPER_POM : "", newVersion));
            } else {
                newVersion = artifactVersion != null ? artifactVersion.toString() : null;
            }
            if (version == null || artifactVersion == null || newVersion == null || effectiveVersion == null || ArtifactVersionService.getArtifactVersion((String)effectiveVersion).compareTo((Object)ArtifactVersionService.getArtifactVersion((String)newVersion)) >= 0) continue;
            pluginUpdates.add(DisplayPluginUpdatesMojo.pad(this.compactKey(plugin.getGroupId(), plugin.getArtifactId()), 68 + this.getOutputLineWidthOffset(), effectiveVersion, " -> ", newVersion));
        }
        this.logLine(false, "");
        if (pluginUpdates.isEmpty()) {
            this.logLine(false, "All plugins with a version specified are using the latest versions.");
        } else {
            this.logLine(false, "The following plugin updates are available:");
            for (String string : new TreeSet(pluginUpdates)) {
                this.logLine(false, string);
            }
        }
        this.logLine(false, "");
        if (pluginLockdowns.isEmpty()) {
            this.logLine(false, "All plugins have a version specified.");
        } else {
            this.getLog().warn((CharSequence)"The following plugins do not have their version specified:");
            for (String string : new TreeSet(pluginLockdowns)) {
                this.getLog().warn((CharSequence)string);
            }
        }
        this.logLine(false, "");
        if (specMavenVersion == null) {
            this.getLog().warn((CharSequence)"Project does not define minimum Maven version required for build");
        } else {
            this.logLine(false, "Project requires minimum Maven version for build of: " + specMavenVersion);
        }
        this.logLine(false, "Plugins require minimum Maven version of: " + minMavenVersion);
        if (superPomDrivingMinVersion) {
            this.logLine(false, "Note: the super-pom from Maven " + curMavenVersion + " defines some of the plugin");
            this.logLine(false, "      versions and may be influencing the plugins required minimum Maven");
            this.logLine(false, "      version.");
        }
        this.logLine(false, "");
        if (this.isMavenPluginProject()) {
            if (specMavenVersion == null) {
                this.getLog().warn((CharSequence)"Project (which is a Maven plugin) does not define required minimum version of Maven.");
                this.getLog().warn((CharSequence)"Update the pom.xml to contain");
                this.getLog().warn((CharSequence)"    <prerequisites>");
                this.getLog().warn((CharSequence)"      <maven><!-- minimum version of Maven that the plugin works with --></maven>");
                this.getLog().warn((CharSequence)"    </prerequisites>");
                this.getLog().warn((CharSequence)("To build this plugin you need at least Maven " + minMavenVersion));
                this.getLog().warn((CharSequence)"A Maven Enforcer rule can be used to enforce this if you have not already set one up");
                this.getLog().warn((CharSequence)"See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            } else if (minMavenVersion != null && DisplayPluginUpdatesMojo.compare(specMavenVersion, minMavenVersion) < 0) {
                this.getLog().warn((CharSequence)("Project (which is a Maven plugin) targets Maven " + specMavenVersion + " or newer"));
                this.getLog().warn((CharSequence)("but requires Maven " + minMavenVersion + " or newer to build."));
                this.getLog().warn((CharSequence)"This may or may not be a problem. A Maven Enforcer rule can help ");
                this.getLog().warn((CharSequence)"enforce that the correct version of Maven is used to build this plugin.");
                this.getLog().warn((CharSequence)"See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            } else {
                this.logLine(false, "No plugins require a newer version of Maven than specified by the pom.");
            }
        } else if (specMavenVersion == null) {
            this.logLine(true, "Project does not define required minimum version of Maven.");
            this.logLine(true, "Update the pom.xml to contain maven-enforcer-plugin to");
            this.logLine(true, "force the Maven version which is needed to build this project.");
            this.logLine(true, "See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            this.logLine(true, "Using the minimum version of Maven: " + minMavenVersion);
        } else if (minMavenVersion != null && DisplayPluginUpdatesMojo.compare(specMavenVersion, minMavenVersion) < 0) {
            this.logLine(true, "Project requires an incorrect minimum version of Maven.");
            this.logLine(true, "Update the pom.xml to contain maven-enforcer-plugin to");
            this.logLine(true, "force the Maven version which is needed to build this project.");
            this.logLine(true, "See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
            this.logLine(true, "Using the minimum version of Maven: " + specMavenVersion);
        } else {
            this.logLine(false, "No plugins require a newer version of Maven than specified by the pom.");
        }
        for (Map.Entry entry : mavenUpgrades.entrySet()) {
            ArtifactVersion mavenUpgradeVersion = (ArtifactVersion)entry.getKey();
            Map upgradePlugins = (Map)entry.getValue();
            if (upgradePlugins.isEmpty() || DisplayPluginUpdatesMojo.compare(mavenUpgradeVersion, specMavenVersion) < 0) continue;
            this.logLine(false, "");
            this.logLine(false, "Require Maven " + mavenUpgradeVersion + " to use the following plugin updates:");
            for (Map.Entry entry2 : upgradePlugins.entrySet()) {
                this.logLine(false, (String)entry2.getValue());
            }
        }
        this.logLine(false, "");
    }

    private Pair<ArtifactVersion, String> getEffectivePluginVersion(Plugin plugin, String effectiveVersion, ArtifactVersion specMavenVersion, ArtifactVersion curMavenVersion, Map<ArtifactVersion, Map<String, String>> mavenUpgrades) throws MojoExecutionException, VersionRetrievalException {
        Artifact artifactRange = this.artifactFactory.createMavenPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), effectiveVersion);
        ArtifactVersion[] newerVersions = this.getHelper().lookupArtifactVersions(artifactRange, true).getVersions(this.allowSnapshots);
        ArtifactVersion minRequires = null;
        ArtifactVersion artifactVersion = null;
        for (int j = newerVersions.length - 1; j >= 0; --j) {
            try {
                String upgradePluginKey;
                ArtifactVersion pluginRequires = this.getPrerequisitesMavenVersion(this.getPluginProject(plugin.getGroupId(), plugin.getArtifactId(), newerVersions[j].toString()));
                if (artifactVersion == null && DisplayPluginUpdatesMojo.compare(specMavenVersion, pluginRequires) >= 0) {
                    artifactVersion = newerVersions[j];
                }
                if (effectiveVersion == null && DisplayPluginUpdatesMojo.compare(curMavenVersion, pluginRequires) >= 0) {
                    effectiveVersion = newerVersions[j].toString();
                }
                if (artifactVersion != null && effectiveVersion != null) break;
                if (minRequires != null && DisplayPluginUpdatesMojo.compare(minRequires, pluginRequires) <= 0) continue;
                Map upgradePlugins = mavenUpgrades.computeIfAbsent(pluginRequires, k -> new LinkedHashMap());
                if (!upgradePlugins.containsKey(upgradePluginKey = this.compactKey(plugin.getGroupId(), plugin.getArtifactId()))) {
                    String newer = newerVersions[j].toString();
                    if (newer.equals(effectiveVersion)) {
                        upgradePlugins.put(upgradePluginKey, DisplayPluginUpdatesMojo.pad(upgradePluginKey, 68 + this.getOutputLineWidthOffset(), newer));
                    } else {
                        upgradePlugins.put(upgradePluginKey, DisplayPluginUpdatesMojo.pad(upgradePluginKey, 68 + this.getOutputLineWidthOffset(), effectiveVersion, " -> ", newer));
                    }
                }
                minRequires = pluginRequires;
                continue;
            }
            catch (ArtifactResolutionException | ProjectBuildingException throwable) {
                // empty catch block
            }
        }
        return new ImmutablePair(artifactVersion, (Object)effectiveVersion);
    }

    private MavenProject getPluginProject(String groupId, String artifactId, String version) throws MojoExecutionException, ProjectBuildingException, ArtifactResolutionException {
        Artifact probe = this.artifactFactory.createArtifact(DependencyBuilder.newBuilder().withGroupId(groupId).withArtifactId(artifactId).withVersion(version).withType("pom").withScope("runtime").build());
        this.getHelper().resolveArtifact(probe, true);
        ProjectBuildingResult result = this.projectBuilder.build(probe, true, PomHelper.createProjectBuilderRequest((MavenSession)this.session, (Consumer[])new Consumer[]{r -> r.setProcessPlugins(false), r -> r.setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories()), r -> r.setPluginArtifactRepositories(this.session.getCurrentProject().getPluginArtifactRepositories())}));
        if (!result.getProblems().isEmpty()) {
            this.getLog().warn((CharSequence)("Problems encountered during construction of the plugin POM for " + probe.toString()));
            result.getProblems().forEach(p -> this.getLog().warn((CharSequence)("\t" + p.getMessage())));
        }
        return result.getProject();
    }

    private static String pad(String start, int len, String ... ends) {
        StringBuilder buf = new StringBuilder(len).append("  ").append(start).append(' ');
        int padding = len - Arrays.stream(ends).map(String::valueOf).map(String::length).reduce(Integer::sum).orElse(0);
        IntStream.range(0, padding - buf.length()).forEach(ignored -> buf.append('.'));
        buf.append(' ');
        Arrays.stream(ends).forEach(buf::append);
        return buf.toString();
    }

    private Map<String, String> getParentsPlugins(List<MavenProject> parents) throws MojoExecutionException {
        HashMap<String, String> parentPlugins = new HashMap<String, String>();
        for (MavenProject parentProject : parents) {
            this.getLog().debug((CharSequence)("Processing parent: " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " -> " + parentProject.getFile()));
            StringWriter writer = new StringWriter();
            boolean havePom = false;
            Model originalModel = parentProject.getOriginalModel();
            if (originalModel == null) {
                this.getLog().warn((CharSequence)("project.getOriginalModel()==null for  " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " is null, substituting project.getModel()"));
                originalModel = parentProject.getModel();
            }
            try {
                new MavenXpp3Writer().write((Writer)writer, originalModel);
                writer.close();
                havePom = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest();
            modelBuildingRequest.setUserProperties(this.getProject().getProperties());
            Model interpolatedModel = this.modelInterpolator.interpolateModel(originalModel, null, (ModelBuildingRequest)modelBuildingRequest, (ModelProblemCollector)new IgnoringModelProblemCollector());
            if (havePom) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(writer.toString().getBytes());
                    try {
                        MutableXMLStreamReader pomReader = new MutableXMLStreamReader((InputStream)bais, (Path)Optional.ofNullable(parentProject.getFile()).map(File::toPath).orElse(null));
                        try {
                            Set<String> withVersionSpecified = this.findPluginsWithVersionsSpecified(pomReader);
                            Map<String, String> map = this.getPluginManagement(interpolatedModel);
                            map.keySet().retainAll(withVersionSpecified);
                            parentPlugins.putAll(map);
                            map = this.getBuildPlugins(interpolatedModel, true);
                            map.keySet().retainAll(withVersionSpecified);
                            parentPlugins.putAll(map);
                            map = this.getReportPlugins(interpolatedModel, true);
                            map.keySet().retainAll(withVersionSpecified);
                            parentPlugins.putAll(map);
                            continue;
                        }
                        finally {
                            pomReader.close();
                            continue;
                        }
                    }
                    finally {
                        bais.close();
                        continue;
                    }
                }
                catch (IOException | XMLStreamException | TransformerException e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            parentPlugins.putAll(this.getPluginManagement(interpolatedModel));
            parentPlugins.putAll(this.getBuildPlugins(interpolatedModel, true));
            parentPlugins.putAll(this.getReportPlugins(interpolatedModel, true));
        }
        return parentPlugins;
    }

    private boolean isMavenPluginProject() {
        return "maven-plugin".equals(this.getProject().getPackaging());
    }

    private String compactKey(String groupId, String artifactId) {
        return "org.apache.maven.plugins".equals(groupId) ? artifactId : groupId + ":" + artifactId;
    }

    private Set<String> findPluginsWithVersionsSpecified(MutableXMLStreamReader pom) throws XMLStreamException, IOException, TransformerException {
        HashSet<String> result = new HashSet<String>();
        Stack<StackState> pathStack = new Stack<StackState>();
        StackState curState = new StackState("");
        while (pom.hasNext()) {
            pom.next();
            if (pom.isStartElement()) {
                if (curState != null && PATTERN_PROJECT_PLUGIN.matcher(curState.path).matches()) {
                    if ("groupId".equals(pom.getLocalName())) {
                        curState.groupId = pom.getElementText().trim();
                        continue;
                    }
                    if ("artifactId".equals(pom.getLocalName())) {
                        curState.artifactId = pom.getElementText().trim();
                        continue;
                    }
                    if ("version".equals(pom.getLocalName())) {
                        curState.version = pom.getElementText().trim();
                        continue;
                    }
                }
                assert (curState != null);
                pathStack.push(curState);
                curState = new StackState(curState.path + "/" + pom.getLocalName());
            }
            if (!pom.isEndElement()) continue;
            if (curState != null && PATTERN_PROJECT_PLUGIN.matcher(curState.path).matches() && curState.artifactId != null && curState.version != null) {
                if (curState.groupId == null) {
                    curState.groupId = "org.apache.maven.plugins";
                }
                result.add(curState.groupId + ":" + curState.artifactId);
            }
            curState = (StackState)pathStack.pop();
        }
        return result;
    }

    private ArtifactVersion getPrerequisitesMavenVersion(MavenProject pluginProject) {
        return Optional.ofNullable(pluginProject.getPrerequisites()).map(Prerequisites::getMaven).map(ArtifactVersionService::getArtifactVersion).orElse(null);
    }

    private Map<String, String> getPluginsFromBuild(BuildBase build, boolean onlyIncludeInherited) {
        return Optional.ofNullable(build).flatMap(b -> Optional.ofNullable(b.getPlugins()).map(plugins -> plugins.stream().filter(plugin -> plugin.getVersion() != null).filter(plugin -> !onlyIncludeInherited || DisplayPluginUpdatesMojo.getPluginInherited(plugin)).collect(Collectors.toMap(Plugin::getKey, Plugin::getVersion)))).orElse(Collections.emptyMap());
    }

    private Map<String, String> getBuildPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> buildPlugins = new HashMap<String, String>(this.getPluginsFromBuild((BuildBase)model.getBuild(), onlyIncludeInherited));
        Optional.ofNullable(model.getProfiles()).ifPresent(profiles -> profiles.stream().map(profile -> this.getPluginsFromBuild(profile.getBuild(), onlyIncludeInherited)).forEach(buildPlugins::putAll));
        return buildPlugins;
    }

    private static boolean getPluginInherited(Object plugin) {
        return "true".equalsIgnoreCase(plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getInherited() : ((Plugin)plugin).getInherited());
    }

    private Stream<Plugin> getBoundPlugins(MavenProject project) {
        return this.lifecycleExecutor.getPluginsBoundByDefaultToAllLifecycles(project.getPackaging()).stream().map(p -> new Plugin(this, (Plugin)p){
            final /* synthetic */ Plugin val$p;
            final /* synthetic */ DisplayPluginUpdatesMojo this$0;
            {
                this.val$p = plugin;
                this.this$0 = this$0;
                this.setGroupId(this.val$p.getGroupId());
                this.setArtifactId(this.val$p.getArtifactId());
            }
        });
    }

    private List<MavenProject> getParentProjects(MavenProject project) throws MojoExecutionException {
        ArrayList<MavenProject> parents = new ArrayList<MavenProject>();
        while (project.getParent() != null) {
            project = project.getParent();
            parents.add(0, project);
        }
        return parents;
    }

    private Set<Plugin> getPluginManagementPlugins(Map<String, String> superPomPluginManagement, Map<String, String> parentPluginManagement, Map<String, String> parentBuildPlugins, Map<String, String> parentReportPlugins, Set<String> pluginsWithVersionsSpecified) throws XMLStreamException, IOException, TransformerException {
        this.getLog().debug((CharSequence)"Building list of project plugins...");
        if (this.getLog().isDebugEnabled()) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                new MavenXpp3Writer().write((OutputStream)outputStream, this.getProject().getOriginalModel());
                this.getLog().debug((CharSequence)("Original model:\n" + outputStream));
            }
            catch (IOException e2) {
                this.getLog().debug((Throwable)e2);
            }
        }
        Set extensions = Stream.concat(ExtensionUtils.getCoreExtensions((MavenProject)this.getProject()), ExtensionUtils.getBuildExtensions((MavenProject)this.getProject(), (Log)this.getLog(), (boolean)false)).collect(Collectors.toSet());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Extensions:" + (extensions.isEmpty() ? "(none)" : extensions.stream().map(e -> "\n\t" + e.getGroupId() + ":" + e.getArtifactId() + Optional.ofNullable(e.getVersion()).map(v -> ":").orElse("")).collect(Collectors.joining("\n")))));
        }
        DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest();
        modelBuildingRequest.setUserProperties(this.getProject().getProperties());
        Model originalModel = this.modelInterpolator.interpolateModel(this.getProject().getOriginalModel(), this.getProject().getBasedir(), (ModelBuildingRequest)modelBuildingRequest, (ModelProblemCollector)new IgnoringModelProblemCollector());
        HashMap<String, String> excludePluginManagement = new HashMap<String, String>(superPomPluginManagement);
        excludePluginManagement.putAll(parentPluginManagement);
        this.debugVersionMap("super-pom version map", superPomPluginManagement);
        this.debugVersionMap("parent version map", parentPluginManagement);
        this.debugVersionMap("aggregate version map", excludePluginManagement);
        excludePluginManagement.keySet().removeAll(pluginsWithVersionsSpecified);
        this.debugVersionMap("final aggregate version map", excludePluginManagement);
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        Optional.ofNullable(originalModel.getBuild()).map(DisplayPluginUpdatesMojo::getPluginManagementPlugins).ifPresent(p -> this.mergePluginsMap((Map<String, Plugin>)plugins, (Stream<Plugin>)p, (Map<String, String>)excludePluginManagement));
        this.debugPluginMap("after adding local pluginManagement", plugins);
        this.mergePluginsMap(plugins, this.getLifecyclePlugins(parentPluginManagement), parentPluginManagement);
        this.debugPluginMap("after adding lifecycle plugins", plugins);
        this.debugPluginMap("after adding lifecycle plugins", plugins);
        Optional.ofNullable(originalModel.getBuild()).map(b -> DisplayPluginUpdatesMojo.getBuildPlugins((BuildBase)b, parentPluginManagement, extensions)).ifPresent(p -> this.mergePluginsMap((Map<String, Plugin>)plugins, (Stream<Plugin>)p, parentPluginManagement));
        this.debugPluginMap("after adding build plugins", plugins);
        Optional.ofNullable(originalModel.getReporting()).map(r -> DisplayPluginUpdatesMojo.getReportingPlugins(r, parentPluginManagement)).ifPresent(p -> this.mergePluginsMap((Map<String, Plugin>)plugins, (Stream<Plugin>)p, parentReportPlugins));
        this.debugPluginMap("after adding reporting plugins", plugins);
        for (Profile profile : originalModel.getProfiles()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Processing profile " + profile.getId()));
            }
            Optional.ofNullable(profile.getBuild()).map(DisplayPluginUpdatesMojo::getPluginManagementPlugins).ifPresent(p -> this.mergePluginsMap((Map<String, Plugin>)plugins, (Stream<Plugin>)p, (Map<String, String>)excludePluginManagement));
            this.debugPluginMap("after adding profile " + profile.getId() + " pluginManagement", plugins);
            Optional.ofNullable(profile.getBuild()).map(b -> DisplayPluginUpdatesMojo.getBuildPlugins(b, parentPluginManagement, extensions)).ifPresent(p -> this.mergePluginsMap((Map<String, Plugin>)plugins, (Stream<Plugin>)p, parentBuildPlugins));
            this.debugPluginMap("after adding profile " + profile.getId() + " build plugins", plugins);
            Optional.ofNullable(profile.getReporting()).map(r -> DisplayPluginUpdatesMojo.getReportingPlugins(r, parentPluginManagement)).ifPresent(p -> this.mergePluginsMap((Map<String, Plugin>)plugins, (Stream<Plugin>)p, parentReportPlugins));
            this.debugPluginMap("after adding profile " + profile.getId() + " reporting plugins", plugins);
        }
        TreeSet<Plugin> result = new TreeSet<Plugin>((Comparator<Plugin>)PluginComparator.INSTANCE);
        result.addAll(plugins.values());
        return result;
    }

    private static Stream<Plugin> getReportingPlugins(Reporting reporting, Map<String, String> parentPluginManagement) {
        return reporting.getPlugins().stream().filter(plugin -> plugin.getVersion() != null || parentPluginManagement.get(plugin.getKey()) == null).map(DisplayPluginUpdatesMojo::toPlugin);
    }

    private static Stream<Plugin> getPluginManagementPlugins(BuildBase buildBase) {
        return Optional.ofNullable(buildBase.getPluginManagement()).map(PluginContainer::getPlugins).map(Collection::stream).orElse(Stream.empty());
    }

    private static Stream<Plugin> getBuildPlugins(BuildBase buildBase, Map<String, String> parentPluginManagement, Set<Extension> extensions) {
        return buildBase.getPlugins().stream().filter(plugin -> plugin.getVersion() != null || parentPluginManagement.get(plugin.getKey()) == null).filter(plugin -> extensions.stream().noneMatch(e -> Objects.equals(plugin.getGroupId(), e.getGroupId()) && Objects.equals(plugin.getArtifactId(), e.getArtifactId()) && Optional.ofNullable(e.getVersion()).map(v -> v.equals(plugin.getVersion())).orElseGet(() -> Objects.isNull(plugin.getVersion())) != false));
    }

    private Stream<Plugin> getLifecyclePlugins(Map<String, String> parentPluginManagement) {
        return this.getBoundPlugins(this.getProject()).filter(Objects::nonNull).filter(p -> p.getKey() != null).filter(p -> p.getVersion() != null).filter(p -> parentPluginManagement.get(p.getKey()) != null);
    }

    private void mergePluginsMap(Map<String, Plugin> plugins, Stream<Plugin> pluginsToMerge, Map<String, String> parentDefinitions) {
        pluginsToMerge.forEach(plugin -> plugins.compute(plugin.getKey(), (key, existingVal) -> {
            String versionFromParent = (String)parentDefinitions.get(key);
            if (plugin.getVersion() == null && (existingVal == null || existingVal.getVersion() == null) && versionFromParent != null) {
                Plugin parentPlugin = new Plugin();
                parentPlugin.setGroupId(plugin.getGroupId());
                parentPlugin.setArtifactId(plugin.getArtifactId());
                parentPlugin.setVersion(versionFromParent);
                return parentPlugin;
            }
            if (!(versionFromParent != null && versionFromParent.equals(plugin.getVersion()) || existingVal != null && existingVal.getVersion() != null)) {
                return plugin;
            }
            if (!this.processUnboundPlugins) {
                return existingVal != null ? existingVal : plugin;
            }
            return plugin.getVersion() != null ? plugin : existingVal;
        }));
    }

    private void debugPluginMap(String description, Map<String, Plugin> plugins) {
        if (this.getLog().isDebugEnabled()) {
            TreeSet<Plugin> sorted = new TreeSet<Plugin>((Comparator<Plugin>)PluginComparator.INSTANCE);
            sorted.addAll(plugins.values());
            this.getLog().debug((CharSequence)sorted.stream().collect(() -> new StringBuilder(description), (s, e) -> s.append("\n    ").append(e.getKey()).append(":").append(e.getVersion()), StringBuilder::append));
        }
    }

    private void debugVersionMap(String description, Map<String, String> pluginVersions) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)pluginVersions.entrySet().stream().collect(() -> new StringBuilder(description), (s, e) -> s.append("\n    ").append((String)e.getKey()).append(":").append((String)e.getValue()), StringBuilder::append));
        }
    }

    private static Plugin toPlugin(ReportPlugin reportPlugin) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        plugin.setVersion(reportPlugin.getVersion());
        return plugin;
    }

    private static Stream<Plugin> toPlugins(Collection<ReportPlugin> reportPlugins) {
        return reportPlugins.stream().map(DisplayPluginUpdatesMojo::toPlugin);
    }

    private Map<String, String> getReportPlugins(Model model, boolean onlyIncludeInherited) {
        return Stream.concat(Optional.ofNullable(model.getReporting()).map(Reporting::getPlugins).map(Collection::stream).orElse(Stream.empty()), Optional.ofNullable(model.getProfiles()).flatMap(profiles -> profiles.stream().map(ModelBase::getReporting).filter(Objects::nonNull).map(Reporting::getPlugins).map(Collection::stream).reduce(Stream::concat)).orElse(Stream.empty())).filter(p -> p.getVersion() != null).filter(p -> !onlyIncludeInherited || DisplayPluginUpdatesMojo.getPluginInherited(p)).collect(Collectors.toMap(ReportPlugin::getKey, ReportPlugin::getVersion));
    }

    @Override
    protected void update(MutableXMLStreamReader pom) {
    }

    private static int compare(ArtifactVersion a, ArtifactVersion b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareTo((Object)b));
    }

    private static final class StackState {
        private final String path;
        private String groupId;
        private String artifactId;
        private String version;

        StackState(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path + "[groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
        }
    }

    private static class IgnoringModelProblemCollector
    implements ModelProblemCollector {
        private IgnoringModelProblemCollector() {
        }

        public void add(ModelProblemCollectorRequest req) {
        }
    }
}

