/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.StringUtils;

public class SetMojo
extends AbstractVersionsUpdaterMojo {
    private String newVersion;
    private final transient List sourceChanges = new ArrayList();

    private synchronized void addChange(String groupId, String artifactId, String oldVersion, String newVersion) {
        if (!newVersion.equals(oldVersion)) {
            this.sourceChanges.add(new Change(groupId, artifactId, oldVersion, newVersion));
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getProject().getOriginalModel().getVersion() == null) {
            throw new MojoExecutionException("Project version is inherited from parent.");
        }
        this.addChange(this.getProject().getGroupId(), this.getProject().getArtifactId(), this.getProject().getVersion(), this.newVersion);
        try {
            MavenProject project = PomHelper.getLocalRoot(this.projectBuilder, this.getProject(), this.localRepository, null, this.getLog());
            this.getLog().info((CharSequence)("Local aggregation root: " + project.getBasedir()));
            Map reactor = PomHelper.getReactorModels(project, this.getLog());
            Model current = PomHelper.getModel(reactor, this.getProject().getGroupId(), this.getProject().getArtifactId());
            current.setVersion(this.newVersion);
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            files.add(this.getProject().getFile());
            ArrayList order = new ArrayList(reactor.keySet());
            Collections.sort(order, new ReactorDepthComparator(reactor));
            Iterator i = order.iterator();
            while (i.hasNext()) {
                String sourcePath = (String)i.next();
                Model sourceModel = (Model)reactor.get(sourcePath);
                this.getLog().debug((CharSequence)(sourcePath.length() == 0 ? "Processing root module as parent" : "Processing " + sourcePath + " as a parent."));
                String sourceGroupId = PomHelper.getGroupId(sourceModel);
                if (sourceGroupId == null) {
                    this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a groupId."));
                    continue;
                }
                String sourceArtifactId = PomHelper.getArtifactId(sourceModel);
                if (sourceArtifactId == null) {
                    this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing an artifactId."));
                    continue;
                }
                String sourceVersion = PomHelper.getVersion(sourceModel);
                if (sourceVersion == null) {
                    this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a version."));
                    continue;
                }
                File moduleDir = new File(project.getBasedir(), sourcePath);
                File moduleProjectFile = moduleDir.isDirectory() ? new File(moduleDir, "pom.xml") : moduleDir;
                files.add(moduleProjectFile);
                this.getLog().debug((CharSequence)("Looking for modules which use " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + " as their parent"));
                Iterator j = PomHelper.getChildModels(reactor, sourceGroupId, sourceArtifactId).entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry target = j.next();
                    String targetPath = (String)target.getKey();
                    Model targetModel = (Model)target.getValue();
                    Parent parent = targetModel.getParent();
                    this.getLog().debug((CharSequence)("Module: " + targetPath));
                    if (sourceVersion.equals(parent.getVersion())) {
                        this.getLog().debug((CharSequence)("    parent already is " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + sourceVersion));
                    } else {
                        this.getLog().debug((CharSequence)("    parent is " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + parent.getVersion()));
                        this.getLog().debug((CharSequence)("    will become " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + sourceVersion));
                    }
                    if (StringUtils.equals((String)parent.getVersion(), (String)PomHelper.getVersion(targetModel))) {
                        this.getLog().debug((CharSequence)("    module is " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + PomHelper.getVersion(targetModel)));
                        this.getLog().debug((CharSequence)("    will become " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + sourceVersion));
                        this.addChange(PomHelper.getGroupId(targetModel), PomHelper.getArtifactId(targetModel), PomHelper.getVersion(targetModel), sourceVersion);
                        targetModel.setVersion(sourceVersion);
                        continue;
                    }
                    this.getLog().debug((CharSequence)("    module is " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + PomHelper.getVersion(targetModel)));
                }
            }
            Iterator k = files.iterator();
            while (k.hasNext()) {
                this.process((File)k.next());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected synchronized void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            Model model = PomHelper.getRawModel(pom);
            boolean gaveInfo = false;
            Iterator i = this.sourceChanges.iterator();
            while (i.hasNext()) {
                Change change = (Change)i.next();
                if (change.getGroupId().equals(PomHelper.getGroupId(model)) && change.getArtifactId().equals(PomHelper.getArtifactId(model))) {
                    if (PomHelper.setProjectVersion(pom, change.getNewVersion())) {
                        if (!gaveInfo) {
                            this.getLog().info((CharSequence)("Processing " + PomHelper.getGroupId(model) + ":" + PomHelper.getArtifactId(model)));
                            gaveInfo = true;
                        }
                        this.getLog().info((CharSequence)("    Updating project " + change.getGroupId() + ":" + change.getArtifactId()));
                        this.getLog().info((CharSequence)("        from version " + change.getOldVersion() + " to " + change.getNewVersion()));
                    }
                } else if (model.getParent() != null && change.getGroupId().equals(model.getParent().getGroupId()) && change.getArtifactId().equals(model.getParent().getArtifactId()) && PomHelper.setProjectParentVersion(pom, change.getNewVersion())) {
                    if (!gaveInfo) {
                        this.getLog().info((CharSequence)("Processing " + PomHelper.getGroupId(model) + ":" + PomHelper.getArtifactId(model)));
                        gaveInfo = true;
                    }
                    this.getLog().info((CharSequence)("    Updating parent " + change.getGroupId() + ":" + change.getArtifactId()));
                    this.getLog().info((CharSequence)("        from version " + change.getOldVersion() + " to " + change.getNewVersion()));
                }
                if (PomHelper.setDependencyVersion(pom, change.getGroupId(), change.getArtifactId(), change.getOldVersion(), change.getNewVersion())) {
                    if (!gaveInfo) {
                        this.getLog().info((CharSequence)("Processing " + PomHelper.getGroupId(model) + ":" + PomHelper.getArtifactId(model)));
                        gaveInfo = true;
                    }
                    this.getLog().info((CharSequence)("    Updating dependency " + change.getGroupId() + ":" + change.getArtifactId()));
                    this.getLog().info((CharSequence)("        from version " + change.getOldVersion() + " to " + change.getNewVersion()));
                }
                if (!PomHelper.setPluginVersion(pom, change.getGroupId(), change.getArtifactId(), change.getOldVersion(), change.getNewVersion())) continue;
                if (!gaveInfo) {
                    this.getLog().info((CharSequence)("Processing " + PomHelper.getGroupId(model) + ":" + PomHelper.getArtifactId(model)));
                    gaveInfo = true;
                }
                this.getLog().info((CharSequence)("    Updating plugin " + change.getGroupId() + ":" + change.getArtifactId()));
                this.getLog().info((CharSequence)("        from version " + change.getOldVersion() + " to " + change.getNewVersion()));
            }
            if (gaveInfo) {
                this.getLog().info((CharSequence)"");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private static class ReactorDepthComparator
    implements Comparator {
        private final Map reactor;

        public ReactorDepthComparator(Map reactor) {
            this.reactor = reactor;
        }

        public int compare(Object o1, Object o2) {
            int d2;
            Model m1 = (Model)this.reactor.get(o1);
            Model m2 = (Model)this.reactor.get(o2);
            int d1 = PomHelper.getReactorParentCount(this.reactor, m1);
            if (d1 < (d2 = PomHelper.getReactorParentCount(this.reactor, m2))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    private static final class Change {
        private final String groupId;
        private final String artifactId;
        private final String oldVersion;
        private final String newVersion;

        private Change(String groupId, String artifactId, String oldVersion, String newVersion) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getOldVersion() {
            return this.oldVersion;
        }

        public String getNewVersion() {
            return this.newVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Change change = (Change)o;
            if (this.artifactId != null ? !this.artifactId.equals(change.artifactId) : change.artifactId != null) {
                return false;
            }
            if (this.groupId != null ? !this.groupId.equals(change.groupId) : change.groupId != null) {
                return false;
            }
            if (this.newVersion != null ? !this.newVersion.equals(change.newVersion) : change.newVersion != null) {
                return false;
            }
            return !(this.oldVersion != null ? !this.oldVersion.equals(change.oldVersion) : change.oldVersion != null);
        }

        public int hashCode() {
            int result = this.groupId != null ? this.groupId.hashCode() : 0;
            result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
            result = 31 * result + (this.oldVersion != null ? this.oldVersion.hashCode() : 0);
            result = 31 * result + (this.newVersion != null ? this.newVersion.hashCode() : 0);
            return result;
        }
    }
}

