/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public class PropertyVersions
extends AbstractVersionDetails {
    private final String name;
    private final String profileId;
    private final Set associations;
    private final VersionsHelper helper;
    private final SortedSet versions;
    private final PropertyVersionComparator comparator;
    static final /* synthetic */ boolean $assertionsDisabled;

    PropertyVersions(String profileId, String name, VersionsHelper helper, Set associations) throws ArtifactMetadataRetrievalException {
        this.profileId = profileId;
        this.name = name;
        this.helper = helper;
        this.associations = new TreeSet(associations);
        this.comparator = new PropertyVersionComparator();
        this.versions = PropertyVersions.resolveAssociatedVersions(helper, associations, this.comparator);
    }

    private static SortedSet resolveAssociatedVersions(VersionsHelper helper, Set associations, VersionComparator versionComparator) throws ArtifactMetadataRetrievalException {
        TreeSet<ArtifactVersion> versions = null;
        Iterator i = associations.iterator();
        while (i.hasNext()) {
            ArtifactAssociation association = (ArtifactAssociation)i.next();
            ArtifactVersions associatedVersions = helper.lookupArtifactVersions(association.getArtifact(), association.isUsePluginRepositories());
            if (versions != null) {
                ArtifactVersion[] artifactVersions = associatedVersions.getVersions(true);
                Iterator j = versions.iterator();
                while (j.hasNext()) {
                    boolean contains = false;
                    ArtifactVersion version = (ArtifactVersion)j.next();
                    for (int k = 0; k < artifactVersions.length; ++k) {
                        if (version.compareTo((Object)artifactVersions[k]) != 0) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    j.remove();
                }
                continue;
            }
            versions = new TreeSet(versionComparator);
            versions.addAll(Arrays.asList(associatedVersions.getVersions(true)));
        }
        if (versions == null) {
            versions = new TreeSet<ArtifactVersion>(versionComparator);
        }
        return Collections.unmodifiableSortedSet(versions);
    }

    public VersionComparator getVersionComparator() {
        return this.comparator;
    }

    public ArtifactAssociation[] getAssociations() {
        return this.associations.toArray(new ArtifactAssociation[this.associations.size()]);
    }

    private VersionComparator[] lookupComparators() {
        HashSet<VersionComparator> result = new HashSet<VersionComparator>();
        Iterator i = this.associations.iterator();
        while (i.hasNext()) {
            ArtifactAssociation association = (ArtifactAssociation)i.next();
            result.add(this.helper.getVersionComparator(association.getArtifact()));
        }
        return result.toArray(new VersionComparator[result.size()]);
    }

    public ArtifactVersion[] getVersions(Collection artifacts) throws MojoExecutionException {
        ArrayList<ArtifactVersion> result = new ArrayList<ArtifactVersion>();
        Iterator i = this.associations.iterator();
        while (i.hasNext()) {
            ArtifactAssociation association = (ArtifactAssociation)i.next();
            Iterator j = artifacts.iterator();
            while (j.hasNext()) {
                Artifact artifact = (Artifact)j.next();
                if (!association.getGroupId().equals(artifact.getGroupId()) || !association.getArtifactId().equals(artifact.getArtifactId())) continue;
                try {
                    result.add(artifact.getSelectedVersion());
                }
                catch (OverConstrainedVersionException e) {}
            }
        }
        Iterator k = result.iterator();
        block6: while (k.hasNext()) {
            ArtifactVersion candidate = (ArtifactVersion)k.next();
            i = this.associations.iterator();
            while (i.hasNext()) {
                ArtifactAssociation association = (ArtifactAssociation)i.next();
                boolean haveMatch = false;
                Iterator j = artifacts.iterator();
                while (j.hasNext() && !haveMatch) {
                    Artifact artifact = (Artifact)j.next();
                    if (!association.getGroupId().equals(artifact.getGroupId()) || !association.getArtifactId().equals(artifact.getArtifactId())) continue;
                    try {
                        haveMatch = candidate.toString().equals(artifact.getSelectedVersion().toString());
                    }
                    catch (OverConstrainedVersionException e) {}
                }
                if (haveMatch) continue;
                k.remove();
                continue block6;
            }
        }
        return this.asArtifactVersionArray(result);
    }

    public synchronized ArtifactVersion[] getVersions(boolean includeSnapshots) {
        TreeSet<ArtifactVersion> result;
        if (includeSnapshots) {
            result = this.versions;
        } else {
            result = new TreeSet<ArtifactVersion>(this.getVersionComparator());
            Iterator i = this.versions.iterator();
            while (i.hasNext()) {
                ArtifactVersion candidate = (ArtifactVersion)i.next();
                if (ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
                result.add(candidate);
            }
        }
        return this.asArtifactVersionArray(result);
    }

    private ArtifactVersion[] asArtifactVersionArray(Collection result) {
        if (result == null || result.isEmpty()) {
            return new ArtifactVersion[0];
        }
        Object[] answer = result.toArray(new ArtifactVersion[result.size()]);
        VersionComparator[] rules = this.lookupComparators();
        if (!$assertionsDisabled && rules.length <= 0) {
            throw new AssertionError();
        }
        Arrays.sort(answer, rules[0]);
        if (rules.length == 1 || answer.length == 1) {
            return answer;
        }
        Object[] alt = (ArtifactVersion[])answer.clone();
        for (int j = 1; j < rules.length; ++j) {
            Arrays.sort(alt, rules[j]);
            if (Arrays.equals(alt, answer)) continue;
            throw new IllegalStateException("Property " + this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the set of versions available to this property.\nFirst rule says: " + Arrays.asList(answer) + "\nSecond rule says: " + Arrays.asList(alt));
        }
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public boolean isAssociated() {
        return !this.associations.isEmpty();
    }

    public String toString() {
        return "PropertyVersions{" + (this.profileId == null ? "" : "profileId='" + this.profileId + "', ") + "name='" + this.name + '\'' + ", associations=" + this.associations + '}';
    }

    public ArtifactVersion getNewestVersion(String currentVersion, Property property, Boolean allowSnapshots, List reactorProjects, VersionsHelper helper) throws MojoExecutionException {
        VersionRange range;
        boolean includeSnapshots = !property.isBanSnapshots() && Boolean.TRUE.equals(allowSnapshots);
        helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Set of valid available versions is " + Arrays.asList(this.getVersions(includeSnapshots))));
        try {
            if (property.getVersion() != null) {
                range = VersionRange.createFromVersionSpec((String)property.getVersion());
                helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Restricting results to " + range));
            } else {
                range = null;
                helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Restricting results to " + range));
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Object result = this.getNewestVersion(range, helper.createArtifactVersion(currentVersion), null, includeSnapshots, false, true);
        helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Current winner is: " + result));
        if (property.isSearchReactor()) {
            helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Searching reactor for a valid version..."));
            Set reactorArtifacts = helper.extractArtifacts(reactorProjects);
            ArtifactVersion[] reactorVersions = this.getVersions(reactorArtifacts);
            helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Set of valid available versions from the reactor is " + Arrays.asList(reactorVersions)));
            Object fromReactor = null;
            if (reactorVersions.length > 0) {
                for (int j = reactorVersions.length - 1; j >= 0; --j) {
                    if (range != null && !range.containsVersion(reactorVersions[j])) continue;
                    fromReactor = reactorVersions[j];
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has version " + fromReactor));
                    break;
                }
            }
            if (!(fromReactor == null || result == null && currentVersion.equals(fromReactor.toString()))) {
                if (property.isPreferReactor()) {
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has a version and we prefer the reactor"));
                    result = fromReactor;
                } else if (result == null) {
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has the only version"));
                    result = fromReactor;
                } else if (this.getVersionComparator().compare(result, fromReactor) < 0) {
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has a newer version"));
                    result = fromReactor;
                } else {
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has the same or older version"));
                }
            }
        }
        return result;
    }

    static {
        $assertionsDisabled = !PropertyVersions.class.desiredAssertionStatus();
    }

    private final class PropertyVersionComparator
    implements VersionComparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        private PropertyVersionComparator() {
        }

        public int compare(ArtifactVersion v1, ArtifactVersion v2) {
            return this.innerCompare(v1, v2);
        }

        private int innerCompare(ArtifactVersion v1, ArtifactVersion v2) {
            if (!PropertyVersions.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersions.this.lookupComparators();
            if (!$assertionsDisabled && comparators.length < 1) {
                throw new AssertionError((Object)"we have at least one association => at least one comparator");
            }
            int result = comparators[0].compare(v1, v2);
            for (int i = 1; i < comparators.length; ++i) {
                int alt = comparators[i].compare(v1, v2);
                if ((result == alt || result < 0 || alt >= 0) && (result > 0 || alt <= 0)) continue;
                throw new IllegalStateException("Property " + PropertyVersions.this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + result + "\nSecond rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + alt);
            }
            return result;
        }

        public int compare(Object o1, Object o2) {
            return this.innerCompare((ArtifactVersion)o1, (ArtifactVersion)o2);
        }

        public int getSegmentCount(ArtifactVersion v) {
            if (!PropertyVersions.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersions.this.lookupComparators();
            if (!$assertionsDisabled && comparators.length < 1) {
                throw new AssertionError((Object)"we have at least one association => at least one comparator");
            }
            int result = comparators[0].getSegmentCount(v);
            for (int i = 1; i < comparators.length; ++i) {
                int alt = comparators[i].getSegmentCount(v);
                if (result == alt) continue;
                throw new IllegalStateException("Property " + PropertyVersions.this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says getSegmentCount(\"" + v + "\") = " + result + "\nSecond rule says getSegmentCount(\"" + v + "\") = " + alt);
            }
            return result;
        }

        public ArtifactVersion incrementSegment(ArtifactVersion v, int segment) {
            if (!PropertyVersions.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersions.this.lookupComparators();
            if (!$assertionsDisabled && comparators.length < 1) {
                throw new AssertionError((Object)"we have at least one association => at least one comparator");
            }
            ArtifactVersion result = comparators[0].incrementSegment(v, segment);
            for (int i = 1; i < comparators.length; ++i) {
                ArtifactVersion alt = comparators[i].incrementSegment(v, segment);
                if (result.toString().equals(alt.toString())) continue;
                throw new IllegalStateException("Property " + PropertyVersions.this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says incrementSegment(\"" + v + "\", " + segment + ") = " + result + "\nSecond rule says incrementSegment(\"" + v + "\", " + segment + ") = " + alt);
            }
            return result;
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$mojo$versions$api$PropertyVersions == null ? (class$org$codehaus$mojo$versions$api$PropertyVersions = PropertyVersions.class$("org.codehaus.mojo.versions.api.PropertyVersions")) : class$org$codehaus$mojo$versions$api$PropertyVersions).desiredAssertionStatus();
        }
    }
}

