/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;

public abstract class AbstractVersionsDependencyUpdaterMojo
extends AbstractVersionsUpdaterMojo {
    private String includes = null;
    private String excludes = null;
    private Boolean processDependencies;
    private Boolean processDependencyManagement;
    private PatternIncludesArtifactFilter includesFilter;
    private PatternExcludesArtifactFilter excludesFilter;
    private Boolean excludeReactor;

    public boolean isProcessingDependencies() {
        return !Boolean.FALSE.equals(this.processDependencies);
    }

    public boolean isProcessingDependencyManagement() {
        return !Boolean.FALSE.equals(this.processDependencyManagement);
    }

    public boolean isExcludeReactor() {
        return !Boolean.FALSE.equals(this.excludeReactor);
    }

    protected Artifact findArtifact(Dependency dependency) {
        if (this.getProject().getDependencyArtifacts() == null) {
            return null;
        }
        Iterator iter = this.getProject().getDependencyArtifacts().iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!this.compare(artifact, dependency)) continue;
            return artifact;
        }
        return null;
    }

    protected Artifact toArtifact(Dependency dependency) throws MojoExecutionException {
        Artifact artifact = this.findArtifact(dependency);
        if (artifact == null) {
            try {
                return this.getHelper().createDependencyArtifact(dependency);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return artifact;
    }

    protected String toString(Dependency d) {
        StringBuffer buf = new StringBuffer();
        buf.append(d.getGroupId());
        buf.append(':');
        buf.append(d.getArtifactId());
        if (d.getType() != null && d.getType().length() > 0) {
            buf.append(':');
            buf.append(d.getType());
            if (d.getType() != null && d.getType().length() > 0) {
                buf.append(':');
                buf.append(d.getClassifier());
            }
        } else if (d.getClassifier() != null && d.getClassifier().length() > 0) {
            buf.append(":jar:");
            buf.append(d.getClassifier());
        }
        if (d.getVersion() != null && d.getVersion().length() > 0) {
            buf.append(":");
            buf.append(d.getVersion());
        }
        return buf.toString();
    }

    protected boolean isProducedByReactor(Dependency dependency) {
        Iterator iter = this.reactorProjects.iterator();
        while (iter.hasNext()) {
            MavenProject project = (MavenProject)iter.next();
            if (!this.compare(project, dependency)) continue;
            return true;
        }
        return false;
    }

    private boolean compare(MavenProject project, Dependency dep) {
        if (!StringUtils.equals((String)project.getGroupId(), (String)dep.getGroupId())) {
            return false;
        }
        return StringUtils.equals((String)project.getArtifactId(), (String)dep.getArtifactId());
    }

    private boolean compare(Artifact artifact, Dependency dep) {
        if (!StringUtils.equals((String)artifact.getGroupId(), (String)dep.getGroupId())) {
            return false;
        }
        if (!StringUtils.equals((String)artifact.getArtifactId(), (String)dep.getArtifactId())) {
            return false;
        }
        if (!StringUtils.equals((String)artifact.getType(), (String)dep.getType())) {
            return false;
        }
        return StringUtils.equals((String)artifact.getClassifier(), (String)dep.getClassifier());
    }

    protected boolean isIncluded(Artifact artifact) {
        ArtifactFilter excludesFilter;
        boolean result = true;
        ArtifactFilter includesFilter = this.getIncludesArtifactFilter();
        if (includesFilter != null) {
            result = includesFilter.include(artifact);
        }
        if ((excludesFilter = this.getExcludesArtifactFilter()) != null) {
            result = excludesFilter.include(artifact);
        }
        return result;
    }

    private ArtifactFilter getIncludesArtifactFilter() {
        if (this.includesFilter == null && this.includes != null) {
            List<String> patterns = Arrays.asList(this.includes.split(","));
            this.includesFilter = new PatternIncludesArtifactFilter(patterns);
        }
        return this.includesFilter;
    }

    private ArtifactFilter getExcludesArtifactFilter() {
        if (this.excludesFilter == null && this.excludes != null) {
            List<String> patterns = Arrays.asList(this.excludes.split(","));
            this.excludesFilter = new PatternExcludesArtifactFilter(patterns);
        }
        return this.excludesFilter;
    }
}

