/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.LinkItem;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UpdatePropertiesMojo
extends AbstractVersionsUpdaterMojo {
    private static final String REGEX_QUOTE_END = "\\E";
    private static final String REGEX_QUOTE_START = "\\Q";
    private static final String REGEX_QUOTE_END_ESCAPED = "\\E\\\\E\\Q";
    private LinkItem[] linkItems;
    private String includeProperties = null;
    private String excludeProperties = null;
    private Boolean autoLinkItems;

    private static String quote(String s) {
        int i = s.indexOf(REGEX_QUOTE_END);
        if (i == -1) {
            return REGEX_QUOTE_START + s + REGEX_QUOTE_END;
        }
        StringBuffer sb = new StringBuffer(s.length() + 32);
        sb.append(REGEX_QUOTE_START);
        int pos = 0;
        do {
            sb.append(s.substring(pos, i));
            sb.append(REGEX_QUOTE_END_ESCAPED);
        } while ((i = s.indexOf(REGEX_QUOTE_END, pos = i + REGEX_QUOTE_END.length())) != -1);
        sb.append(s.substring(pos, s.length()));
        sb.append(REGEX_QUOTE_END);
        return sb.toString();
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        LinkItem[] items;
        XMLEvent event;
        if (this.autoLinkItems == null || Boolean.TRUE.equals(this.autoLinkItems)) {
            LinkItem candidate;
            int end;
            int middle;
            int start;
            String text;
            HashMap<String, LinkItem> properties = new HashMap<String, LinkItem>();
            if (this.linkItems != null) {
                for (int i = 0; i < this.linkItems.length; ++i) {
                    properties.put(this.linkItems[i].getProperty(), this.linkItems[i]);
                }
            }
            this.getLog().info((CharSequence)"Searching for properties to update");
            HashMap<String, LinkItem> localDependencies = new HashMap<String, LinkItem>();
            HashSet<String> localProperties = new HashSet<String>();
            Stack<String> stack = new Stack<String>();
            String path = "";
            String groupId = null;
            String artifactId = null;
            String property = null;
            String versions = null;
            Pattern dependencyPathMatcher = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)?|(/build(/pluginManagement)?/plugins/plugin))/dependencies/dependency/(groupId|artifactId|version)");
            Pattern propertyPathMatcher = Pattern.compile("/project(/profiles/profile)?/properties/[^/]*");
            while (pom.hasNext()) {
                event = pom.nextEvent();
                if (event.isStartDocument()) {
                    path = "";
                    stack.clear();
                    continue;
                }
                if (event.isStartElement()) {
                    stack.push(path);
                    path = path + "/" + event.asStartElement().getName().getLocalPart();
                    if (dependencyPathMatcher.matcher(path).matches()) {
                        text = pom.getElementText().trim();
                        if (path.endsWith("groupId")) {
                            groupId = text;
                        } else if (path.endsWith("artifactId")) {
                            artifactId = text;
                        } else if (path.endsWith("version")) {
                            start = text.indexOf("${");
                            middle = text.indexOf("${", start + 1);
                            end = text.lastIndexOf("}");
                            if (start != -1 && end != -1 && end > start && middle == -1) {
                                property = text.substring(start + 2, end).trim();
                                if (start > 0 && end < text.length()) {
                                    String prefix = text.substring(0, start).trim();
                                    String postfix = text.substring(end + 1, text.length()).trim();
                                    if ((prefix.startsWith("[") || prefix.startsWith("(")) && (postfix.endsWith("]") || postfix.endsWith(")")) && (prefix.length() > 1 || postfix.length() > 1)) {
                                        versions = prefix + postfix;
                                    }
                                }
                            }
                        }
                        path = (String)stack.pop();
                        continue;
                    }
                    if (path.endsWith("dependency")) {
                        groupId = null;
                        artifactId = null;
                        property = null;
                        versions = null;
                        continue;
                    }
                    if (!propertyPathMatcher.matcher(path).matches() || properties.containsKey(property = event.asStartElement().getName().getLocalPart()) || localProperties.contains(property)) continue;
                    candidate = (LinkItem)localDependencies.remove(property);
                    if (candidate == null) {
                        localProperties.add(property);
                        continue;
                    }
                    properties.put(property, candidate);
                    this.getLog().info((CharSequence)("Associating property ${" + property + "} with " + ArtifactUtils.versionlessKey((String)candidate.getGroupId(), (String)candidate.getArtifactId()) + (candidate.getVersion() != null ? " within the version range " + candidate.getVersion() : "")));
                    continue;
                }
                if (!event.isEndElement()) continue;
                if (path.endsWith("dependency") && groupId != null && artifactId != null && property != null && !properties.containsKey(property)) {
                    candidate = new LinkItem();
                    candidate.setGroupId(groupId);
                    candidate.setArtifactId(artifactId);
                    candidate.setProperty(property);
                    if (versions != null) {
                        candidate.setVersion(versions);
                    }
                    if (localProperties.contains(property)) {
                        properties.put(property, candidate);
                        localProperties.remove(property);
                        this.getLog().info((CharSequence)("Associating property ${" + property + "} with " + ArtifactUtils.versionlessKey((String)candidate.getGroupId(), (String)candidate.getArtifactId()) + (candidate.getVersion() != null ? " within the version range " + candidate.getVersion() : "")));
                    } else {
                        localDependencies.put(property, candidate);
                    }
                }
                path = (String)stack.pop();
            }
            dependencyPathMatcher = Pattern.compile("/project(/profiles/profile)?((/reporting/plugins/plugin)?|(/build(/pluginManagement)?/plugins/plugin))/(groupId|artifactId|version)");
            pom.rewind();
            while (pom.hasNext()) {
                event = pom.nextEvent();
                if (event.isStartDocument()) {
                    path = "";
                    stack.clear();
                    continue;
                }
                if (event.isStartElement()) {
                    stack.push(path);
                    path = path + "/" + event.asStartElement().getName().getLocalPart();
                    if (dependencyPathMatcher.matcher(path).matches()) {
                        text = pom.getElementText().trim();
                        if (path.endsWith("groupId")) {
                            groupId = text;
                        } else if (path.endsWith("artifactId")) {
                            artifactId = text;
                        } else if (path.endsWith("version")) {
                            start = text.indexOf("${");
                            middle = text.indexOf("${", start + 1);
                            end = text.lastIndexOf("}");
                            if (start != -1 && end != -1 && end > start && middle == -1) {
                                property = text.substring(start + 2, end).trim();
                            }
                        }
                        path = (String)stack.pop();
                        continue;
                    }
                    if (path.endsWith("plugin")) {
                        groupId = null;
                        artifactId = null;
                        property = null;
                        versions = null;
                        continue;
                    }
                    if (!propertyPathMatcher.matcher(path).matches() || properties.containsKey(property = event.asStartElement().getName().getLocalPart()) || localProperties.contains(property)) continue;
                    candidate = (LinkItem)localDependencies.remove(property);
                    if (candidate == null) {
                        localProperties.add(property);
                        continue;
                    }
                    properties.put(property, candidate);
                    this.getLog().info((CharSequence)("Associating property ${" + property + "} with " + ArtifactUtils.versionlessKey((String)candidate.getGroupId(), (String)candidate.getArtifactId()) + (candidate.getVersion() != null ? " within the version range " + candidate.getVersion() : "")));
                    continue;
                }
                if (!event.isEndElement()) continue;
                if (path.endsWith("dependency") && groupId != null && artifactId != null && property != null && !properties.containsKey(property)) {
                    candidate = new LinkItem();
                    candidate.setGroupId(groupId);
                    candidate.setArtifactId(artifactId);
                    candidate.setProperty(property);
                    if (versions != null) {
                        candidate.setVersion(versions);
                    }
                    if (localProperties.contains(property)) {
                        properties.put(property, candidate);
                        localProperties.remove(property);
                        this.getLog().info((CharSequence)("Associating property ${" + property + "} with " + ArtifactUtils.versionlessKey((String)candidate.getGroupId(), (String)candidate.getArtifactId()) + (candidate.getVersion() != null ? " within the version range " + candidate.getVersion() : "")));
                    } else {
                        localDependencies.put(property, candidate);
                    }
                }
                path = (String)stack.pop();
            }
            items = properties.values().toArray(new LinkItem[properties.size()]);
        } else {
            items = this.linkItems;
        }
        if (items == null || items.length == 0) {
            this.getLog().info((CharSequence)"Nothing to link");
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            VersionRange versionRange;
            LinkItem item = items[i];
            if (this.includeProperties != null && this.includeProperties.indexOf(item.getProperty()) < 0) {
                this.getLog().debug((CharSequence)("Skipping update of property \"" + item.getProperty() + "\""));
                continue;
            }
            if (this.excludeProperties != null && this.excludeProperties.indexOf(item.getProperty()) >= 0) {
                this.getLog().debug((CharSequence)("Ignoring update of property \"" + item.getProperty() + "\""));
                continue;
            }
            String itemCoords = ArtifactUtils.versionlessKey((String)item.getGroupId(), (String)item.getArtifactId());
            String curVer = this.getPropertyValue(pom.asStringBuffer(), item.getProperty());
            String version = curVer;
            if (version == null) {
                this.getLog().warn((CharSequence)("This project does not define the property \"" + item.getProperty() + "\""));
                continue;
            }
            if (item.getVersion() != null) {
                version = item.getVersion();
            }
            try {
                versionRange = VersionRange.createFromVersionSpec((String)version);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Invalid version range specification for " + item.toString(), (Exception)((Object)e));
            }
            Artifact artifact = this.artifactFactory.createDependencyArtifact(item.getGroupId(), item.getArtifactId(), versionRange, "pom", null, null);
            ArtifactVersion newVer = this.findLatestVersion(artifact, versionRange, item.getAllowSnapshots());
            if (!this.shouldApplyUpdate(artifact, curVer, newVer)) continue;
            Stack<String> stack = new Stack<String>();
            String path = "";
            Pattern pathRegex = Pattern.compile("/project/properties(?:/profiles/profile)?/" + UpdatePropertiesMojo.quote(item.getProperty()));
            pom.rewind();
            while (pom.hasNext()) {
                event = pom.nextEvent();
                if (event.isStartElement()) {
                    stack.push(path);
                    path = path + "/" + event.asStartElement().getName().getLocalPart();
                    if (pathRegex.matcher(path).matches()) {
                        pom.mark(0);
                    }
                }
                if (!event.isEndElement()) continue;
                if (pathRegex.matcher(path).matches()) {
                    pom.mark(1);
                    if (pom.hasMark(0)) {
                        pom.replaceBetween(0, 1, newVer.toString());
                        this.getLog().info((CharSequence)("Updating " + itemCoords + " from version " + curVer + " to " + newVer));
                        pom.clearMark(0);
                        pom.clearMark(1);
                    }
                }
                path = (String)stack.pop();
            }
        }
    }
}

