/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tidy.task;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.mojo.tidy.task.Format;
import org.codehaus.mojo.tidy.task.TidyTask;
import org.codehaus.mojo.tidy.task.XMLEventReaderFactory;

class EnsureSingleLineProjectStartTag
implements TidyTask {
    private static final String PROJECT_START_TAG = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\">";

    EnsureSingleLineProjectStartTag() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String tidyPom(String pom, Format format) throws XMLStreamException {
        try (XMLEventReader eventReader = XMLEventReaderFactory.createEventReaderForPom(pom);){
            String string = this.tidyProjectStartTag(pom, eventReader);
            return string;
        }
    }

    private String tidyProjectStartTag(String pom, XMLEventReader eventReader) throws XMLStreamException {
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("project")) continue;
            return this.replaceProjectStartTag(pom, eventReader, event);
        }
        throw new IllegalArgumentException("The POM has no project node.");
    }

    private String replaceProjectStartTag(String pom, XMLEventReader eventReader, XMLEvent event) throws XMLStreamException {
        int start = event.getLocation().getCharacterOffset();
        int nextChar = eventReader.nextEvent().getLocation().getCharacterOffset();
        return pom.substring(0, start) + PROJECT_START_TAG + pom.substring(nextChar);
    }
}

