/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import [Ljava.lang.String;;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.rmic.AbstractRmiMojo;
import org.codehaus.mojo.rmic.RmiCompiler;
import org.codehaus.mojo.rmic.RmiCompilerException;
import org.codehaus.mojo.rmic.RmicConfig;

public class SunRmiCompiler
implements RmiCompiler {
    public static final String RMIC_CLASSNAME = "sun.rmi.rmic.Main";
    private static ClassLoaderFacade classLoaderFacade = new ClassLoaderFacadeImpl();
    private Log logger;

    static void setClassLoaderFacade(ClassLoaderFacade classLoaderFacade) {
        SunRmiCompiler.classLoaderFacade = classLoaderFacade;
    }

    public void execute(AbstractRmiMojo mojo, RmicConfig rmiConfig, List classesToCompile) throws RmiCompilerException {
        File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
        try {
            URL[] classpathUrls = new URL[]{toolsJar.toURI().toURL()};
            classLoaderFacade.prependUrls(classpathUrls);
        }
        catch (MalformedURLException e) {
            throw new RmiCompilerException("Unable to resolve tools.jar: " + toolsJar);
        }
        Class rmicMainClass = this.loadRmicClass();
        ArrayList<String> arguments = new ArrayList<String>();
        List classpathList = mojo.getRmicClasspathElements();
        if (classpathList.size() > 0) {
            arguments.add("-classpath");
            arguments.add(this.buildClasspath(classpathList));
        }
        arguments.add("-d");
        arguments.add(mojo.getOutputDirectory().getAbsolutePath());
        if (rmiConfig.getVersion() != null) {
            arguments.add("-v" + rmiConfig.getVersion());
        }
        if (rmiConfig.isIiop()) {
            arguments.add("-iiop");
            if (rmiConfig.isPoa()) {
                arguments.add("-poa");
            }
            if (rmiConfig.isNoLocalStubs()) {
                arguments.add("-nolocalstubs");
            }
        } else if (rmiConfig.isPoa()) {
            throw new RmiCompilerException("IIOP must be enabled in order to use the POA option");
        }
        if (rmiConfig.isIdl()) {
            arguments.add("-idl");
            if (rmiConfig.isNoValueMethods()) {
                arguments.add("-noValueMethods");
            }
        }
        if (rmiConfig.isKeep()) {
            arguments.add("-keep");
        }
        if (this.getLog().isDebugEnabled() || rmiConfig.isVerbose()) {
            arguments.add("-verbose");
        } else if (rmiConfig.isNowarn()) {
            arguments.add("-nowarn");
        }
        Iterator it = classesToCompile.iterator();
        while (it.hasNext()) {
            String remoteClass = (String)it.next();
            arguments.add(remoteClass);
        }
        String[] args = arguments.toArray(new String[arguments.size()]);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"rmic arguments: ");
            for (int i = 0; i < args.length; ++i) {
                this.getLog().debug((CharSequence)args[i]);
            }
        }
        this.executeMain(rmicMainClass, args);
    }

    private String buildClasspath(List classpathList) {
        StringBuffer classpath = new StringBuffer(classpathList.get(0).toString());
        for (int i = 1; i < classpathList.size(); ++i) {
            classpath.append(File.pathSeparator).append(classpathList.get(i));
        }
        return classpath.toString();
    }

    public void setLog(Log log) {
        this.logger = log;
    }

    public Log getLog() {
        return this.logger;
    }

    private Class loadRmicClass() throws RmiCompilerException {
        try {
            return classLoaderFacade.loadClass(RMIC_CLASSNAME);
        }
        catch (ClassNotFoundException e) {
            this.getLog().warn((CharSequence)"Could not find rmi compiler: sun.rmi.rmic.Main");
            this.getLog().info((CharSequence)"Within this classpath:");
            this.logClasspath(this.getLog(), classLoaderFacade.getUrls());
            throw new RmiCompilerException("Could not find sun.rmi.rmic.Main on the classpath.");
        }
    }

    private void logClasspath(Log logger, URL[] urls) {
        for (int it = 0; it < urls.length; ++it) {
            logger.info((CharSequence)(" * " + urls[it].toExternalForm()));
        }
    }

    private void executeMain(Class rmicMainClass, String[] args) throws RmiCompilerException {
        try {
            Constructor constructor = rmicMainClass.getConstructor(OutputStream.class, String.class);
            Object main = constructor.newInstance(System.out, "rmic");
            Method compile = rmicMainClass.getMethod("compile", String;.class);
            compile.invoke(main, new Object[]{args});
        }
        catch (Exception e) {
            throw new RmiCompilerException("Error while executing rmic.", e);
        }
    }

    static class ClassLoaderFacadeImpl
    implements ClassLoaderFacade {
        private URLClassLoader classLoader = null;

        ClassLoaderFacadeImpl() {
        }

        public Class loadClass(String classname) throws ClassNotFoundException {
            return this.classLoader.loadClass(classname);
        }

        public void prependUrls(URL[] classpathUrls) {
            this.classLoader = new URLClassLoader(classpathUrls, null);
        }

        public URL[] getUrls() {
            return this.classLoader.getURLs();
        }
    }

    static interface ClassLoaderFacade {
        public Class loadClass(String var1) throws ClassNotFoundException;

        public void prependUrls(URL[] var1);

        public URL[] getUrls();
    }
}

