/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pluginsupport.dependency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.pluginsupport.dependency.DependencyResolutionListener;
import org.codehaus.mojo.pluginsupport.dependency.DependencyTree;

public class Dependencies {
    private List projectDependencies;
    private DependencyResolutionListener resolvedDependencies;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Dependencies(MavenProject project, DependencyResolutionListener listener) {
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        this.projectDependencies = listener.getDependencyTree().getRootNode().getChildren();
        this.resolvedDependencies = listener;
        HashMap<String, Artifact> projectMap = new HashMap<String, Artifact>();
        Iterator iter = project.getArtifacts().iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            projectMap.put(ArtifactUtils.versionlessKey((Artifact)artifact), artifact);
        }
        this.mapArtifactFiles(listener.getDependencyTree().getRootNode(), projectMap);
    }

    private void mapArtifactFiles(DependencyTree.Node node, Map projectMap) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && projectMap == null) {
            throw new AssertionError();
        }
        List childs = node.getChildren();
        if (childs == null || childs.isEmpty()) {
            return;
        }
        Iterator iter = childs.iterator();
        while (iter.hasNext()) {
            DependencyTree.Node anode = (DependencyTree.Node)iter.next();
            String key = ArtifactUtils.versionlessKey((Artifact)anode.getArtifact());
            Artifact projartifact = (Artifact)projectMap.get(key);
            if (projartifact != null) {
                anode.getArtifact().setFile(projartifact.getFile());
            }
            this.mapArtifactFiles(anode, projectMap);
        }
    }

    public boolean hasDependencies() {
        return this.projectDependencies != null && !this.projectDependencies.isEmpty();
    }

    public List getProjectDependencies() {
        return new ArrayList(this.projectDependencies);
    }

    public List getTransitiveDependencies() {
        ArrayList deps = new ArrayList(this.resolvedDependencies.getArtifacts());
        deps.removeAll(this.projectDependencies);
        return deps;
    }

    public List getAllDependencies() {
        ArrayList<Artifact> deps = new ArrayList<Artifact>();
        Iterator iter = this.resolvedDependencies.getArtifacts().iterator();
        while (iter.hasNext()) {
            DependencyTree.Node node = (DependencyTree.Node)iter.next();
            Artifact artifact = node.getArtifact();
            deps.add(artifact);
        }
        return deps;
    }

    public Map getDependenciesByScope() {
        HashMap<String, ArrayList<Artifact>> dependenciesByScope = new HashMap<String, ArrayList<Artifact>>();
        Iterator i = this.getAllDependencies().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            ArrayList<Artifact> multiValue = (ArrayList<Artifact>)dependenciesByScope.get(artifact.getScope());
            if (multiValue == null) {
                multiValue = new ArrayList<Artifact>();
            }
            multiValue.add(artifact);
            dependenciesByScope.put(artifact.getScope(), multiValue);
        }
        return dependenciesByScope;
    }

    public DependencyTree.Node getResolvedRoot() {
        return this.resolvedDependencies.getDependencyTree().getRootNode();
    }

    static {
        $assertionsDisabled = !Dependencies.class.desiredAssertionStatus();
    }
}

