/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pluginsupport;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.pluginsupport.dependency.DependencyHelper;
import org.codehaus.mojo.pluginsupport.logging.DelegatingLog;
import org.codehaus.mojo.pluginsupport.logging.Logging;
import org.codehaus.mojo.pluginsupport.logging.MavenPluginLog;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class MojoSupport
extends AbstractMojo
implements Contextualizable {
    protected PlexusContainer container;
    protected Log log;
    private DependencyHelper dependencyHelper;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MojoSupport() {
        Logging.init();
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
        this.log = this.getLog();
        MavenPluginLog.setMojo((Mojo)this);
        DelegatingLog.setDelegateType(MavenPluginLog.class);
        try {
            this.dependencyHelper = (DependencyHelper)this.container.lookup(DependencyHelper.class.getName());
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Failed to lookup required components", (Exception)((Object)e));
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        try {
            this.doExecute();
        }
        catch (Exception e) {
            if (e instanceof MojoExecutionException) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            if (e instanceof MojoFailureException) {
                MojoFailureException x = new MojoFailureException(e.getMessage());
                x.initCause((Throwable)e);
                throw x;
            }
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            Logging.reset();
        }
    }

    protected void doExecute() throws Exception {
    }

    protected MavenProject getProject() {
        throw new Error("Sub-class must override to provide access to : " + MavenProject.class);
    }

    protected ArtifactRepository getArtifactRepository() {
        throw new Error("Sub-class must override to provide access to: " + ArtifactRepository.class);
    }

    protected final ArtifactFactory getArtifactFactory() {
        return this.dependencyHelper.getArtifactFactory();
    }

    protected final ArtifactResolver getArtifactResolver() {
        return this.dependencyHelper.getArtifactResolver();
    }

    protected Artifact createArtifact(ArtifactItem item) throws MojoExecutionException {
        VersionRange range;
        if (!$assertionsDisabled && item == null) {
            throw new AssertionError();
        }
        if (item.getVersion() == null) {
            this.fillMissingArtifactVersion(item);
            if (item.getVersion() == null) {
                throw new MojoExecutionException("Unable to find artifact version of " + item.getGroupId() + ":" + item.getArtifactId() + " in either dependency list or in project's dependency management.");
            }
        }
        try {
            range = VersionRange.createFromVersionSpec((String)item.getVersion());
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Using version range: " + range));
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Could not create range for version: " + item.getVersion(), (Exception)((Object)e));
        }
        return this.getArtifactFactory().createDependencyArtifact(item.getGroupId(), item.getArtifactId(), range, item.getType(), item.getClassifier(), "provided");
    }

    protected Artifact getArtifact(ArtifactItem item) throws MojoExecutionException {
        if (!$assertionsDisabled && item == null) {
            throw new AssertionError();
        }
        Artifact artifact = this.createArtifact(item);
        return this.resolveArtifact(artifact);
    }

    protected Artifact resolveArtifact(Artifact artifact, boolean transitive) throws MojoExecutionException {
        if (!$assertionsDisabled && artifact == null) {
            throw new AssertionError();
        }
        try {
            if (transitive) {
                this.getArtifactResolver().resolveTransitively(Collections.singleton(artifact), this.getProject().getArtifact(), this.getProject().getRemoteArtifactRepositories(), this.getArtifactRepository(), this.dependencyHelper.getArtifactMetadataSource());
            } else {
                this.getArtifactResolver().resolve(artifact, this.getProject().getRemoteArtifactRepositories(), this.getArtifactRepository());
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    protected Artifact resolveArtifact(Artifact artifact) throws MojoExecutionException {
        return this.resolveArtifact(artifact, false);
    }

    private void fillMissingArtifactVersion(ArtifactItem item) {
        Dependency dependency;
        int i;
        this.log.debug((CharSequence)("Attempting to find missing version in " + item.getGroupId() + ":" + item.getArtifactId()));
        List list = this.getProject().getDependencies();
        for (i = 0; i < list.size(); ++i) {
            dependency = (Dependency)list.get(i);
            if (!dependency.getGroupId().equals(item.getGroupId()) || !dependency.getArtifactId().equals(item.getArtifactId()) || !dependency.getType().equals(item.getType())) continue;
            this.log.debug((CharSequence)("Found missing version: " + dependency.getVersion() + " in dependency list."));
            item.setVersion(dependency.getVersion());
            return;
        }
        list = this.getProject().getDependencyManagement().getDependencies();
        for (i = 0; i < list.size(); ++i) {
            dependency = (Dependency)list.get(i);
            if (!dependency.getGroupId().equals(item.getGroupId()) || !dependency.getArtifactId().equals(item.getArtifactId()) || !dependency.getType().equals(item.getType())) continue;
            this.log.debug((CharSequence)("Found missing version: " + dependency.getVersion() + " in dependency management list"));
            item.setVersion(dependency.getVersion());
        }
    }

    protected Set getProjectArtifacts(MavenProject project, boolean resolve) throws MojoExecutionException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Iterator dependencies = project.getDependencies().iterator();
        while (dependencies.hasNext()) {
            Dependency dep = (Dependency)dependencies.next();
            String groupId = dep.getGroupId();
            String artifactId = dep.getArtifactId();
            VersionRange versionRange = VersionRange.createFromVersion((String)dep.getVersion());
            String type = dep.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dep.getClassifier();
            boolean optional = dep.isOptional();
            String scope = dep.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact artifact = this.getArtifactFactory().createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
            if (scope.equalsIgnoreCase("system")) {
                artifact.setFile(new File(dep.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            Iterator j = dep.getExclusions().iterator();
            while (j.hasNext()) {
                Exclusion e = (Exclusion)j.next();
                exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            artifact.setDependencyFilter((ArtifactFilter)newFilter);
            if (resolve && !artifact.isResolved()) {
                this.log.debug((CharSequence)("Resolving artifact: " + artifact));
                artifact = this.resolveArtifact(artifact);
            }
            artifacts.add(artifact);
        }
        return artifacts;
    }

    protected Set getProjectArtifacts(boolean resolve) throws MojoExecutionException {
        return this.getProjectArtifacts(this.getProject(), resolve);
    }

    protected Set getProjectArtifacts() throws MojoExecutionException {
        return this.getProjectArtifacts(false);
    }

    static {
        $assertionsDisabled = !MojoSupport.class.desiredAssertionStatus();
    }
}

