/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.NativeSources;
import org.codehaus.mojo.natives.compiler.Compiler;
import org.codehaus.mojo.natives.compiler.CompilerConfiguration;
import org.codehaus.mojo.natives.manager.CompilerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE)
public class NativeCompileMojo
extends AbstractNativeMojo {
    @Parameter(defaultValue="generic", required=true)
    private String compilerProvider;
    @Parameter
    private String objectFileExtension;
    @Parameter
    private String compilerExecutable;
    @Parameter
    private List<String> compilerStartOptions;
    @Parameter
    private List<String> compilerMiddleOptions;
    @Parameter
    private List<String> compilerEndOptions;
    @Parameter
    private String javahOS;
    @Parameter(defaultValue="${java.home}/../include")
    private File jdkIncludePath;
    @Parameter
    protected NativeSources[] sources = new NativeSources[0];
    @Parameter(defaultValue="${project.build.directory}/objs", required=true)
    protected File compilerOutputDirectory;
    @Parameter(defaultValue="1")
    protected int numberOfConcurrentCompilation;
    @Component
    private CompilerManager manager;
    private CompilerConfiguration config;

    public void execute() throws MojoExecutionException {
        List objectFiles;
        Compiler compiler;
        try {
            compiler = this.manager.getCompiler(this.compilerProvider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        if (this.javahOS != null) {
            this.addJavaHIncludePaths();
        }
        this.addAdditionalIncludePath();
        CompilerConfiguration config = this.createProviderConfiguration();
        try {
            objectFiles = compiler.compile(config, NativeSources.getAllSourceFiles((NativeSources[])this.sources));
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.saveCompilerOutputFilePaths(objectFiles);
    }

    private void addJavaHIncludePaths() {
        ArrayList<NativeSources> sourceArray = new ArrayList<NativeSources>(Arrays.asList(this.sources));
        NativeSources jdkIncludeSource = new NativeSources();
        jdkIncludeSource.setDirectory(this.jdkIncludePath);
        jdkIncludeSource.setDependencyAnalysisParticipation(false);
        sourceArray.add(jdkIncludeSource);
        File jdkOsIncludeDir = new File(this.jdkIncludePath, this.javahOS);
        NativeSources jdkIncludeOsSource = new NativeSources();
        jdkIncludeOsSource.setDirectory(jdkOsIncludeDir);
        jdkIncludeOsSource.setDependencyAnalysisParticipation(false);
        sourceArray.add(jdkIncludeOsSource);
        this.sources = sourceArray.toArray(new NativeSources[sourceArray.size()]);
    }

    private void addAdditionalIncludePath() {
        boolean includeDependencyFound;
        List additionalIncludePaths = this.project.getCompileSourceRoots();
        boolean bl = includeDependencyFound = this.getPluginContext().get("IncZipFound") != null;
        if (!(includeDependencyFound || additionalIncludePaths != null && additionalIncludePaths.size() >= 2)) {
            return;
        }
        if (this.sources == null) {
            return;
        }
        ArrayList<NativeSources> sourceArray = new ArrayList<NativeSources>(Arrays.asList(this.sources));
        if (additionalIncludePaths.size() > 1) {
            for (int i = 1; i < additionalIncludePaths.size(); ++i) {
                File genIncludeDir = new File(additionalIncludePaths.get(i).toString());
                NativeSources genIncludeSource = new NativeSources();
                genIncludeSource.setDirectory(genIncludeDir);
                sourceArray.add(genIncludeSource);
            }
        }
        if (includeDependencyFound) {
            NativeSources dependencyIncludeSource = new NativeSources();
            dependencyIncludeSource.setDependencyAnalysisParticipation(false);
            dependencyIncludeSource.setDirectory(this.dependencyIncludeDirectory);
            sourceArray.add(dependencyIncludeSource);
        }
        this.sources = sourceArray.toArray(new NativeSources[sourceArray.size()]);
    }

    protected CompilerConfiguration createProviderConfiguration() throws MojoExecutionException {
        this.config = new CompilerConfiguration();
        this.config.setWorkingDirectory(this.workingDirectory);
        this.config.setExecutable(this.compilerExecutable);
        this.config.setStartOptions(NativeCompileMojo.removeEmptyOptions(this.compilerStartOptions));
        this.config.setMiddleOptions(NativeCompileMojo.removeEmptyOptions(this.compilerMiddleOptions));
        this.config.setEndOptions(NativeCompileMojo.removeEmptyOptions(this.compilerEndOptions));
        this.config.setIncludePaths(NativeSources.getIncludePaths((NativeSources[])this.sources));
        this.config.setSystemIncludePaths(NativeSources.getSystemIncludePaths((NativeSources[])this.sources));
        this.config.setOutputDirectory(this.compilerOutputDirectory);
        this.config.setObjectFileExtension(this.objectFileExtension);
        this.config.setEnvFactory(this.getEnvFactory());
        this.config.setNumberOfConcurrentCompilation(this.numberOfConcurrentCompilation);
        return this.config;
    }

    protected CompilerConfiguration getCompilerConfiguration() {
        return this.config;
    }
}

