/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;

public class ProxyArtifactStore
extends BaseArtifactStore {
    private final RepositoryMetadataManager repositoryMetadataManager;
    private final List<ArtifactRepository> remotePluginRepositories;
    private final ArtifactRepository localRepository;
    private final ArtifactFactory artifactFactory;
    private final List<ArtifactRepository> remoteRepositories;
    private final ArtifactResolver artifactResolver;
    private final ArchetypeManager archetypeManager;
    private final Log log;
    private final VersionRange anyVersion;
    private final Map<String, Map<String, Artifact>> children = new HashMap<String, Map<String, Artifact>>();

    public ProxyArtifactStore(RepositoryMetadataManager repositoryMetadataManager, List<ArtifactRepository> remoteArtifactRepositories, List<ArtifactRepository> remotePluginRepositories, ArtifactRepository localRepository, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArchetypeManager archetypeManager, Log log) {
        this.repositoryMetadataManager = repositoryMetadataManager;
        this.remotePluginRepositories = remotePluginRepositories;
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
        this.artifactResolver = artifactResolver;
        this.archetypeManager = archetypeManager;
        this.log = log;
        this.remoteRepositories = new ArrayList<ArtifactRepository>();
        this.remoteRepositories.addAll(remoteArtifactRepositories);
        this.remoteRepositories.addAll(remotePluginRepositories);
        try {
            this.anyVersion = VersionRange.createFromVersionSpec((String)"[0,]");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalStateException("[0,] should always be a valid version specification", e);
        }
    }

    private synchronized void addResolved(Artifact artifact) {
        String path = artifact.getGroupId().replace('.', '/') + '/' + artifact.getArtifactId() + "/" + artifact.getVersion();
        Map artifactMapper = this.children.computeIfAbsent(path, k -> new HashMap());
        artifactMapper.put(artifact.getName(), artifact);
        this.addResolved(path);
    }

    private synchronized void addResolved(String path) {
        int index = path.lastIndexOf(47);
        while (index > 0) {
            String name = path.substring(index + 1);
            path = path.substring(0, index);
            Map artifactMapper = this.children.computeIfAbsent(path, k -> new HashMap());
            artifactMapper.put(name, null);
            index = path.lastIndexOf(47);
        }
        if (!StringUtils.isEmpty((String)path)) {
            Map artifactMapper = this.children.computeIfAbsent("", k -> new HashMap());
            artifactMapper.put(path, null);
        }
    }

    public synchronized Set<String> getGroupIds(String parentGroupId) {
        String path = parentGroupId.replace('.', '/');
        Map<String, Artifact> artifactMapper = this.children.get(path);
        if (artifactMapper == null) {
            return Collections.emptySet();
        }
        return artifactMapper.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public synchronized Set<String> getArtifactIds(String groupId) {
        String path = groupId.replace('.', '/');
        Map<String, Artifact> artifactMapper = this.children.get(path);
        if (artifactMapper == null) {
            return Collections.emptySet();
        }
        return artifactMapper.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public synchronized Set<String> getVersions(String groupId, String artifactId) {
        String path = groupId.replace('.', '/') + '/' + artifactId;
        Map<String, Artifact> artifactMapper = this.children.get(path);
        if (artifactMapper == null) {
            return Collections.emptySet();
        }
        return artifactMapper.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public synchronized Set<Artifact> getArtifacts(String groupId, String artifactId, String version) {
        String path = groupId.replace('.', '/') + '/' + artifactId + "/" + version;
        Map<String, Artifact> artifactMapper = this.children.get(path);
        if (artifactMapper == null) {
            return Collections.emptySet();
        }
        return artifactMapper.values().stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        org.apache.maven.artifact.Artifact mavenArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getTimestampVersion(), artifact.getType(), artifact.getClassifier());
        try {
            this.artifactResolver.resolve(mavenArtifact, this.remoteRepositories, this.localRepository);
            File file = mavenArtifact.getFile();
            if (file != null && file.isFile()) {
                this.addResolved(artifact);
                return file.lastModified();
            }
            throw new ArtifactNotFoundException(artifact);
        }
        catch (org.apache.maven.artifact.resolver.ArtifactNotFoundException e) {
            throw new ArtifactNotFoundException(artifact, (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        org.apache.maven.artifact.Artifact mavenArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getTimestampVersion(), artifact.getType(), artifact.getClassifier());
        try {
            this.artifactResolver.resolve(mavenArtifact, this.remoteRepositories, this.localRepository);
            File file = mavenArtifact.getFile();
            if (file != null && file.isFile()) {
                this.addResolved(artifact);
                return file.length();
            }
            throw new ArtifactNotFoundException(artifact);
        }
        catch (org.apache.maven.artifact.resolver.ArtifactNotFoundException e) {
            throw new ArtifactNotFoundException(artifact, (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        org.apache.maven.artifact.Artifact mavenArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getTimestampVersion(), artifact.getType(), artifact.getClassifier());
        try {
            this.artifactResolver.resolve(mavenArtifact, this.remoteRepositories, this.localRepository);
            File file = mavenArtifact.getFile();
            if (file != null && file.isFile()) {
                this.addResolved(artifact);
                return new FileInputStream(file);
            }
            throw new ArtifactNotFoundException(artifact);
        }
        catch (org.apache.maven.artifact.resolver.ArtifactNotFoundException e) {
            throw new ArtifactNotFoundException(artifact, (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void set(Artifact artifact, InputStream content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        Metadata artifactMetadata;
        Object artifactRepositoryMetadata;
        org.apache.maven.artifact.Artifact artifact;
        int index = (path = StringUtils.strip((String)path, (String)"/")).lastIndexOf(47);
        int index2 = index == -1 ? -1 : path.lastIndexOf(47, index - 1);
        String version = index2 == -1 ? null : path.substring(index + 1);
        String artifactId = index2 == -1 ? null : path.substring(index2 + 1, index);
        String groupId = index2 == -1 ? null : path.substring(0, index2).replace('/', '.');
        Metadata metadata = new Metadata();
        boolean foundSomething = false;
        if (version != null && version.endsWith("-SNAPSHOT") && !StringUtils.isEmpty((String)artifactId) && !StringUtils.isEmpty((String)groupId)) {
            artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "pom", null, "compile");
            artifactRepositoryMetadata = new SnapshotArtifactRepositoryMetadata(artifact);
            try {
                this.repositoryMetadataManager.resolve((RepositoryMetadata)artifactRepositoryMetadata, this.remoteRepositories, this.localRepository);
                artifactMetadata = artifactRepositoryMetadata.getMetadata();
                if (artifactMetadata.getVersioning() != null && artifactMetadata.getVersioning().getSnapshot() != null) {
                    foundSomething = true;
                    metadata.setGroupId(groupId);
                    metadata.setArtifactId(artifactId);
                    metadata.setVersion(version);
                    metadata.merge(artifactMetadata);
                }
                try {
                    if (artifactMetadata.getVersioning() != null && !artifactMetadata.getVersioning().getSnapshotVersions().isEmpty()) {
                        for (Object v : artifactMetadata.getVersioning().getSnapshotVersions()) {
                            metadata.getVersioning().addSnapshotVersion(v);
                            if (!v.getVersion().endsWith("-SNAPSHOT")) continue;
                            this.addResolved(new Artifact(groupId, artifactId, version, v.getClassifier(), v.getExtension()));
                        }
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
            }
            catch (RepositoryMetadataResolutionException e) {
                this.log.debug((Throwable)e);
            }
        }
        artifactId = index == -1 ? null : path.substring(index + 1);
        String string = groupId = index == -1 ? null : path.substring(0, index).replace('/', '.');
        if (!StringUtils.isEmpty((String)artifactId) && !StringUtils.isEmpty((String)groupId)) {
            artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, this.anyVersion, "pom", null, "compile");
            artifactRepositoryMetadata = new ArtifactRepositoryMetadata(artifact);
            try {
                this.repositoryMetadataManager.resolve((RepositoryMetadata)artifactRepositoryMetadata, this.remoteRepositories, this.localRepository);
                artifactMetadata = artifactRepositoryMetadata.getMetadata();
                if (artifactMetadata.getVersioning() != null) {
                    foundSomething = true;
                    if (StringUtils.isEmpty((String)metadata.getGroupId())) {
                        metadata.setGroupId(groupId);
                        metadata.setArtifactId(artifactId);
                    }
                    metadata.merge(artifactMetadata);
                    for (Object v : artifactMetadata.getVersioning().getVersions()) {
                        this.addResolved(path + "/" + (String)v);
                    }
                }
            }
            catch (RepositoryMetadataResolutionException e) {
                this.log.debug((Throwable)e);
            }
        }
        groupId = path.replace('/', '.');
        GroupRepositoryMetadata groupRepositoryMetadata = new GroupRepositoryMetadata(groupId);
        try {
            this.repositoryMetadataManager.resolve((RepositoryMetadata)groupRepositoryMetadata, this.remotePluginRepositories, this.localRepository);
            foundSomething = true;
            metadata.merge(groupRepositoryMetadata.getMetadata());
            for (Plugin plugin : groupRepositoryMetadata.getMetadata().getPlugins()) {
                this.addResolved(path + "/" + plugin.getArtifactId());
            }
        }
        catch (RepositoryMetadataResolutionException e) {
            this.log.debug((Throwable)e);
        }
        if (!foundSomething) {
            throw new MetadataNotFoundException(path);
        }
        this.addResolved(path);
        return metadata;
    }

    public long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        Metadata metadata = this.getMetadata(path);
        if (!(metadata == null || StringUtils.isEmpty((String)metadata.getGroupId()) && StringUtils.isEmpty((String)metadata.getArtifactId()) && StringUtils.isEmpty((String)metadata.getVersion()) && (metadata.getPlugins() == null || metadata.getPlugins().isEmpty()) && (metadata.getVersioning() == null || StringUtils.isEmpty((String)metadata.getVersioning().getLastUpdated()) && StringUtils.isEmpty((String)metadata.getVersioning().getLatest()) && StringUtils.isEmpty((String)metadata.getVersioning().getRelease()) && (metadata.getVersioning().getVersions() == null || metadata.getVersioning().getVersions().isEmpty()) && metadata.getVersioning().getSnapshot() == null))) {
            return System.currentTimeMillis();
        }
        throw new MetadataNotFoundException(path);
    }

    public ArchetypeCatalog getArchetypeCatalog() throws IOException, ArchetypeCatalogNotFoundException {
        return this.archetypeManager.getDefaultLocalCatalog();
    }

    public long getArchetypeCatalogLastModified() throws IOException, ArchetypeCatalogNotFoundException {
        if (this.archetypeManager.getDefaultLocalCatalog() != null) {
            return System.currentTimeMillis();
        }
        throw new ArchetypeCatalogNotFoundException();
    }
}

