/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.minijar.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.vafer.dependency.resources.ResourceHandler;
import org.vafer.dependency.resources.Version;
import org.vafer.dependency.utils.Jar;

public final class LicenseHandler
implements ResourceHandler {
    private File licensesFile;
    private FileOutputStream licensesOutputStream;

    public void onStartProcessing(JarOutputStream pOutput) throws IOException {
    }

    public void onStartJar(Jar pJar, JarOutputStream pOutput) throws IOException {
    }

    public InputStream onResource(Jar jar, String oldName, String newName, Version[] versions, InputStream inputStream) throws IOException {
        String s = oldName.toLowerCase();
        if ("meta-inf/license.txt".equals(s) || "meta-inf/license".equals(s) || "meta-inf/notice.txt".equals(s) || "meta-inf/notice".equals(s)) {
            System.out.println(this + " found resource " + oldName);
            if (this.licensesFile == null) {
                this.licensesFile = File.createTempFile("minijar", "license");
                this.licensesFile.deleteOnExit();
            }
            if (this.licensesOutputStream == null) {
                this.licensesOutputStream = new FileOutputStream(this.licensesFile);
            }
            return new FilterInputStream(inputStream){

                public int read() throws IOException {
                    int r = super.read();
                    if (r > 0) {
                        LicenseHandler.this.licensesOutputStream.write(r);
                    }
                    return r;
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    int r = super.read(b, off, len);
                    if (r > 0) {
                        LicenseHandler.this.licensesOutputStream.write(b, off, r);
                    }
                    return r;
                }

                public int read(byte[] b) throws IOException {
                    int r = super.read(b);
                    if (r > 0) {
                        LicenseHandler.this.licensesOutputStream.write(b, 0, r);
                    }
                    return r;
                }
            };
        }
        return inputStream;
    }

    public void onStopJar(Jar pJar, JarOutputStream pOutput) throws IOException {
    }

    public void onStopProcessing(JarOutputStream pOutput) throws IOException {
        if (this.licensesOutputStream == null) {
            return;
        }
        IOUtils.closeQuietly((OutputStream)this.licensesOutputStream);
        FileInputStream licensesInputStream = new FileInputStream(this.licensesFile);
        pOutput.putNextEntry(new JarEntry("LICENSE.txt"));
        IOUtils.copy((InputStream)licensesInputStream, (OutputStream)pOutput);
        IOUtils.closeQuietly((InputStream)licensesInputStream);
    }
}

