/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.make;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:make-maven-plugin:1.0-beta-1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Makefile Orchestration Plugin", 0);
        this.append(sb, "These plugins are designed to convert tarballs of typical non-java open source project and with patch/autoconf/configure/make/install prepare a directory for packaging with RPM. Stuffing a java project into an RPM is also supported.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 12 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "autoreconf".equals(this.goal)) {
            this.append(sb, "make:autoreconf", 0);
            this.append(sb, "Execute autoreconf with command line arguments.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDir (Default: ${project.build.directory})", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "chmod".equals(this.goal)) {
            this.append(sb, "make:chmod", 0);
            this.append(sb, "Change the file/directory mode on a list of files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "chmodPaths", 2);
                this.append(sb, "The list of paths to chmod.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mode (Default: +x)", 2);
                this.append(sb, "The chmod mode to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "recursive (Default: false)", 2);
                this.append(sb, "Whether to execute recursively, as in the case where directories are being targeted.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "chown".equals(this.goal)) {
            this.append(sb, "make:chown", 0);
            this.append(sb, "Change the ownership on a set of paths. Assumes you have sudo installed and configured.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "chownPaths", 2);
                this.append(sb, "The list of paths to chown.", 3);
                this.append(sb, "", 0);
                this.append(sb, "group", 2);
                this.append(sb, "The group to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "recursive (Default: false)", 2);
                this.append(sb, "Whether to execute recursively, as in the case where directories are being targeted.", 3);
                this.append(sb, "", 0);
                this.append(sb, "user (Default: ${user.name})", 2);
                this.append(sb, "The user to use.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile".equals(this.goal)) {
            this.append(sb, "make:compile", 0);
            this.append(sb, "Execute a Make-ish compile target to generate binaries from the project source.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "absoluteCommandPathUsed (Default: false)", 2);
                this.append(sb, "Behavior to take command and use explicit pathing instead of using the shell's path", 3);
                this.append(sb, "", 0);
                this.append(sb, "absoluteCompileCommand (Default: false)", 2);
                this.append(sb, "Whether to use an absolute path for the compile command or not. If the compile command's file is not found in the workDir, this is a moot point.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodCompileCommand", 2);
                this.append(sb, "Whether to set the Executable bit for the compile command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodUsed (Default: false)", 2);
                this.append(sb, "Configures the goal to change the make command to executable prior to invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "command (Default: make)", 2);
                this.append(sb, "The shell command to execute. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compileCheckFile", 2);
                this.append(sb, "A check file that will be monitored to verify modification before allowing the compile execution to succeed. If empty, this option is not used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compileCommand", 2);
                this.append(sb, "The actual shell command to run in order to compile the sources; defaults to 'make'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compileEnvironment", 2);
                this.append(sb, "Environment variables that should be present in the compile command's shell. Any '@pathOf(groupId:artifactId)@' references will be resolved before the command is executed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compileOptions", 2);
                this.append(sb, "The list of command-line arguments to supply for the command invocation. No expressions are currently allowed here, beyond those resolved inside the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compileTarget", 2);
                this.append(sb, "The Make target to execute. In many cases, this doesn't have to be supplied, since the default target commonly compiles the code.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "The classic autoconf/make DESTDIR parameter which tells make to stage the installation to a temp directory prior to packaging (allows for package building without root access). DESTDIR is called a staged installation by the GNU coding standards", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "make-maven-plugin will define environment variables prior to execution of the commands that it dispatches", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreErrors (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore errors returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore failures returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "makeCompileWorkDir", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "The command-line arguments to include in the command invocation. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveOptions (Default: true)", 2);
                this.append(sb, "resolveOptions is a setting to control if you want the make-maven-plugin to resolve @pathOf(..)@ expressions or not", 3);
                this.append(sb, "", 0);
                this.append(sb, "searchForExecutable (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipCompile (Default: false)", 2);
                this.append(sb, "Whether we should skip the Make compile step for this project. This is merely a short-circuit mechanism, since this mojo will be included in a standard lifecycle mapping.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipped (Default: false)", 2);
                this.append(sb, "If set, the goal will be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDir (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "configure".equals(this.goal)) {
            this.append(sb, "make:configure", 0);
            this.append(sb, "Execute the configure (or similar) script to prepare the project directory for Make execution (or similar).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "absoluteCommandPathUsed (Default: false)", 2);
                this.append(sb, "Behavior to take command and use explicit pathing instead of using the shell's path", 3);
                this.append(sb, "", 0);
                this.append(sb, "absoluteConfigureCommand (Default: false)", 2);
                this.append(sb, "Whether the configure command should be referenced as an absolute path or not. Default is false.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodConfigureCommand (Default: true)", 2);
                this.append(sb, "Whether to set the Executable bit for the configure script on the filesystem.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodUsed (Default: false)", 2);
                this.append(sb, "Configures the goal to change the make command to executable prior to invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "command (Default: make)", 2);
                this.append(sb, "The shell command to execute. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configureCheckFile", 2);
                this.append(sb, "This is a file location checked before and after the configure execution, if specified. If the file is not touched during configuration, this mojo will fail.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configureCommand (Default: ./configure)", 2);
                this.append(sb, "The command path. The default is './configure' in the work directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configureEnvironment", 2);
                this.append(sb, "These are environment variables you want added to the configure command's execution shell. They will be resolved in the same manner as configureOptions, where '@pathOf(groupId:artifactId)@' is resolved to the prefix of that dependency.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configureOptions", 2);
                this.append(sb, "The list of command-line arguments to the configuration script. An example might be:\n'--with-ssl=\npath/to/openssl'\nNOTE: The expressions '@destDir@' and '@pathOf(groupId:artifactId)@' are available for use here. The first will substitute the value of the destDir parameter (described below) in place of the token, and the second will substitute the systemPath of the dependency referenced by groupId:artifactId for the expression. For example:\n\n'--ssldir=@destDir@' '--with-ssl=@pathOf(org.openssl:openssl)@'\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "configureWorkDir", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "The classic autoconf/make DESTDIR parameter which tells make to stage the installation to a temp directory prior to packaging (allows for package building without root access). DESTDIR is called a staged installation by the GNU coding standards", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "make-maven-plugin will define environment variables prior to execution of the commands that it dispatches", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreErrors (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore errors returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore failures returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "The command-line arguments to include in the command invocation. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "The configure prefix, to let the RPM harvester know how to build the dir structure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefixOption (Default: --prefix)", 2);
                this.append(sb, "The prefix option. The default is '--prefix'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveOptions (Default: true)", 2);
                this.append(sb, "resolveOptions is a setting to control if you want the make-maven-plugin to resolve @pathOf(..)@ expressions or not", 3);
                this.append(sb, "", 0);
                this.append(sb, "searchForConfigureCommand (Default: true)", 2);
                this.append(sb, "Whether the workDir and other locations should be searched for the configure executable.", 3);
                this.append(sb, "", 0);
                this.append(sb, "searchForExecutable (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipConfigure (Default: false)", 2);
                this.append(sb, "Whether we should skip the configuration step of the Make process for this project. This is merely a short-circuit mechanism, since this mojo will be included in a standard lifecycle mapping.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipped (Default: false)", 2);
                this.append(sb, "If set, the goal will be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDir (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "make:help", 0);
            this.append(sb, "Display help information on make-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0make:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "make-clean".equals(this.goal)) {
            this.append(sb, "make:make-clean", 0);
            this.append(sb, "Remove from source directory all files generated during the make process.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "absoluteCommandPathUsed (Default: false)", 2);
                this.append(sb, "Behavior to take command and use explicit pathing instead of using the shell's path", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodUsed (Default: false)", 2);
                this.append(sb, "Configures the goal to change the make command to executable prior to invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanBinaries (Default: true)", 2);
                this.append(sb, "Whether we should remove the program binaries and object files from the source code directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanConfig (Default: false)", 2);
                this.append(sb, "Whether we should remove the files that the configuration process generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "command (Default: make)", 2);
                this.append(sb, "The shell command to execute. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "The classic autoconf/make DESTDIR parameter which tells make to stage the installation to a temp directory prior to packaging (allows for package building without root access). DESTDIR is called a staged installation by the GNU coding standards", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "make-maven-plugin will define environment variables prior to execution of the commands that it dispatches", 3);
                this.append(sb, "", 0);
                this.append(sb, "filesets", 2);
                this.append(sb, "The list of filesets to delete, in addition to the default directories.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreErrors (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore errors returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore failures returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "makeWorkDir", 2);
                this.append(sb, "The temporary working directory where the project is actually built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "The command-line arguments to include in the command invocation. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveOptions (Default: true)", 2);
                this.append(sb, "resolveOptions is a setting to control if you want the make-maven-plugin to resolve @pathOf(..)@ expressions or not", 3);
                this.append(sb, "", 0);
                this.append(sb, "searchForExecutable (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipped (Default: false)", 2);
                this.append(sb, "If set, the goal will be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Be verbose in the debug log-level?", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDir (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "make-dist".equals(this.goal)) {
            this.append(sb, "make:make-dist", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "absoluteCommandPathUsed (Default: false)", 2);
                this.append(sb, "Behavior to take command and use explicit pathing instead of using the shell's path", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodUsed (Default: false)", 2);
                this.append(sb, "Configures the goal to change the make command to executable prior to invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "command (Default: make)", 2);
                this.append(sb, "The shell command to execute. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "The classic autoconf/make DESTDIR parameter which tells make to stage the installation to a temp directory prior to packaging (allows for package building without root access). DESTDIR is called a staged installation by the GNU coding standards", 3);
                this.append(sb, "", 0);
                this.append(sb, "distCommand (Default: make)", 2);
                this.append(sb, "The command to execute the 'make' program.", 3);
                this.append(sb, "", 0);
                this.append(sb, "distOptions", 2);
                this.append(sb, "Commandline options for the execution of make.", 3);
                this.append(sb, "", 0);
                this.append(sb, "distTarget (Default: dist)", 2);
                this.append(sb, "The make target to execute.", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "make-maven-plugin will define environment variables prior to execution of the commands that it dispatches", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreErrors (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore errors returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore failures returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "The command-line arguments to include in the command invocation. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveOptions (Default: true)", 2);
                this.append(sb, "resolveOptions is a setting to control if you want the make-maven-plugin to resolve @pathOf(..)@ expressions or not", 3);
                this.append(sb, "", 0);
                this.append(sb, "searchForExecutable (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipDist (Default: true)", 2);
                this.append(sb, "Set this parameter to skip calling 'make dist' which will create a release tarball", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipped (Default: false)", 2);
                this.append(sb, "If set, the goal will be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArchive (Default: ${project.artifactId}-${project.version}.tar.gz)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceArchivePath (Default: ${basedir}/src/main/project)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDir (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "make-install".equals(this.goal)) {
            this.append(sb, "make:make-install", 0);
            this.append(sb, "Execute a Make-ish install target to assemble the compiled binaries into a temporary destination directory (work dir) for harvesting by a packager of some sort (like RPM).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "absoluteCommandPathUsed (Default: false)", 2);
                this.append(sb, "Behavior to take command and use explicit pathing instead of using the shell's path", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodInstallCommand", 2);
                this.append(sb, "Whether to set the Executable bit for the install command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodUsed (Default: false)", 2);
                this.append(sb, "Configures the goal to change the make command to executable prior to invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "command (Default: make)", 2);
                this.append(sb, "The shell command to execute. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "The classic autoconf/make DESTDIR parameter which tells make to stage the installation to a temp directory prior to packaging (allows for package building without root access). DESTDIR is called a staged installation by the GNU coding standards", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "make-maven-plugin will define environment variables prior to execution of the commands that it dispatches", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreErrors (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore errors returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore failures returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "installCheckFile", 2);
                this.append(sb, "An optional check file to monitor before and after the installation process. If this file is specified and is not changed during installation to the work directory, the mojo fails.", 3);
                this.append(sb, "", 0);
                this.append(sb, "installCommand", 2);
                this.append(sb, "Shell command used to install the project binaries into the work directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "installEnvironment", 2);
                this.append(sb, "Shell environment variables used in the install command invocation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "installOptions", 2);
                this.append(sb, "Command-line options used in the install command invocation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "installTarget", 2);
                this.append(sb, "The Make target which should be executed; default is 'install'", 3);
                this.append(sb, "", 0);
                this.append(sb, "makeInstallWorkDir", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "The command-line arguments to include in the command invocation. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveOptions (Default: true)", 2);
                this.append(sb, "resolveOptions is a setting to control if you want the make-maven-plugin to resolve @pathOf(..)@ expressions or not", 3);
                this.append(sb, "", 0);
                this.append(sb, "searchForExecutable (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipInstall (Default: false)", 2);
                this.append(sb, "Whether we should skip the install target of the Make process for this project. This is merely a short-circuit mechanism, since this mojo will be included in a standard lifecycle mapping.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipped (Default: false)", 2);
                this.append(sb, "If set, the goal will be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDir (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test".equals(this.goal)) {
            this.append(sb, "make:test", 0);
            this.append(sb, "Execute a Make (or similar) target to test the compiled binary.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "absoluteCommandPathUsed (Default: false)", 2);
                this.append(sb, "Behavior to take command and use explicit pathing instead of using the shell's path", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodTestCommand", 2);
                this.append(sb, "Whether to set the Executable bit for the test command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodUsed (Default: false)", 2);
                this.append(sb, "Configures the goal to change the make command to executable prior to invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "command (Default: make)", 2);
                this.append(sb, "The shell command to execute. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "The classic autoconf/make DESTDIR parameter which tells make to stage the installation to a temp directory prior to packaging (allows for package building without root access). DESTDIR is called a staged installation by the GNU coding standards", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "make-maven-plugin will define environment variables prior to execution of the commands that it dispatches", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreErrors (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore errors returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore failures returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreTestFailures", 2);
                this.append(sb, "Whether we should prevent the test mojo from failing if there are test failures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "makeTestWorkDir", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "The command-line arguments to include in the command invocation. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveOptions (Default: true)", 2);
                this.append(sb, "resolveOptions is a setting to control if you want the make-maven-plugin to resolve @pathOf(..)@ expressions or not", 3);
                this.append(sb, "", 0);
                this.append(sb, "searchForExecutable (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipped (Default: false)", 2);
                this.append(sb, "If set, the goal will be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipTest (Default: false)", 2);
                this.append(sb, "Whether we should skip testing this project. This is merely a short-circuit mechanism, since this mojo will be included in a standard lifecycle mapping.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testCheckFile", 2);
                this.append(sb, "A file which should be modified during the tests...if this is set and not updated, the mojo will fail.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testCommand", 2);
                this.append(sb, "The command we should invoke to run the tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testOptions", 2);
                this.append(sb, "Command-line options for use in the test command invocation. No expressions are currently supported here, other than those resolved inside the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testTarget", 2);
                this.append(sb, "The Make test target to execute.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDir (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "unpack".equals(this.goal)) {
            this.append(sb, "make:unpack", 0);
            this.append(sb, "Unpack a tar (or similar) target to unpack the distrution artifact. Goal exists only because of plexus bugs while handling tarballs. If plexus tar UnArchiver gets fixed, maven-dependency-plugin should be used instead.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "absoluteCommandPathUsed (Default: false)", 2);
                this.append(sb, "Behavior to take command and use explicit pathing instead of using the shell's path", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodUsed (Default: false)", 2);
                this.append(sb, "Configures the goal to change the make command to executable prior to invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "command (Default: make)", 2);
                this.append(sb, "The shell command to execute. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "The classic autoconf/make DESTDIR parameter which tells make to stage the installation to a temp directory prior to packaging (allows for package building without root access). DESTDIR is called a staged installation by the GNU coding standards", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "make-maven-plugin will define environment variables prior to execution of the commands that it dispatches", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreErrors (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore errors returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "Configures the goal to ignore failures returned by the make command invocation", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "The command-line arguments to include in the command invocation. NOTE: This is NOT a direct parameter. We need to allow the concrete implementations to specify their own params for this, so that we can allow all mojos to be configured from the same section of the plugin declaration without worrying about naming collisions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveOptions (Default: true)", 2);
                this.append(sb, "resolveOptions is a setting to control if you want the make-maven-plugin to resolve @pathOf(..)@ expressions or not", 3);
                this.append(sb, "", 0);
                this.append(sb, "searchForExecutable (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipped (Default: false)", 2);
                this.append(sb, "If set, the goal will be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipUnpack (Default: false)", 2);
                this.append(sb, "Whether we should skip unpacking this project. This is merely a short-circuit mechanism, in case this mojo will be included in a standard lifecycle mapping.", 3);
                this.append(sb, "", 0);
                this.append(sb, "unpackCommand (Default: tar)", 2);
                this.append(sb, "The command we should invoke to do the unpack", 3);
                this.append(sb, "", 0);
                this.append(sb, "unpackOptions", 2);
                this.append(sb, "Command-line options for use in the unpack command invocation. If no values are passed in and the plugin recognizes the archive type, it will put in the normal options for tar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "unpackTarget", 2);
                this.append(sb, "The Make test target to execute.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDir (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "The temporary working directory where the project is actually built. By default, this is within the '/target' directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "validate-pom".equals(this.goal)) {
            this.append(sb, "make:validate-pom", 0);
            this.append(sb, "Validate that the required project property prefix is available in the current project before allowing it to continue. This property is required to allow @pathOf(..)@ style references work, as in the make plugin's mojos.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

