/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.autotools;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.Shell;

public class AutoreconfExecMojo
extends AbstractMojo {
    private String command = "autoreconf";
    private File executable;
    private List<String> arguments;
    private Properties environment;
    private File workDir;
    private CommandLineManager cliManager;

    public void execute() throws MojoExecutionException {
        this.workDir.mkdirs();
        Commandline exec = new Commandline();
        exec.setShell((Shell)new BourneShell(true));
        exec.setWorkingDirectory(this.workDir.getAbsolutePath());
        if (this.executable != null) {
            exec.setExecutable(this.executable.getPath());
        } else {
            exec.setExecutable(this.command);
        }
        if (this.arguments != null) {
            for (String string : this.arguments) {
                exec.createArg().setLine(string);
            }
        }
        if (this.environment != null && !this.environment.isEmpty()) {
            for (Map.Entry entry : this.environment.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                exec.addEnvironment(key, val);
                this.getLog().info((CharSequence)("Setting envar: " + key + "=" + val));
            }
        }
        try {
            StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
            int n = this.cliManager.execute(exec, consumer, consumer);
            if (n != 0) {
                throw new MojoExecutionException(this.command + " command returned an exit value != 0. Aborting build; see debug output for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to execute autoreconf. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

