/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static void renameFile(File file, File destination) throws IOException {
        try {
            try {
                FileUtils.forceDelete((File)destination);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            FileUtils.moveFile((File)file, (File)destination);
        }
        catch (IOException ex) {
            throw new IOException(String.format("could not rename '%s' to '%s'", file, destination));
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
        FileUtils.copyFile((File)source, (File)target);
    }

    public static File getBackupFile(File file) {
        return new File(file.getAbsolutePath() + "~");
    }

    public static void backupFile(File f) throws IOException {
        File dst = FileUtil.getBackupFile(f);
        FileUtil.copyFile(f, dst);
    }

    public static void printString(File file, String content, String encoding) throws IOException {
        Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        try (BufferedReader in = new BufferedReader(new StringReader(content));
             PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding)));){
            String line;
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
        }
    }

    public static List<File> orderFiles(Collection<File> files) {
        ArrayList<File> result = new ArrayList<File>(files);
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        return result;
    }

    public static String sha1(Path in) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return Hex.encodeHexString((byte[])md.digest(Files.readAllBytes(in)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toExtension(String mimeType, boolean throwDefault) {
        if (mimeType == null) {
            if (throwDefault) {
                throw new IllegalStateException("Unexpected null mime type");
            }
            return null;
        }
        String lowerMimeType = mimeType.toLowerCase(Locale.ROOT);
        if (lowerMimeType.contains("plain") || "text/x-c".equals(lowerMimeType)) {
            return ".txt";
        }
        if (lowerMimeType.contains("html")) {
            return ".html";
        }
        if (lowerMimeType.contains("pdf")) {
            return ".pdf";
        }
        if (throwDefault) {
            throw new IllegalStateException("Unexpected mime type '" + mimeType + "'");
        }
        return null;
    }
}

