/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.model;

import java.util.Calendar;
import java.util.Date;

public class Copyright {
    protected static final String DEFAULT_COPYRIGHT_TO_STRING_FORMAT = "Copyright (C) %1$s %2$s";
    protected String copyrightToStringFormat;
    protected String holder;
    protected int firstYear;
    protected Integer lastYear;

    public static Copyright newCopyright(String copyrightToStringFormat, Integer inceptionYear, Integer lastYear, String holder) {
        int firstYear = inceptionYear == null ? lastYear : inceptionYear;
        if (lastYear == null || firstYear >= lastYear) {
            lastYear = null;
        }
        if (copyrightToStringFormat == null) {
            return Copyright.newCopyright(DEFAULT_COPYRIGHT_TO_STRING_FORMAT, firstYear, lastYear, holder);
        }
        Copyright result = new Copyright(copyrightToStringFormat, firstYear, lastYear, holder);
        return result;
    }

    public static Copyright newCopyright(Integer inceptionYear, Integer lastYear, String holder) {
        return Copyright.newCopyright(DEFAULT_COPYRIGHT_TO_STRING_FORMAT, inceptionYear, lastYear, holder);
    }

    public static Copyright newCopyright(String copyrightToStringFormat, Integer inceptionYear, String holder) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Integer lastYear = cal.get(1);
        return Copyright.newCopyright(copyrightToStringFormat, inceptionYear, lastYear, holder);
    }

    public static Copyright newCopyright(Integer inceptionYear, String holder) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Integer lastYear = cal.get(1);
        return Copyright.newCopyright(inceptionYear, lastYear, holder);
    }

    public Copyright() {
    }

    public Copyright(Copyright copyright) {
        this(copyright.getCopyrightToStringFormat(), copyright.getFirstYear(), copyright.getLastYear(), copyright.getHolder());
    }

    public Copyright(String copyrightToStringFormat, int firstYear, Integer lastYear, String holder) {
        this.copyrightToStringFormat = copyrightToStringFormat;
        this.firstYear = firstYear;
        this.lastYear = lastYear;
        this.holder = holder;
    }

    public String getCopyrightToStringFormat() {
        return this.copyrightToStringFormat;
    }

    public String getHolder() {
        return this.holder;
    }

    public Integer getFirstYear() {
        return this.firstYear;
    }

    public Integer getLastYear() {
        return this.lastYear;
    }

    public String getYears() {
        String years = this.getLastYear() == null ? String.valueOf(this.getFirstYear()) : this.getFirstYear() + " - " + this.getLastYear();
        return years;
    }

    public String getText() {
        String copyright = String.format(this.getCopyrightToStringFormat(), this.getYears(), this.getHolder());
        return copyright;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Copyright)) {
            return false;
        }
        Copyright copyright = (Copyright)o;
        if (this.firstYear != copyright.firstYear) {
            return false;
        }
        if (this.holder != null ? !this.holder.equals(copyright.holder) : copyright.holder != null) {
            return false;
        }
        return !(this.lastYear != null ? !this.lastYear.equals(copyright.lastYear) : copyright.lastYear != null);
    }

    public int hashCode() {
        int result = this.holder != null ? this.holder.hashCode() : 0;
        result = 31 * result + this.firstYear;
        result = 31 * result + (this.lastYear != null ? this.lastYear.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getText();
    }
}

