/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.license.AbstractLicenseReportRenderer;
import org.codehaus.mojo.license.api.ThirdPartyDetails;
import org.codehaus.plexus.i18n.I18N;

public class ThirdPartyReportRenderer
extends AbstractLicenseReportRenderer {
    private final Collection<ThirdPartyDetails> details;

    public ThirdPartyReportRenderer(Sink sink, I18N i18n, String outputName, Locale locale, Collection<ThirdPartyDetails> details) {
        super(sink, outputName, i18n, locale);
        this.details = details;
    }

    protected Collection<ThirdPartyDetails> getThirdPartiesPomLicense() {
        ArrayList<ThirdPartyDetails> result = new ArrayList<ThirdPartyDetails>();
        for (ThirdPartyDetails detail : this.details) {
            if (!detail.hasPomLicenses()) continue;
            result.add(detail);
        }
        return result;
    }

    protected Collection<ThirdPartyDetails> getThirdPartiesThirdPartyLicense() {
        ArrayList<ThirdPartyDetails> result = new ArrayList<ThirdPartyDetails>();
        for (ThirdPartyDetails detail : this.details) {
            if (!detail.hasThirdPartyLicenses()) continue;
            result.add(detail);
        }
        return result;
    }

    protected Collection<ThirdPartyDetails> getThirdPartiesNoLicense() {
        ArrayList<ThirdPartyDetails> result = new ArrayList<ThirdPartyDetails>();
        for (ThirdPartyDetails detail : this.details) {
            if (detail.hasLicenses()) continue;
            result.add(detail);
        }
        return result;
    }

    protected void renderBody() {
        this.startSection(this.getText("report.overview.title"));
        this.paragraph(this.getText("report.overview.text"));
        this.renderSummaryTotalsTable(this.details);
        this.renderSummaryTable(this.details);
        this.endSection();
        Collection<ThirdPartyDetails> dependencies = this.getThirdPartiesNoLicense();
        this.startSection(this.getText("report.detail.title.noLicense"));
        this.sink.paragraph();
        this.sink.text(this.getText("report.detail.text.noLicense"));
        if (CollectionUtils.isEmpty(dependencies)) {
            this.sink.lineBreak();
            this.sink.text(this.getText("report.detail.text.emptyList"));
        }
        this.sink.paragraph_();
        for (ThirdPartyDetails detail : dependencies) {
            this.renderThirdPartyDetail(detail);
        }
        this.endSection();
        dependencies = this.getThirdPartiesThirdPartyLicense();
        this.startSection(this.getText("report.detail.title.thirdPartyLicense"));
        this.sink.paragraph();
        this.sink.text(this.getText("report.detail.text.thirdPartyLicense"));
        if (CollectionUtils.isEmpty(dependencies)) {
            this.sink.lineBreak();
            this.sink.text(this.getText("report.detail.text.emptyList"));
        }
        this.sink.paragraph_();
        for (ThirdPartyDetails detail : dependencies) {
            this.renderThirdPartyDetail(detail);
        }
        this.endSection();
        dependencies = this.getThirdPartiesPomLicense();
        this.startSection(this.getText("report.detail.title.pomLicense"));
        this.sink.paragraph();
        this.sink.text(this.getText("report.detail.text.pomLicense"));
        if (CollectionUtils.isEmpty(dependencies)) {
            this.sink.lineBreak();
            this.sink.text(this.getText("report.detail.text.emptyList"));
        }
        this.sink.paragraph_();
        for (ThirdPartyDetails detail : dependencies) {
            this.renderThirdPartyDetail(detail);
        }
        this.endSection();
    }

    private void renderSummaryTotalsTable(Collection<ThirdPartyDetails> allThirdParties) {
        int numWithPomLicense = 0;
        int numWithThirdPartyLicense = 0;
        int numWithNoLicense = 0;
        for (ThirdPartyDetails detail : allThirdParties) {
            if (detail.hasPomLicenses()) {
                ++numWithPomLicense;
                continue;
            }
            if (detail.hasThirdPartyLicenses()) {
                ++numWithThirdPartyLicense;
                continue;
            }
            ++numWithNoLicense;
        }
        this.startTable();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderInfoIcon();
        this.sink.tableCell_();
        this.tableCell(this.getText("report.overview.numThirdParties"));
        this.tableCell(Integer.toString(allThirdParties.size()));
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderSuccessIcon();
        this.sink.tableCell_();
        this.tableCell(this.getText("report.overview.numWithPomLicenses"));
        this.tableCell(Integer.toString(numWithPomLicense));
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.tableCell(this.getText("report.overview.numWithThirdPartyLicenses"));
        this.tableCell(Integer.toString(numWithThirdPartyLicense));
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderErrorIcon();
        this.sink.tableCell_();
        this.tableCell(this.getText("report.overview.numWithNoLicense"));
        this.tableCell(Integer.toString(numWithNoLicense));
        this.sink.tableRow_();
        this.endTable();
    }

    private void renderSummaryTable(Collection<ThirdPartyDetails> contents) {
        this.startSection(this.getText("report.overview.thirdParty"));
        if (contents.isEmpty()) {
            this.paragraph(this.getText("report.overview.nothirdParty"));
        } else {
            this.renderThirdPartySummaryTable(contents);
        }
        this.endSection();
    }

    private void renderThirdPartyDetail(ThirdPartyDetails detail) {
        this.startSection(this.getGAV(detail));
        this.renderThirdPartyDetailTable(detail);
        this.sink.link("#" + this.getText("report.overview.title"));
        this.sink.text(this.getText("report.back.to.top.page"));
        this.sink.link_();
        this.sink.lineBreak();
        this.endSection();
    }
}

