/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.environment.logging;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.shared.Validate;

public class MavenLogHandler
extends Handler {
    private Log log;
    private String prefix;

    public MavenLogHandler(Log log, String prefix, String encoding, String[] acceptedLogRecordPrefixes) {
        Validate.notNull(log, "log");
        Validate.notNull(prefix, "prefix");
        Validate.notEmpty(encoding, "encoding");
        this.log = log;
        this.prefix = prefix.isEmpty() ? "" : "[" + prefix + "]: ";
        this.setFormatter(new SimpleFormatter());
        this.setLevel(MavenLogHandler.getJavaUtilLoggingLevelFor(log));
        try {
            this.setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error((CharSequence)("Could not use encoding '" + encoding + "'"), (Throwable)e);
        }
        if (acceptedLogRecordPrefixes != null && acceptedLogRecordPrefixes.length > 0) {
            this.setFilter(MavenLogHandler.getLoggingFilter(acceptedLogRecordPrefixes));
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            Level level = logRecord.getLevel();
            String message = this.prefix + this.getFormatter().format(logRecord);
            if (Level.SEVERE.equals(level)) {
                this.log.error((CharSequence)message);
            } else if (Level.WARNING.equals(level)) {
                this.log.warn((CharSequence)message);
            } else if (Level.INFO.equals(level)) {
                this.log.info((CharSequence)message);
            } else {
                this.log.debug((CharSequence)message);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public static Level getJavaUtilLoggingLevelFor(Log mavenLog) {
        Validate.notNull(mavenLog, "mavenLog");
        Level toReturn = Level.SEVERE;
        if (mavenLog.isDebugEnabled()) {
            toReturn = Level.FINER;
        } else if (mavenLog.isInfoEnabled()) {
            toReturn = Level.INFO;
        } else if (mavenLog.isWarnEnabled()) {
            toReturn = Level.WARNING;
        }
        return toReturn;
    }

    public static Filter getLoggingFilter(final String ... requiredPrefixes) {
        Validate.notNull(requiredPrefixes, "requiredPrefixes");
        return new Filter(){
            private List<String> requiredPrefs;
            {
                this.requiredPrefs = Arrays.asList(requiredPrefixes);
            }

            @Override
            public boolean isLoggable(LogRecord record) {
                String loggerName = record.getLoggerName();
                for (String current : this.requiredPrefs) {
                    if (!loggerName.startsWith(current)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

