/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.javageneration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.javageneration.AbstractJavaGeneratorMojo;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;
import org.codehaus.mojo.jaxb2.shared.filters.Filters;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.PatternFileFilter;

@Mojo(name="testXjc", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=false)
public class TestXjcMojo
extends AbstractJavaGeneratorMojo {
    public static final String STALE_FILENAME = "testXjcStaleFlag";
    public static final String STANDARD_TEST_SOURCE_DIRECTORY = "src/test/xsd";
    public static final List<Filter<File>> STANDARD_TEST_SOURCE_EXCLUDE_FILTERS;
    public static final String STANDARD_TEST_XJB_DIRECTORY = "src/test/xjb";
    public static final List<Filter<File>> STANDARD_TEST_XJB_EXCLUDE_FILTERS;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/jaxb", required=true)
    private File outputDirectory;
    @Parameter(required=false)
    private List<String> testSources;
    @Parameter(required=false)
    private List<String> testXjbSources;
    @Parameter(required=false)
    private List<Filter<File>> testSourceExcludeFilters;
    @Parameter(required=false)
    private List<Filter<File>> testXjbExcludeFilters;
    @Parameter(property="xjc.test.skip", defaultValue="false")
    private boolean skipTestXjc;

    @Override
    protected boolean shouldExecutionBeSkipped() {
        return this.skipTestXjc;
    }

    @Override
    protected List<URL> getSources() {
        List<Filter<File>> excludePatterns = this.testSourceExcludeFilters == null ? STANDARD_TEST_SOURCE_EXCLUDE_FILTERS : this.testSourceExcludeFilters;
        Filters.initialize(this.getLog(), excludePatterns);
        return FileSystemUtilities.filterFiles(this.getProject().getBasedir(), this.testSources, Arrays.asList(STANDARD_TEST_SOURCE_DIRECTORY), this.getLog(), "testSources", excludePatterns);
    }

    @Override
    protected List<File> getSourceXJBs() {
        List<Filter<File>> excludePatterns = this.testXjbExcludeFilters == null ? STANDARD_TEST_XJB_EXCLUDE_FILTERS : this.testXjbExcludeFilters;
        Filters.initialize(this.getLog(), excludePatterns);
        return FileSystemUtilities.filterFiles(this.getProject().getBasedir(), this.testXjbSources, STANDARD_TEST_XJB_DIRECTORY, this.getLog(), "testXjbSources", excludePatterns);
    }

    @Override
    protected String getStaleFileName() {
        return STALE_FILENAME;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected List<String> getClasspath() throws MojoExecutionException {
        try {
            return this.getProject().getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not retrieve Compile classpath.", (Exception)((Object)e));
        }
    }

    @Override
    protected void addGeneratedSourcesToProjectSourceRoot(String canonicalPathToOutputDirectory) {
        this.getProject().addTestCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
    }

    @Override
    protected void addResource(Resource resource) {
        this.getProject().addTestResource(resource);
    }

    static {
        ArrayList<Filter<File>> xjbTemp = new ArrayList<Filter<File>>();
        xjbTemp.addAll(AbstractJaxbMojo.STANDARD_EXCLUDE_FILTERS);
        xjbTemp.add(new PatternFileFilter(Arrays.asList("\\.xsd"), true));
        STANDARD_TEST_XJB_EXCLUDE_FILTERS = Collections.unmodifiableList(xjbTemp);
        ArrayList<Filter<File>> xsdTemp = new ArrayList<Filter<File>>();
        xsdTemp.addAll(AbstractJaxbMojo.STANDARD_EXCLUDE_FILTERS);
        xsdTemp.add(new PatternFileFilter(Arrays.asList("\\.xjb"), true));
        STANDARD_TEST_SOURCE_EXCLUDE_FILTERS = Collections.unmodifiableList(xsdTemp);
    }
}

