/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse.runner;

import fitnesse.components.FitProtocol;
import fitnesse.util.StreamReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.fitnesse.ClassPathSubstitution;

public class ClassPathBuilder {
    private String mHostName;
    private int mPort;
    private String mPage;
    private Log mLog;

    ClassPathBuilder() {
    }

    ClassPathBuilder(Log pLog) {
        this.mLog = pLog;
    }

    public ClassPathBuilder(String hostName, int port, String page, Log pLog) {
        this.mHostName = hostName;
        this.mPort = port;
        this.mPage = page;
        this.mLog = pLog;
    }

    public String getPath(List pSubstitutions, Log pLog) throws MojoExecutionException {
        String tUrl = "GET /" + this.mPage + "?responder=fitClient&includePaths=yes HTTP/1.1\r\n\r\n";
        pLog.debug((CharSequence)("Use URL for classPath download [" + tUrl + "]"));
        try {
            StreamReader tSocketReader = this.establishConnection(tUrl);
            int tNbBytes = FitProtocol.readSize((StreamReader)tSocketReader);
            if (tNbBytes != 0) {
                throw new MojoExecutionException("Unable to connect to server.");
            }
            tNbBytes = FitProtocol.readSize((StreamReader)tSocketReader);
            String tOriginalPath = FitProtocol.readDocument((StreamReader)tSocketReader, (int)tNbBytes);
            pLog.debug((CharSequence)("Download classpath is [" + tOriginalPath + "]"));
            String tPath = this.transformPath(tOriginalPath, pSubstitutions);
            pLog.info((CharSequence)("Use path [" + tPath + "]"));
            return tPath;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to download path from FitNesse Server", e);
        }
    }

    private StreamReader establishConnection(String pUrl) throws UnknownHostException, IOException {
        Socket socket = new Socket(this.mHostName, this.mPort);
        OutputStream socketOutput = socket.getOutputStream();
        StreamReader socketReader = new StreamReader(socket.getInputStream());
        byte[] tBytes = pUrl.getBytes("UTF-8");
        socketOutput.write(tBytes);
        socketOutput.flush();
        return socketReader;
    }

    String transformPath(String pOriginalPath, List pSubstitutions) {
        String curPath = pOriginalPath;
        Iterator tIt = pSubstitutions.iterator();
        while (tIt.hasNext()) {
            ClassPathSubstitution curSub = (ClassPathSubstitution)tIt.next();
            this.mLog.debug((CharSequence)("use subtitution [" + curSub.getSearch() + "=" + curSub.getReplaceWith()));
            curPath = this.replaceAll(curPath, curSub.getSearch(), curSub.getReplaceWith());
        }
        curPath = curPath.replaceAll(" +\";", "\";");
        curPath = curPath.replaceAll(";\" +", ";\"");
        curPath = curPath.replaceAll("\"", "");
        return curPath;
    }

    String replaceAll(String pPath, String pKey, String pValue) {
        StringBuffer tempNewPath = new StringBuffer();
        int curStart = 0;
        int curEnd = pPath.indexOf(pKey);
        while (curEnd != -1) {
            tempNewPath.append(pPath.substring(curStart, curEnd));
            tempNewPath.append(pValue);
            curStart = curEnd + pKey.length();
            curEnd = pPath.indexOf(pKey, curStart);
        }
        tempNewPath.append(pPath.substring(curStart, pPath.length()));
        return tempNewPath.toString();
    }
}

