/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse.plexus;

import java.io.InputStream;
import org.codehaus.mojo.fitnesse.plexus.FCommandLineException;
import org.codehaus.mojo.fitnesse.plexus.FCommandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamFeeder;
import org.codehaus.plexus.util.cli.StreamPumper;

public abstract class FCommandLineUtils {
    public static int executeCommandLine(FCommandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws FCommandLineException {
        return FCommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommandLine(FCommandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws FCommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        Process p = null;
        p = cl.execute();
        KillerThread tKiller = new KillerThread(p);
        Runtime.getRuntime().addShutdownHook(tKiller);
        StreamFeeder inputFeeder = null;
        if (systemIn != null) {
            inputFeeder = new StreamFeeder(systemIn, p.getOutputStream());
        }
        StreamPumper outputPumper = new StreamPumper(p.getInputStream(), systemOut);
        StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), systemErr);
        if (inputFeeder != null) {
            inputFeeder.start();
        }
        outputPumper.start();
        errorPumper.start();
        try {
            StreamFeeder streamFeeder;
            int returnValue = p.waitFor();
            if (inputFeeder != null) {
                streamFeeder = inputFeeder;
                synchronized (streamFeeder) {
                    if (!inputFeeder.isDone()) {
                        inputFeeder.wait();
                    }
                }
            }
            if (outputPumper != null) {
                streamFeeder = outputPumper;
                synchronized (streamFeeder) {
                    if (!outputPumper.isDone()) {
                        outputPumper.wait();
                    }
                }
            }
            if (errorPumper != null) {
                streamFeeder = errorPumper;
                synchronized (streamFeeder) {
                    if (!errorPumper.isDone()) {
                        errorPumper.wait();
                    }
                }
            }
            Runtime.getRuntime().removeShutdownHook(tKiller);
            int n = returnValue;
            return n;
        }
        catch (InterruptedException ex) {
            throw new FCommandLineException("Error while executing external command.", ex);
        }
        finally {
            if (inputFeeder != null) {
                inputFeeder.close();
            }
            outputPumper.close();
            errorPumper.close();
        }
    }

    public static class KillerThread
    extends Thread {
        Process mProcessToKill;

        public KillerThread(Process pProcess) {
            this.mProcessToKill = pProcess;
        }

        public void run() {
            super.run();
            if (this.mProcessToKill != null) {
                System.err.println("Sub process has been closed by destroy()");
                System.err.flush();
                this.mProcessToKill.destroy();
            } else {
                System.err.println("Should kill Sub process but was null");
                System.err.flush();
            }
        }
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        public void consumeLine(String line) {
            this.string.append(line + this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

