/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.cassandra.CqlExecutionException;
import org.codehaus.mojo.cassandra.CqlOperation;
import org.codehaus.mojo.cassandra.MavenLogOutputStream;
import org.codehaus.plexus.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public final class Utils {
    private Utils() {
        throw new IllegalAccessError("Utility class");
    }

    static void stopCassandraServer(String rpcAddress, int nativeTransportPort, String stopAddress, int stopPort, String stopKey, Log log) {
        try {
            Socket s = new Socket(InetAddress.getByName(stopAddress), stopPort);
            s.setSoLinger(false, 0);
            OutputStream out = s.getOutputStream();
            out.write((stopKey + "\r\nstop\r\n").getBytes());
            out.flush();
            s.close();
        }
        catch (ConnectException e) {
            log.info((CharSequence)"Cassandra not running!");
            return;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return;
        }
        long maxWaiting = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        boolean stopped = false;
        while (!stopped && System.currentTimeMillis() < maxWaiting) {
            try {
                CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(rpcAddress, nativeTransportPort))).withLocalDatacenter("datacenter1")).build();
                try {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                finally {
                    if (cqlSession == null) continue;
                    cqlSession.close();
                }
            }
            catch (AllNodesFailedException | DriverTimeoutException e) {
                stopped = true;
            }
            catch (DriverException e) {
                log.debug((CharSequence)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (stopped) {
            log.info((CharSequence)"Cassandra has stopped.");
        } else {
            log.warn((CharSequence)"Gave up waiting for Cassandra to stop.");
        }
    }

    protected static DefaultExecuteResultHandler startCassandraServer(File cassandraDir, CommandLine commandLine, Map environment, Log log) throws MojoExecutionException {
        try {
            DefaultExecutor exec = new DefaultExecutor();
            DefaultExecuteResultHandler execHandler = new DefaultExecuteResultHandler();
            exec.setWorkingDirectory(cassandraDir);
            exec.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
            MavenLogOutputStream stdout = new MavenLogOutputStream(log);
            MavenLogOutputStream stderr = new MavenLogOutputStream(log);
            log.debug((CharSequence)("Executing command line: " + commandLine));
            exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)stdout), (OutputStream)((Object)stderr)));
            exec.execute(commandLine, environment, (ExecuteResultHandler)execHandler);
            return execHandler;
        }
        catch (ExecuteException e) {
            throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Command execution failed.", (Exception)e);
        }
    }

    static boolean shouldGenerateResource(MavenProject project, File resource) {
        if (!resource.isFile()) {
            return true;
        }
        long resourceLM = resource.lastModified();
        long projectLM = project.getFile().lastModified();
        if (Long.signum(resourceLM) == Long.signum(projectLM)) {
            return resourceLM < projectLM;
        }
        return true;
    }

    public static String merge(String baseYaml, String glossYaml) {
        if (StringUtils.isBlank((String)glossYaml)) {
            return baseYaml;
        }
        if (StringUtils.isBlank((String)baseYaml)) {
            return glossYaml;
        }
        Yaml yaml = new Yaml();
        Map baseMap = (Map)yaml.load(baseYaml);
        Map glossMap = (Map)yaml.load(glossYaml);
        for (Map.Entry glossEntry : glossMap.entrySet()) {
            baseMap.put((String)glossEntry.getKey(), glossEntry.getValue());
        }
        return yaml.dump((Object)baseMap);
    }

    static boolean waitUntilStarted(String rpcAddress, int nativeTransportPort, int startWaitSeconds, Log log) throws MojoExecutionException {
        long maxWaiting = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(startWaitSeconds);
        while (startWaitSeconds == 0 || System.currentTimeMillis() < maxWaiting) {
            boolean bl;
            block14: {
                CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(rpcAddress, nativeTransportPort))).withLocalDatacenter("datacenter1")).build();
                try {
                    log.info((CharSequence)("Cassandra cluster \"" + cqlSession.getMetadata().getClusterName() + "\" started."));
                    bl = true;
                    if (cqlSession == null) break block14;
                }
                catch (Exception e) {
                    try {
                        try {
                            throw new MojoExecutionException(e.getLocalizedMessage(), e);
                        }
                        catch (Throwable throwable) {
                            if (cqlSession != null) {
                                try {
                                    cqlSession.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (AllNodesFailedException | DriverTimeoutException e2) {
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (DriverException e3) {
                        log.debug((CharSequence)e3.getLocalizedMessage(), (Throwable)e3);
                    }
                }
                cqlSession.close();
            }
            return bl;
        }
        return false;
    }

    public static void executeCql(CqlOperation cqlOperation) throws MojoExecutionException {
        CqlSessionBuilder cqlSessionBuilder = (CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(cqlOperation.getRpcAddress(), cqlOperation.getNativeTransportPort()))).withLocalDatacenter("datacenter1");
        if (StringUtils.isNotBlank((String)cqlOperation.getKeyspace())) {
            cqlSessionBuilder.withKeyspace(cqlOperation.getKeyspace());
        }
        try (CqlSession cqlSession = (CqlSession)cqlSessionBuilder.build();){
            cqlOperation.executeOperation(cqlSession);
        }
        catch (CqlExecutionException e) {
            throw new MojoExecutionException("API Exception calling Apache Cassandra", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Something went wrong cleaning up", e);
        }
    }
}

