/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import com.datastax.oss.driver.api.core.cql.Row;
import java.io.File;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.cassandra.AbstractCqlExecMojo;

@Mojo(name="cql-exec", threadSafe=true, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class CqlExecCassandraMojo
extends AbstractCqlExecMojo {
    @Parameter(property="cassandra.cql.script", defaultValue="${basedir}/src/cassandra/cql/exec.cql")
    protected File cqlScript;
    @Parameter(property="cql.statement")
    protected String cqlStatement;
    @Parameter(property="cql.defaultValidator")
    protected String defaultValidator = "BytesType";
    @Parameter(property="cql.keyValidator")
    protected String keyValidator = "BytesType";
    @Parameter(property="cql.comparator")
    protected String comparator = "BytesType";
    private AbstractType<?> comparatorVal;
    private AbstractType<?> keyValidatorVal;
    private AbstractType<?> defaultValidatorVal;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        try {
            this.comparatorVal = TypeParser.parse((String)this.comparator);
            this.keyValidatorVal = TypeParser.parse((String)this.keyValidator);
            this.defaultValidatorVal = TypeParser.parse((String)this.defaultValidator);
        }
        catch (ConfigurationException | SyntaxException e) {
            throw new MojoExecutionException("Could not parse comparator value: " + this.comparator, (Exception)e);
        }
        if (this.cqlScript != null && this.cqlScript.isFile()) {
            this.cqlStatement = this.readFile(this.cqlScript);
        }
        this.printResults(this.executeCql(this.cqlStatement));
    }

    private void printResults(List<Row> results) {
        this.getLog().info((CharSequence)"-----------------------------------------------");
        for (Row result : results) {
            this.printRow(result);
        }
    }

    private void printRow(Row row) {
        this.getLog().info((CharSequence)"-----------------------------------------------");
        this.getLog().info((CharSequence)row.getFormattedContents());
        this.getLog().info((CharSequence)"-----------------------------------------------");
    }
}

