/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan;

import java.util.Collections;
import java.util.List;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.mojo.buildplan.NoMojoExecution;
import org.codehaus.mojo.buildplan.util.LinkedMultimap;
import org.codehaus.mojo.buildplan.util.Multimap;
import org.codehaus.mojo.buildplan.util.Objects;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;

public class Groups {

    public static class Options {
        private final DefaultLifecycles defaultLifecycles;
        private String phase;
        private boolean showingAllPhases;
        private boolean showingLifecycles;

        public Options(DefaultLifecycles defaultLifecycles) {
            this.defaultLifecycles = defaultLifecycles;
        }

        public Options forPhase(String phase) {
            this.phase = phase;
            return this;
        }

        public Options showingAllPhases() {
            this.showingAllPhases = true;
            return this;
        }

        public Options showingLifecycles() {
            this.showingLifecycles = true;
            return this;
        }
    }

    public static class ByPhase {
        public static Multimap<String, MojoExecution> of(List<MojoExecution> plan) {
            return ByPhase.of(plan, new Options(ByPhase.defaultLifecycles()));
        }

        public static Multimap<String, MojoExecution> of(List<MojoExecution> executions, String phaseFilter) {
            return ByPhase.of(executions, new Options(ByPhase.defaultLifecycles()).forPhase(phaseFilter));
        }

        public static Multimap<String, MojoExecution> of(List<MojoExecution> executions, Options options) {
            LinkedMultimap<String, MojoExecution> result = new LinkedMultimap<String, MojoExecution>();
            boolean notFiltering = StringUtils.isEmpty((String)options.phase);
            for (MojoExecution execution : executions) {
                Lifecycle lifecycle;
                String phase = Objects.firstNonNull(execution.getLifecyclePhase(), "<no phase>");
                if (options.showingAllPhases && (lifecycle = options.defaultLifecycles.get(phase)) != null) {
                    lifecycle.getPhases().forEach(defaultPhase -> result.put((String)defaultPhase, NoMojoExecution.INSTANCE));
                }
                if (!notFiltering && !phase.equalsIgnoreCase(options.phase)) continue;
                result.put(phase, execution);
            }
            return result;
        }

        private static DefaultLifecycles defaultLifecycles() {
            return new DefaultLifecycles(Collections.emptyMap(), (Logger)new ConsoleLogger());
        }
    }

    public static class ByPlugin {
        public static Multimap<String, MojoExecution> of(List<MojoExecution> executions) {
            return ByPlugin.of(executions, null);
        }

        public static Multimap<String, MojoExecution> of(List<MojoExecution> executions, String artifactIdFilter) {
            LinkedMultimap<String, MojoExecution> result = new LinkedMultimap<String, MojoExecution>();
            boolean notFiltering = StringUtils.isEmpty((String)artifactIdFilter);
            for (MojoExecution execution : executions) {
                if (!notFiltering && !execution.getArtifactId().equalsIgnoreCase(artifactIdFilter)) continue;
                result.put(execution.getArtifactId(), execution);
            }
            return result;
        }
    }
}

