/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.Clazz;
import org.codehaus.mojo.animal_sniffer.RegexUtils;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.logging.PrintWriterLogger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class SignatureChecker
extends ClassFileVisitor {
    private final Map classes = new HashMap();
    private final Logger logger;
    private final Set ignoredPackages = new HashSet();
    private boolean hadError = false;

    public static void main(String[] args) throws Exception {
        HashSet<String> ignoredPackages = new HashSet<String>();
        ignoredPackages.add("org.jvnet.animal_sniffer.*");
        ignoredPackages.add("org.codehaus.mojo.animal_sniffer.*");
        ignoredPackages.add("org.objectweb.*");
        new SignatureChecker(new FileInputStream("signature"), ignoredPackages, new PrintWriterLogger(System.out)).process(new File("target/classes"));
    }

    public SignatureChecker(InputStream in, Set ignoredPackages, Logger logger) throws IOException {
        Iterator i = ignoredPackages.iterator();
        while (i.hasNext()) {
            String wildcard = (String)i.next();
            this.ignoredPackages.add(RegexUtils.compileWildcard(wildcard.replace('.', '/')));
        }
        this.logger = logger;
        try {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(in));
            while (true) {
                Clazz c;
                if ((c = (Clazz)ois.readObject()) == null) {
                    return;
                }
                this.classes.put(c.getName(), c);
            }
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    protected void process(final String name, InputStream image) throws IOException {
        ClassReader cr = new ClassReader(image);
        final HashSet warned = new HashSet();
        cr.accept((ClassVisitor)new EmptyVisitor(){

            public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
                return new EmptyVisitor(){
                    boolean ignoreError = false;

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (desc.equals("Lorg/jvnet/animal_sniffer/IgnoreJRERequirement;")) {
                            this.ignoreError = true;
                        }
                        if (desc.equals("Lorg/codehaus/mojo/animal_sniffer/IgnoreJRERequirement;")) {
                            this.ignoreError = true;
                        }
                        return super.visitAnnotation(desc, visible);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        this.check(owner, name + desc);
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        if (this.shouldBeIgnored(type)) {
                            return;
                        }
                        if (type.startsWith("[")) {
                            return;
                        }
                        Clazz sigs = (Clazz)SignatureChecker.this.classes.get(type);
                        if (sigs == null) {
                            this.error("Undefined reference: " + type);
                        }
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        this.check(owner, name + '#' + desc);
                    }

                    private void check(String owner, String sig) {
                        if (this.shouldBeIgnored(owner)) {
                            return;
                        }
                        if (this.find((Clazz)SignatureChecker.this.classes.get(owner), sig)) {
                            return;
                        }
                        this.error("Undefined reference: " + owner + '.' + sig);
                    }

                    private boolean shouldBeIgnored(String type) {
                        if (this.ignoreError) {
                            return true;
                        }
                        if (type.startsWith("[")) {
                            return true;
                        }
                        Iterator i = SignatureChecker.this.ignoredPackages.iterator();
                        while (i.hasNext()) {
                            Pattern pattern = (Pattern)i.next();
                            if (!pattern.matcher(type).matches()) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }

            private boolean find(Clazz c, String sig) {
                if (c == null) {
                    return false;
                }
                if (c.getSignatures().contains(sig)) {
                    return true;
                }
                if (sig.startsWith("<")) {
                    return false;
                }
                if (this.find((Clazz)SignatureChecker.this.classes.get(c.getSuperClass()), sig)) {
                    return true;
                }
                if (c.getSuperInterfaces() != null) {
                    for (int i = 0; i < c.getSuperInterfaces().length; ++i) {
                        if (!this.find((Clazz)SignatureChecker.this.classes.get(c.getSuperInterfaces()[i]), sig)) continue;
                        return true;
                    }
                }
                return false;
            }

            private void error(String msg) {
                SignatureChecker.this.hadError = true;
                if (warned.add(msg)) {
                    SignatureChecker.this.logger.error(msg + " in " + name);
                }
            }
        }, 0);
    }

    public boolean isSignatureBroken() {
        return this.hadError;
    }
}

