/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:animal-sniffer-maven-plugin:1.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Animal Sniffer Maven Plugin", 0);
        this.append(sb, "Animal Sniffer Maven Plugin.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "build".equals(this.goal)) {
            this.append(sb, "animal-sniffer:build", 0);
            this.append(sb, "Generates an API Signature from at least one of: the java runtime, the module dependencies and the module classes.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "Where to find this modules classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "The classifier to add to the generated signatures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeClasses", 2);
                this.append(sb, "Classes to exclude from generating signatures of.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeDependencies", 2);
                this.append(sb, "A list of artifact patterns to exclude. Follows the pattern 'groupId:artifactId:type:classifier:version'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeClasses", 2);
                this.append(sb, "Classes to generate signatures of.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeDependencies", 2);
                this.append(sb, "A list of artifact patterns to include. Follows the pattern 'groupId:artifactId:type:classifier:version'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeJavaHome (Default: true)", 2);
                this.append(sb, "Should the signatures from java home be included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeModuleClasses (Default: true)", 2);
                this.append(sb, "Should the signatures from this module's classes be included..", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeSignatures", 2);
                this.append(sb, "A list of signatures to include.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome", 2);
                this.append(sb, "The java home to generate the signatures of, if not specified only the signatures of dependencies will be included. This parameter is overridden by javaHomeClassPath. This parameter overrides jdk and any java home specified by maven-toolchains-plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHomeClassPath", 2);
                this.append(sb, "Use this configuration option only if the automatic boot classpath detection does not work for the specific javaHome or jdk. For example, the automatic boot classpath detection does not work with Sun Java 1.1. This parameter overrides javaHome, jdk and the maven-toolchains-plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbcpdArtifactId (Default: java-boot-classpath-detector)", 2);
                this.append(sb, "The artifactId of the Java Boot Classpath Detector to use. The plugin's dependencies will be searched for a dependency of type jar with this artifactId and the groupId specified in jbcpdGroupId. The dependency should be a standalone executable jar file which outputs the java boot classpath as a single line separated using File.pathSeparatorChar or else exits with a non-zero return code if it cannot determine the java boot classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbcpdGroupId (Default: ${plugin.groupId})", 2);
                this.append(sb, "The groupId of the Java Boot Classpath Detector to use. The plugin's dependencies will be searched for a dependency of type jar with this groupId and the artifactId specified in jbcpdArtifactId. The dependency should be a standalone executable jar file which outputs the java boot classpath as a single line separated using File.pathSeparatorChar or else exits with a non-zero return code if it cannot determine the java boot classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdk", 2);
                this.append(sb, "The JDK Toolchain to use. This parameter can be overridden by javaHome or javaHomeClasspath. This parameter overrides any toolchain specified with maven-toolchains-plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Where to put the generated signatures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "signaturesName", 2);
                this.append(sb, "The name of the generated signatures.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipIfNoJavaHome (Default: false)", 2);
                this.append(sb, "Should no signatures be generated if no java home is available.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "animal-sniffer:check", 0);
            this.append(sb, "Checks the classes compiled by this module.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "ignoreDependencies (Default: true)", 2);
                this.append(sb, "Should dependencies be ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignores", 2);
                this.append(sb, "Class names to ignore signatures for (wildcards accepted).", 3);
                this.append(sb, "", 0);
                this.append(sb, "signature", 2);
                this.append(sb, "Signature module to use.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "animal-sniffer:help", 0);
            this.append(sb, "Display help information on animal-sniffer-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0animal-sniffer:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

