/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.animal_sniffer.SignatureBuilder;
import org.codehaus.mojo.animal_sniffer.ant.AntLogger;
import org.codehaus.mojo.animal_sniffer.ant.Ignore;
import org.codehaus.mojo.animal_sniffer.ant.Signature;

public class BuildSignaturesTask
extends Task {
    private File destfile;
    private Vector<Path> paths = new Vector();
    private Vector<Signature> signatures = new Vector();
    private Vector<Ignore> includeClasses = new Vector();
    private Vector<Ignore> excludeClasses = new Vector();

    public void setDestfile(File dest) {
        this.destfile = dest;
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public Signature createSignature() {
        Signature signature = new Signature();
        this.signatures.add(signature);
        return signature;
    }

    public Ignore createIncludeClasses() {
        Ignore result = new Ignore();
        this.includeClasses.add(result);
        return result;
    }

    public Ignore createExcludeClasses() {
        Ignore result = new Ignore();
        this.excludeClasses.add(result);
        return result;
    }

    protected void validate() {
        if (this.destfile == null) {
            throw new BuildException("destfile not set");
        }
        if (this.paths.size() < 1) {
            throw new BuildException("path not set");
        }
        for (Signature signature : this.signatures) {
            if (signature.getSrc() == null) {
                throw new BuildException("signature src not set");
            }
            if (signature.getSrc().isFile()) continue;
            throw new BuildException("signature " + signature.getSrc() + " does not exist");
        }
        for (Ignore tmp : this.includeClasses) {
            if (tmp.getClassName() != null) continue;
            throw new BuildException("includeClasses className not set");
        }
        for (Ignore tmp : this.excludeClasses) {
            if (tmp.getClassName() != null) continue;
            throw new BuildException("excludeClasses className not set");
        }
    }

    public void execute() throws BuildException {
        this.validate();
        try {
            Vector<FileInputStream> inStreams = new Vector<FileInputStream>();
            for (Signature signature : this.signatures) {
                this.log("Importing signatures from " + signature.getSrc());
                inStreams.add(new FileInputStream(signature.getSrc()));
            }
            SignatureBuilder builder = new SignatureBuilder(inStreams.toArray(new InputStream[0]), new FileOutputStream(this.destfile), new AntLogger(this));
            for (Ignore tmp : this.includeClasses) {
                builder.addInclude(tmp.getClassName());
            }
            for (Ignore tmp : this.excludeClasses) {
                builder.addExclude(tmp.getClassName());
            }
            for (Path path : this.paths) {
                String[] files;
                for (String file : files = path.list()) {
                    this.log("Capturing signatures from " + file, 2);
                    this.process(builder, new File(file));
                }
            }
            builder.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void process(SignatureBuilder builder, File f) throws IOException {
        if (f.exists()) {
            builder.process(f);
        }
    }
}

