/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.asm.shaded.ClassReader;
import org.codehaus.mojo.animal_sniffer.asm.shaded.ClassVisitor;
import org.codehaus.mojo.animal_sniffer.logging.Logger;

public class ClassListBuilder
extends ClassFileVisitor {
    private final Set<String> packages;

    public Set<String> getPackages() {
        return this.packages;
    }

    public ClassListBuilder(Set<String> packages, Logger logger) {
        super(logger);
        this.packages = packages;
    }

    public ClassListBuilder(Logger logger) {
        this(new HashSet<String>(), logger);
    }

    @Override
    protected void process(String name, InputStream image) throws IOException {
        try {
            ClassReader cr = new ClassReader(image);
            cr.accept(new ClassVisitor(589824){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    ClassListBuilder.this.packages.add(name.replace('/', '.'));
                }
            }, 0);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            this.logger.error("Bad class file " + name);
            throw new IOException("Bad class file " + name, e);
        }
    }
}

