/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.java9.java.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.codehaus.commons.compiler.java9.java.util.function.Consumer;
import org.codehaus.commons.nullanalysis.NotNullByDefault;

public class Stream<T> {
    private static final Class<?> java_util_stream_Stream = Stream.loadClass("java.util.stream.Stream");
    private static final Class<?> java_util_function_Consumer = Stream.loadClass("java.util.function.Consumer");
    private static final Method java_util_stream_Stream_forEach = Stream.getDeclaredMethod(java_util_stream_Stream, "forEach", java_util_function_Consumer);
    private final Object delegate;

    public Stream(Object delegate) {
        this.delegate = delegate;
    }

    public void forEach(final Consumer<? super T> action) {
        try {
            Object pi = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{java_util_function_Consumer}, new InvocationHandler(){

                @Override
                @NotNullByDefault(value=false)
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    assert (method.getName().equals("accept"));
                    assert (args.length == 1);
                    action.accept(args[0]);
                    return null;
                }
            });
            java_util_stream_Stream_forEach.invoke(this.delegate, pi);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Class<?> loadClass(String className) {
        try {
            return ClassLoader.getSystemClassLoader().loadClass(className);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Method getDeclaredMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        try {
            return declaringClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

