/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.compiler.io.InputStreams;
import org.codehaus.commons.compiler.io.Readers;
import org.codehaus.commons.compiler.jdk.util.ClassLoaders;
import org.codehaus.commons.compiler.jdk.util.JavaFileObjects;
import org.codehaus.commons.compiler.util.LineAndColumnTracker;
import org.codehaus.commons.compiler.util.reflect.ByteArrayClassLoader;
import org.codehaus.commons.nullanalysis.NotNullByDefault;
import org.codehaus.commons.nullanalysis.Nullable;

public class SimpleCompiler
extends Cookable
implements ISimpleCompiler {
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;
    @Nullable
    private ErrorHandler compileErrorHandler;
    @Nullable
    private WarningHandler warningHandler;
    @Nullable
    Map<String, byte[]> bytecodes;
    private final LineAndColumnTracker tracker = LineAndColumnTracker.create();
    private final SortedSet<Location> offsets = new TreeSet<Location>(new Comparator<Location>(){

        @Override
        @NotNullByDefault(value=false)
        public int compare(Location l1, Location l2) {
            return l1.getLineNumber() < l2.getLineNumber() ? -1 : (l1.getLineNumber() > l2.getLineNumber() ? 1 : l1.getColumnNumber() - l2.getColumnNumber());
        }
    });
    @Nullable
    private ClassLoader getClassLoaderCache;

    public Map<String, byte[]> getBytecodes() {
        return this.assertCooked();
    }

    private Map<String, byte[]> assertCooked() {
        Map<String, byte[]> result = this.bytecodes;
        if (result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        ClassLoader result = this.getClassLoaderCache;
        if (result != null) {
            return result;
        }
        final Map<String, byte[]> bytecode = this.getBytecodes();
        this.getClassLoaderCache = result = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new ByteArrayClassLoader(bytecode, SimpleCompiler.this.parentClassLoader);
            }
        });
        return this.getClassLoaderCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cook(final @Nullable String fileName, Reader r) throws CompileException, IOException {
        URI uri;
        this.tracker.reset();
        this.offsets.clear();
        r = Readers.trackLineAndColumn((Reader)r, (LineAndColumnTracker)this.tracker);
        try {
            uri = new URI("simplecompiler");
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
        final String text = Readers.readAll((Reader)r);
        SimpleJavaFileObject compilationUnit = new SimpleJavaFileObject(uri, JavaFileObject.Kind.SOURCE){

            @Override
            public boolean isNameCompatible(@Nullable String simpleName, @Nullable JavaFileObject.Kind kind) {
                return true;
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                return new StringReader(text);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return text;
            }

            @Override
            public String toString() {
                return String.valueOf(this.uri);
            }
        };
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new CompileException("JDK Java compiler not available - probably you're running a JRE, not a JDK", null);
        }
        final CompileException[] caughtCompileException = new CompileException[1];
        DiagnosticListener<JavaFileObject> dl = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(@Nullable Diagnostic<? extends JavaFileObject> diagnostic) {
                block9: {
                    assert (diagnostic != null);
                    Location loc = new Location(fileName, (int)((short)diagnostic.getLineNumber()), (int)((short)diagnostic.getColumnNumber()));
                    SortedSet<Location> hs = SimpleCompiler.this.offsets.headSet(loc);
                    if (!hs.isEmpty()) {
                        Location co = hs.last();
                        loc = new Location(co.getFileName(), loc.getLineNumber() - co.getLineNumber() + 1, loc.getLineNumber() == co.getLineNumber() ? loc.getColumnNumber() - co.getColumnNumber() + 1 : loc.getColumnNumber());
                    }
                    String message = diagnostic.getMessage(null) + " (" + diagnostic.getCode() + ")";
                    try {
                        switch (diagnostic.getKind()) {
                            case ERROR: {
                                ErrorHandler oceh = SimpleCompiler.this.compileErrorHandler;
                                if (oceh == null) {
                                    throw new CompileException(message, loc);
                                }
                                oceh.handleError(message, loc);
                                break;
                            }
                            case MANDATORY_WARNING: 
                            case WARNING: {
                                WarningHandler owh = SimpleCompiler.this.warningHandler;
                                if (owh == null) break;
                                owh.handleWarning(null, message, loc);
                                break;
                            }
                        }
                    }
                    catch (CompileException ce) {
                        if (caughtCompileException[0] != null) break block9;
                        caughtCompileException[0] = ce;
                    }
                }
            }
        };
        final HashMap classFiles = new HashMap();
        ForwardingJavaFileManager<JavaFileManager> fileManager = new ForwardingJavaFileManager<JavaFileManager>((JavaFileManager)ToolProvider.getSystemJavaCompiler().getStandardFileManager((DiagnosticListener<? super JavaFileObject>)dl, Locale.US, Charset.forName("UTF-8"))){

            @Override
            @NotNullByDefault(value=false)
            public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                if (!kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                    return super.list(location, packageName, kinds, recurse);
                }
                String namePrefix = packageName.isEmpty() ? "" : packageName.replace('.', '/') + '/';
                Map<String, URL> allSubresources = ClassLoaders.getSubresources(SimpleCompiler.this.parentClassLoader, namePrefix, false, recurse);
                ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(allSubresources.size());
                for (Map.Entry<String, URL> e : allSubresources.entrySet()) {
                    String name = e.getKey();
                    URL url = e.getValue();
                    if (!name.endsWith(".class")) continue;
                    result.add(JavaFileObjects.fromUrl(url, name, JavaFileObject.Kind.CLASS));
                }
                return result;
            }

            @Override
            @NotNullByDefault(value=false)
            public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
                String result = file.getName();
                return result.substring(0, result.lastIndexOf(46)).replace('/', '.');
            }

            @Override
            @NotNullByDefault(value=false)
            public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                if (location == StandardLocation.CLASS_OUTPUT) {
                    return (JavaFileObject)classFiles.get(className);
                }
                return super.getJavaFileForInput(location, className, kind);
            }

            @Override
            @NotNullByDefault(value=false)
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                if (location != StandardLocation.CLASS_OUTPUT) {
                    return super.getJavaFileForOutput(location, className, kind, sibling);
                }
                if (kind != JavaFileObject.Kind.CLASS) {
                    throw new UnsupportedOperationException();
                }
                SimpleJavaFileObject fileObject = new SimpleJavaFileObject(URI.create("bytearray:///" + className.replace('.', '/') + kind.extension), JavaFileObject.Kind.CLASS){
                    final ByteArrayOutputStream buffer;
                    {
                        this.buffer = new ByteArrayOutputStream();
                    }

                    @Override
                    public OutputStream openOutputStream() throws IOException {
                        return this.buffer;
                    }

                    @Override
                    public InputStream openInputStream() throws IOException {
                        return new ByteArrayInputStream(this.buffer.toByteArray());
                    }
                };
                classFiles.put(className, fileObject);
                return fileObject;
            }
        };
        try {
            if (!compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)dl, Collections.singletonList(this.debugSource ? "-g:source" + (this.debugLines ? ",lines" : "") + (this.debugVars ? ",vars" : "") : (this.debugLines ? "-g:lines" + (this.debugVars ? ",vars" : "") : (this.debugVars ? "-g:vars" : "-g:none"))), null, Collections.singleton(compilationUnit)).call().booleanValue()) {
                if (caughtCompileException[0] != null) {
                    throw caughtCompileException[0];
                }
                throw new CompileException("Compilation failed", null);
            }
        }
        catch (RuntimeException rte) {
            for (Throwable t = rte.getCause(); t != null; t = t.getCause()) {
                if (t instanceof CompileException) {
                    throw (CompileException)t;
                }
                if (!(t instanceof IOException)) continue;
                throw (IOException)t;
            }
            throw rte;
        }
        finally {
            fileManager.close();
        }
        HashMap<String, byte[]> bytecodes = new HashMap<String, byte[]>();
        for (Map.Entry e : classFiles.entrySet()) {
            byte[] bytes;
            String className = (String)e.getKey();
            JavaFileObject jfo = (JavaFileObject)e.getValue();
            InputStream is = jfo.openInputStream();
            try {
                bytes = InputStreams.readAll((InputStream)is);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            bytecodes.put(className, bytes);
        }
        this.bytecodes = bytecodes;
    }

    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    public void setParentClassLoader(@Nullable ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader != null ? parentClassLoader : Thread.currentThread().getContextClassLoader();
    }

    @Deprecated
    public void setParentClassLoader(@Nullable ClassLoader parentClassLoader, Class<?>[] auxiliaryClasses) {
        this.setParentClassLoader(parentClassLoader);
    }

    public void setCompileErrorHandler(@Nullable ErrorHandler compileErrorHandler) {
        this.compileErrorHandler = compileErrorHandler;
    }

    public void setWarningHandler(@Nullable WarningHandler warningHandler) {
        this.warningHandler = warningHandler;
    }

    protected void addOffset(@Nullable String fileName) {
        LineAndColumnTracker t = this.tracker;
        assert (t != null);
        this.offsets.add(new Location(fileName, t.getLineNumber(), t.getColumnNumber()));
    }
}

