/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.codehaus.commons.nullanalysis.Nullable;

public class JavaFileManagerClassLoader
extends ClassLoader {
    private final JavaFileManager javaFileManager;

    public JavaFileManagerClassLoader(JavaFileManager javaFileManager) {
        this.javaFileManager = javaFileManager;
    }

    public JavaFileManagerClassLoader(JavaFileManager javaFileManager, ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.javaFileManager = javaFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(@Nullable String className) throws ClassNotFoundException {
        byte[] ba;
        try {
            JavaFileObject classFile = this.javaFileManager.getJavaFileForInput(StandardLocation.CLASS_OUTPUT, className, JavaFileObject.Kind.CLASS);
            if (classFile == null) {
                throw new ClassNotFoundException(className);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = classFile.openInputStream();
            try {
                int count;
                byte[] buffer = new byte[8192];
                while ((count = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, count);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            ba = baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(className, ioe);
        }
        return this.defineClass(className, ba, 0, ba.length);
    }
}

