/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.commons.nullanalysis.Nullable;

public final class ClassLoaders {
    private ClassLoaders() {
    }

    public static Map<String, URL> getSubresources(@Nullable ClassLoader classLoader, String name, boolean includeDirectories) throws IOException {
        return ClassLoaders.getSubresources(classLoader, name, includeDirectories, true);
    }

    public static Map<String, URL> getSubresources(@Nullable ClassLoader classLoader, String name, boolean includeDirectories, boolean recurse) throws IOException {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        assert (classLoader != null);
        URL r = classLoader.getResource(name);
        if (r == null) {
            String protocol;
            if (name.startsWith("java/") && name.endsWith("/") && (r = classLoader.getResource("java/lang/Object.class")) != null && "jar".equalsIgnoreCase(protocol = r.getProtocol())) {
                JarURLConnection juc = (JarURLConnection)r.openConnection();
                juc.setUseCaches(false);
                URL jarFileUrl = juc.getJarFileURL();
                JarFile jarFile = juc.getJarFile();
                Map<String, URL> result = ClassLoaders.getSubresources(jarFileUrl, jarFile, name, includeDirectories, recurse);
                return result;
            }
            return Collections.emptyMap();
        }
        return ClassLoaders.getSubresourcesOf(r, name, includeDirectories, recurse);
    }

    public static Map<String, URL> getSubresourcesOf(URL root, String rootName, boolean includeDirectories) throws IOException {
        return ClassLoaders.getSubresourcesOf(root, rootName, includeDirectories, true);
    }

    public static Map<String, URL> getSubresourcesOf(URL root, String rootName, boolean includeDirectories, boolean recurse) throws IOException {
        String protocol = root.getProtocol();
        if ("jar".equalsIgnoreCase(protocol)) {
            JarURLConnection juc = (JarURLConnection)root.openConnection();
            juc.setUseCaches(false);
            if (!juc.getJarEntry().isDirectory()) {
                return Collections.singletonMap(rootName, root);
            }
            URL jarFileUrl = juc.getJarFileURL();
            JarFile jarFile = juc.getJarFile();
            Map<String, URL> result = ClassLoaders.getSubresources(jarFileUrl, jarFile, rootName, includeDirectories, recurse);
            if (includeDirectories) {
                result.put(rootName, root);
            }
            return result;
        }
        if ("file".equalsIgnoreCase(protocol)) {
            return ClassLoaders.getFileResources(root, rootName, includeDirectories, recurse);
        }
        return Collections.singletonMap(rootName, root);
    }

    private static Map<String, URL> getSubresources(URL jarFileUrl, JarFile jarFile, String namePrefix, boolean includeDirectories, boolean recurse) {
        HashMap<String, URL> result = new HashMap<String, URL>();
        for (JarEntry je : Collections.list(jarFile.entries())) {
            URL url;
            if (je.isDirectory() && !includeDirectories || !je.getName().startsWith(namePrefix) || !recurse && je.getName().indexOf(47, namePrefix.length()) != -1) continue;
            try {
                url = new URL("jar", null, jarFileUrl.toString() + "!/" + je.getName());
            }
            catch (MalformedURLException mue) {
                throw new AssertionError((Object)mue);
            }
            result.put(je.getName(), url);
        }
        return result;
    }

    private static Map<String, URL> getFileResources(URL fileUrl, String namePrefix, boolean includeDirectories, boolean recurse) {
        File file = new File(fileUrl.getFile());
        if (file.isFile()) {
            return Collections.singletonMap(namePrefix, fileUrl);
        }
        if (file.isDirectory()) {
            if (!namePrefix.isEmpty() && !namePrefix.endsWith("/")) {
                namePrefix = namePrefix + '/';
            }
            HashMap<String, URL> result = new HashMap<String, URL>();
            if (includeDirectories) {
                result.put(namePrefix, fileUrl);
            }
            for (File member : file.listFiles()) {
                String memberName = namePrefix + member.getName();
                URL memberUrl = ClassLoaders.fileUrl(member);
                if (recurse) {
                    result.putAll(ClassLoaders.getFileResources(memberUrl, memberName, includeDirectories, recurse));
                    continue;
                }
                if (!member.isFile()) continue;
                result.put(memberName, memberUrl);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private static URL fileUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException mue) {
            throw new AssertionError((Object)mue);
        }
    }
}

