/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.codehaus.commons.nullanalysis.NotNullByDefault;

@NotNullByDefault(value=false)
public class ByteArrayJavaFileManager<M extends JavaFileManager>
extends ForwardingJavaFileManager<M> {
    private final Map<JavaFileManager.Location, Map<JavaFileObject.Kind, Map<String, JavaFileObject>>> javaFiles = new HashMap<JavaFileManager.Location, Map<JavaFileObject.Kind, Map<String, JavaFileObject>>>();

    public ByteArrayJavaFileManager(M delegate) {
        super(delegate);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) {
        throw new UnsupportedOperationException("getFileForInput");
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) {
        throw new UnsupportedOperationException("getFileForOutput");
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        Map<String, JavaFileObject> kindJavaFiles;
        Map<JavaFileObject.Kind, Map<String, JavaFileObject>> locationJavaFiles = this.javaFiles.get(location);
        if (locationJavaFiles != null && (kindJavaFiles = locationJavaFiles.get((Object)kind)) != null) {
            return kindJavaFiles.get(className);
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        Map<String, JavaFileObject> kindJavaFiles;
        Map<JavaFileObject.Kind, Map<String, JavaFileObject>> locationJavaFiles = this.javaFiles.get(location);
        if (locationJavaFiles == null) {
            locationJavaFiles = new HashMap<JavaFileObject.Kind, Map<String, JavaFileObject>>();
            this.javaFiles.put(location, locationJavaFiles);
        }
        if ((kindJavaFiles = locationJavaFiles.get((Object)kind)) == null) {
            kindJavaFiles = new HashMap<String, JavaFileObject>();
            locationJavaFiles.put(kind, kindJavaFiles);
        }
        class StringWriterJavaFileObject
        extends SimpleJavaFileObject {
            final StringWriter buffer;

            StringWriterJavaFileObject(JavaFileObject.Kind kind) {
                super(URI.create("stringbuffer:///" + string.replace('.', '/') + kind.extension), kind);
                this.buffer = new StringWriter();
            }

            @Override
            public Writer openWriter() throws IOException {
                return this.buffer;
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                return new StringReader(this.buffer.toString());
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return this.buffer.getBuffer();
            }
        }
        SimpleJavaFileObject fileObject = kind == JavaFileObject.Kind.SOURCE ? new StringWriterJavaFileObject(kind) : new ByteArrayJavaFileObject(className, kind);
        kindJavaFiles.put(className, fileObject);
        return fileObject;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Map<JavaFileObject.Kind, Map<String, JavaFileObject>> locationFiles = this.javaFiles.get(location);
        if (locationFiles == null) {
            return super.list(location, packageName, kinds, recurse);
        }
        String prefix = packageName.isEmpty() ? "" : packageName + ".";
        int pl = prefix.length();
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (JavaFileObject.Kind kind : kinds) {
            Map<String, JavaFileObject> kindFiles = locationFiles.get((Object)kind);
            if (kindFiles == null) continue;
            for (Map.Entry<String, JavaFileObject> e : kindFiles.entrySet()) {
                String className = e.getKey();
                if (!className.startsWith(prefix) || !recurse && className.indexOf(46, pl) != -1) continue;
                result.add(e.getValue());
            }
        }
        return result;
    }

    public static class ByteArrayJavaFileObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        public ByteArrayJavaFileObject(String className, JavaFileObject.Kind kind) {
            super(URI.create("bytearray:///" + className.replace('.', '/') + kind.extension), kind);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.buffer;
        }

        public byte[] toByteArray() {
            return this.buffer.toByteArray();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.toByteArray());
        }
    }
}

